/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.entity.EntityDummyCaster;
import am2.extensions.EntityExtension;
import am2.utils.DummyEntityPlayer;
import am2.utils.SpellUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityGroundRuneSpell
extends TileEntity
implements ITickable {
    private ItemStack spellStack = null;
    private EntityPlayer caster = null;
    private String placedByName = null;
    private int numTriggers = 1;
    private boolean isPermanent = false;

    public void setSpellStack(ItemStack spellStack) {
        this.spellStack = spellStack.func_77946_l();
    }

    public ItemStack getSpellStack() {
        return this.spellStack;
    }

    public void setNumTriggers(int triggers) {
        this.numTriggers = triggers;
    }

    public int getNumTriggers() {
        return this.numTriggers;
    }

    public void setPermanent(boolean permanent) {
        this.isPermanent = permanent;
    }

    public boolean getPermanent() {
        return this.isPermanent;
    }

    private void prepForActivate() {
        if (this.placedByName != null) {
            this.caster = this.field_145850_b.func_72924_a(this.placedByName);
        }
        if (this.caster == null) {
            this.caster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_145850_b));
            EntityExtension.For((EntityLivingBase)this.caster).setMagicLevelWithMana(99);
        }
    }

    public boolean canApply(EntityLivingBase entity) {
        if (this.spellStack == null) {
            return false;
        }
        this.prepForActivate();
        return !entity.func_70005_c_().equals(this.placedByName);
    }

    public boolean applySpellEffect(EntityLivingBase target) {
        if (this.spellStack == null) {
            return false;
        }
        if (!this.canApply(target)) {
            return false;
        }
        this.prepForActivate();
        SpellUtils.applyStackStage(this.spellStack, (EntityLivingBase)this.caster, target, target.field_70165_t, target.field_70163_u, target.field_70161_v, null, this.field_145850_b, false, false, 0);
        return true;
    }

    public void setPlacedBy(EntityLivingBase caster) {
        if (caster instanceof EntityPlayer) {
            this.placedByName = ((EntityPlayer)caster).func_70005_c_();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.placedByName != null) {
            compound.func_74778_a("placedByName", this.placedByName);
        }
        if (this.spellStack != null) {
            compound.func_74782_a("spellStack", (NBTBase)this.spellStack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74768_a("numTrigger", this.numTriggers);
        compound.func_74757_a("permanent", this.isPermanent);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("placedByName")) {
            this.placedByName = compound.func_74779_i("placedByName");
        }
        if (compound.func_74764_b("spellStack")) {
            this.spellStack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("spellStack"));
        }
        this.numTriggers = compound.func_74762_e("numTrigger");
        this.isPermanent = compound.func_74767_n("permanent");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_73660_a() {
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }
}

