/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.blocks.tileentity.ITileEntityAMBase;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;

public class TileEntityManaBattery
extends TileEntityAMPower
implements ITileEntityAMBase {
    private boolean active = false;
    public static int storageCapacity = 250000;
    private PowerTypes outputPowerType = PowerTypes.NONE;
    private int tickCounter = 0;
    boolean hasUpdated = false;
    int prevEnergy;
    public boolean dirty = false;

    public TileEntityManaBattery() {
        super(storageCapacity);
    }

    public PowerTypes getPowerType() {
        return this.outputPowerType;
    }

    public void setPowerType(PowerTypes type, boolean forceSubNodes) {
        this.outputPowerType = type;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            this.setPowerRequests();
        } else {
            this.setNoPowerRequests();
        }
        if (!this.field_145850_b.field_72995_K) {
            PowerTypes highest = PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this);
            float amt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, highest);
            if (amt > 0.0f) {
                if (this.outputPowerType != highest) {
                    this.outputPowerType = highest;
                    this.tickCounter = 0;
                }
            } else if (this.outputPowerType != PowerTypes.NONE) {
                this.outputPowerType = PowerTypes.NONE;
                this.tickCounter = 0;
            }
        }
        this.func_70296_d();
        this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_145831_w().func_180496_d(this.func_174877_v(), this.func_145838_q());
        super.func_73660_a();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("isActive", this.active);
        nbttagcompound.func_74768_a("outputType", this.outputPowerType.ID());
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.active = nbttagcompound.func_74767_n("isActive");
        if (nbttagcompound.func_74764_b("outputType")) {
            this.outputPowerType = PowerTypes.getByID(nbttagcompound.func_74762_e("outputType"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public int getChargeRate() {
        return 1000;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        if (this.outputPowerType == PowerTypes.NONE) {
            return PowerTypes.all();
        }
        return Lists.newArrayList((Object[])new PowerTypes[]{this.outputPowerType});
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public void markForUpdate() {
        this.dirty = true;
    }

    @Override
    public boolean needsUpdate() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

