/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.IMultiblockStructureController;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.blocks.BlockArsMagicaBlock;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.defs.BlockDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityManaDrain
extends TileEntityAMPower
implements IMultiblockStructureController {
    private MultiblockStructureDefinition multiblock = new MultiblockStructureDefinition("mana_drain");

    public TileEntityManaDrain() {
        super(10000);
        this.setupMultiblock();
    }

    private void setupMultiblock() {
        MultiblockGroup walls = new MultiblockGroup("walls", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.magicWall.func_176223_P()}), false);
        walls.addBlock(new BlockPos(-1, 0, -1));
        walls.addBlock(new BlockPos(-1, 0, 0));
        walls.addBlock(new BlockPos(-1, 0, 1));
        walls.addBlock(new BlockPos(0, 0, -1));
        walls.addBlock(new BlockPos(0, 0, 1));
        walls.addBlock(new BlockPos(1, 0, -1));
        walls.addBlock(new BlockPos(1, 0, 0));
        walls.addBlock(new BlockPos(1, 0, 1));
        MultiblockGroup pillars = new MultiblockGroup("pillars", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150371_ca.func_176223_P().func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Y)}), false);
        pillars.addBlock(new BlockPos(-2, 1, 0));
        pillars.addBlock(new BlockPos(2, 1, 0));
        pillars.addBlock(new BlockPos(0, 1, -2));
        pillars.addBlock(new BlockPos(0, 1, 2));
        pillars.addBlock(new BlockPos(-2, 2, 0));
        pillars.addBlock(new BlockPos(2, 2, 0));
        pillars.addBlock(new BlockPos(0, 2, -2));
        pillars.addBlock(new BlockPos(0, 2, 2));
        MultiblockGroup caps = new MultiblockGroup("caps", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.BLUETOPAZ))}), false);
        caps.addBlock(new BlockPos(-2, 3, 0));
        caps.addBlock(new BlockPos(2, 3, 0));
        caps.addBlock(new BlockPos(0, 3, -2));
        caps.addBlock(new BlockPos(0, 3, 2));
        MultiblockGroup drain = new MultiblockGroup("drain", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.manaDrain.func_176223_P()}), true);
        drain.addBlock(BlockPos.field_177992_a);
        this.multiblock.addGroup(walls, new MultiblockGroup[0]);
        this.multiblock.addGroup(pillars, new MultiblockGroup[0]);
        this.multiblock.addGroup(caps, new MultiblockGroup[0]);
        this.multiblock.addGroup(drain, new MultiblockGroup[0]);
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) == 0 ? 0 : 500;
    }

    @Override
    public void func_73660_a() {
        AMParticle particle;
        super.func_73660_a();
        if (!this.isMultiblockComplete()) {
            return;
        }
        if (PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL) == (float)this.capacity) {
            return;
        }
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 1, -1), this.field_174879_c.func_177982_a(2, 4, 2)));
        boolean isWorking = false;
        for (EntityLivingBase entity : entities) {
            EntityExtension ext = EntityExtension.For(entity);
            if (ext == null) continue;
            if (this.field_145850_b.func_175687_A(this.field_174879_c) == 0) {
                isWorking = true;
                if (this.field_145850_b.field_72995_K) continue;
                float drain = ext.getMaxMana() / 100.0f;
                if (drain < 1.0f) {
                    drain = 1.0f;
                }
                if (ext.getCurrentMana() >= drain) {
                    PowerNodeRegistry.For(this.field_145850_b).setPower(this, PowerTypes.NEUTRAL, PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL) + drain * 10.0f);
                    ext.setCurrentMana(ext.getCurrentMana() - drain);
                    continue;
                }
                if (entity.field_70173_aa % 20 != 0) continue;
                entity.func_70097_a((DamageSource)DamageSources.causeHolyDamage(null), 1.0f);
                PowerNodeRegistry.For(this.field_145850_b).setPower(this, PowerTypes.NEUTRAL, PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL) + 40.0f);
                continue;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            isWorking = true;
            if (this.field_145850_b.field_72995_K) continue;
            float toConsume = PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL) / 10.0f;
            if (toConsume > 10.0f) {
                toConsume = 10.0f;
            }
            if (toConsume + ext.getCurrentMana() > ext.getMaxMana()) {
                toConsume = ext.getMaxMana() - ext.getCurrentMana();
            }
            ext.setCurrentMana(ext.getCurrentMana() + toConsume);
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.NEUTRAL, toConsume * 10.0f);
        }
        if (this.field_145850_b.field_72995_K && isWorking && (particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "sparkle2", (double)(this.field_174879_c.func_177958_n() - 1) + this.field_145850_b.field_73012_v.nextDouble() * 3.0, this.field_174879_c.func_177956_o() + 2, (double)(this.field_174879_c.func_177952_p() - 1) + this.field_145850_b.field_73012_v.nextDouble() * 3.0))) != null) {
            particle.setRGBColorI(43775);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.1f, this.field_145850_b.func_175687_A(this.field_174879_c) == 0 ? -0.05f : 0.05f, 1, false));
        }
    }

    private boolean isMultiblockComplete() {
        return this.multiblock.matches(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return this.field_145850_b.func_175687_A(this.field_174879_c) == 0 && type == PowerTypes.NEUTRAL;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.NEUTRAL});
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.multiblock;
    }
}

