/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ObeliskFuelHelper;
import am2.api.IMultiblockStructureController;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.blocks.tileentity.ITileEntityAMBase;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.buffs.BuffEffectManaRegen;
import am2.defs.BlockDefs;
import am2.defs.PotionEffectsDefs;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.utils.InventoryUtilities;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityObelisk
extends TileEntityAMPower
implements IMultiblockStructureController,
IInventory,
ITileEntityAMBase {
    protected static int pillarBlockID = 98;
    protected static int pillarBlockMeta = 3;
    protected int surroundingCheckTicks;
    private ItemStack[] inventory;
    protected float powerMultiplier = 1.0f;
    protected float powerBase = 5.0f;
    public float offsetY = 0.0f;
    public float lastOffsetY = 0.0f;
    public int burnTimeRemaining = 0;
    public int maxBurnTime = 1;
    private static final byte PK_BURNTIME_CHANGE = 1;
    protected MultiblockStructureDefinition structure;
    protected MultiblockGroup wizardChalkCircle;
    protected MultiblockGroup pillars;
    protected HashMap<IBlockState, Float> caps;
    protected TypedMultiblockGroup capsGroup;
    protected MultiblockStructureDefinition[] rituals;
    protected MultiblockGroup ritual1Chalk;
    protected MultiblockGroup ritual1Candles;
    protected MultiblockGroup ritual2Chalk;
    protected MultiblockGroup ritual2Candles;
    private boolean dirty = false;

    protected HashMap<Integer, IBlockState> createMap(IBlockState state) {
        HashMap<Integer, IBlockState> states = new HashMap<Integer, IBlockState>();
        states.put(0, state);
        return states;
    }

    public TileEntityObelisk() {
        this(5000);
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    protected void checkNearbyBlockState() {
        List<MultiblockGroup> groups = this.structure.getMatchingGroups(this.field_145850_b, this.field_174879_c);
        float capsLevel = 1.0f;
        boolean pillarsFound = false;
        boolean wizChalkFound = false;
        boolean capsFound = false;
        for (MultiblockGroup group : groups) {
            if (group == this.pillars) {
                pillarsFound = true;
                continue;
            }
            if (group == this.wizardChalkCircle) {
                wizChalkFound = true;
                continue;
            }
            if (group != this.capsGroup) continue;
            capsFound = true;
        }
        if (pillarsFound && capsFound) {
            IBlockState capState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 2, 2));
            for (IBlockState cap : this.caps.keySet()) {
                if (capState != cap) continue;
                capsLevel = this.caps.get(cap).floatValue();
                break;
            }
        }
        this.powerMultiplier = 1.0f;
        if (wizChalkFound) {
            this.powerMultiplier = 1.25f;
        }
        if (pillarsFound) {
            this.powerMultiplier *= capsLevel;
        }
    }

    public TileEntityObelisk(int capacity) {
        super(capacity);
        this.setNoPowerRequests();
        this.surroundingCheckTicks = 0;
        this.structure = new MultiblockStructureDefinition("obelisk_structure");
        this.pillars = new MultiblockGroup("pillars", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150417_aV.func_176223_P()}), false);
        this.caps = new HashMap();
        this.capsGroup = new TypedMultiblockGroup("caps", Lists.newArrayList((Object[])new HashMap[]{this.createMap(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED))}), false);
        this.caps.put(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), Float.valueOf(1.35f));
        MultiblockGroup obelisk = new MultiblockGroup("obelisk", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.obelisk.func_176223_P()}), true);
        obelisk.addBlock(BlockPos.field_177992_a);
        this.pillars.addBlock(new BlockPos(-2, 0, -2));
        this.pillars.addBlock(new BlockPos(-2, 1, -2));
        this.capsGroup.addBlock(new BlockPos(-2, 2, -2), 0);
        this.pillars.addBlock(new BlockPos(2, 0, -2));
        this.pillars.addBlock(new BlockPos(2, 1, -2));
        this.capsGroup.addBlock(new BlockPos(2, 2, -2), 0);
        this.pillars.addBlock(new BlockPos(-2, 0, 2));
        this.pillars.addBlock(new BlockPos(-2, 1, 2));
        this.capsGroup.addBlock(new BlockPos(-2, 2, 2), 0);
        this.pillars.addBlock(new BlockPos(2, 0, 2));
        this.pillars.addBlock(new BlockPos(2, 1, 2));
        this.capsGroup.addBlock(new BlockPos(2, 2, 2), 0);
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure);
        this.structure.addGroup(this.pillars, new MultiblockGroup[0]);
        this.structure.addGroup(this.capsGroup, new MultiblockGroup[0]);
        this.structure.addGroup(this.wizardChalkCircle, new MultiblockGroup[0]);
        this.structure.addGroup(obelisk, new MultiblockGroup[0]);
        this.rituals = new MultiblockStructureDefinition[2];
        this.rituals[0] = new MultiblockStructureDefinition("obelisk_light");
        this.ritual1Candles = new MultiblockGroup("candles", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wardingCandle.func_176223_P()}), false);
        this.ritual1Candles.addBlock(new BlockPos(-2, 0, -2));
        this.ritual1Candles.addBlock(new BlockPos(2, 0, 2));
        this.ritual1Candles.addBlock(new BlockPos(2, 0, -2));
        this.ritual1Candles.addBlock(new BlockPos(-2, 0, 2));
        this.rituals[0].addGroup(this.ritual1Candles, new MultiblockGroup[0]);
        this.rituals[1] = new MultiblockStructureDefinition("obelisk_dark");
    }

    public boolean isActive() {
        return this.burnTimeRemaining > 0 || this.inventory[0] != null && ObeliskFuelHelper.instance.getFuelBurnTime(this.inventory[0]) > 0;
    }

    public boolean isHighPowerActive() {
        return this.burnTimeRemaining > 200 && this.inventory[0] != null;
    }

    public int getCookProgressScaled(int par1) {
        return this.burnTimeRemaining * par1 / this.maxBurnTime;
    }

    protected MultiblockGroup addWizChalkGroupToStructure(MultiblockStructureDefinition def) {
        MultiblockGroup group = new MultiblockGroup("wizardChalkCircle", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wizardChalk.func_176223_P()}), true);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                group.addBlock(new BlockPos(i, 0, j));
            }
        }
        return group;
    }

    protected void callSuperUpdate() {
        super.func_73660_a();
    }

    private void setMaxBurnTime(int burnTime) {
        if (burnTime == 0) {
            burnTime = 1;
        }
        this.maxBurnTime = burnTime;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private void sendCookUpdateToClients() {
        if (!this.field_145850_b.field_72995_K) {
            AMNetHandler.INSTANCE.sendObeliskUpdate(this, new AMDataWriter().add((byte)1).add(this.burnTimeRemaining).generate());
        }
    }

    public void handlePacket(byte[] data) {
        AMDataReader rdr = new AMDataReader(data);
        if (rdr.ID == 1) {
            this.burnTimeRemaining = rdr.getInt();
        }
    }

    @Override
    public void func_73660_a() {
        ++this.surroundingCheckTicks;
        if (this.isActive()) {
            if (!this.field_145850_b.field_72995_K && this.surroundingCheckTicks % 100 == 0) {
                this.checkNearbyBlockState();
                this.surroundingCheckTicks = 1;
                if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                    List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, 0, -2), this.field_174879_c.func_177982_a(2, 3, 2)));
                    for (EntityPlayer p : nearbyPlayers) {
                        if (p.func_70644_a(PotionEffectsDefs.manaRegen)) continue;
                        p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 1));
                    }
                }
            }
            float powerAmt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL);
            float powerAdded = this.inventory[0] != null ? (float)ObeliskFuelHelper.instance.getFuelBurnTime(this.inventory[0]) * (this.powerBase * this.powerMultiplier) : 0.0f;
            float chargeThreshold = Math.max(this.getCapacity() - powerAdded, this.getCapacity() * 0.75f);
            if (this.burnTimeRemaining <= 0 && powerAmt < chargeThreshold) {
                this.burnTimeRemaining = ObeliskFuelHelper.instance.getFuelBurnTime(this.inventory[0]);
                if (this.burnTimeRemaining > 0) {
                    this.setMaxBurnTime(this.burnTimeRemaining);
                    if (this.inventory[0].func_77973_b() instanceof UniversalBucket) {
                        this.inventory[0] = ((UniversalBucket)this.inventory[0].func_77973_b()).getEmpty().func_77946_l();
                    } else if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
                        this.inventory[0] = new ItemStack(this.inventory[0].func_77973_b().func_77668_q());
                    } else {
                        InventoryUtilities.decrementStackQuantity(this, 0, 1);
                    }
                    this.sendCookUpdateToClients();
                }
            }
            if (this.burnTimeRemaining > 0) {
                --this.burnTimeRemaining;
                PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.NEUTRAL, this.powerBase * this.powerMultiplier);
                if (this.burnTimeRemaining % 20 == 0) {
                    this.sendCookUpdateToClients();
                }
            }
        } else {
            this.surroundingCheckTicks = 1;
        }
        if (this.field_145850_b.field_72995_K) {
            this.lastOffsetY = this.offsetY;
            this.offsetY = (float)Math.max(Math.sin((float)this.field_145850_b.func_82737_E() / 20.0f) / 5.0, 0.25);
            if (this.burnTimeRemaining > 0) {
                --this.burnTimeRemaining;
            }
        }
        this.func_70296_d();
        super.func_73660_a();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)this.field_174879_c.func_177956_o() + 0.3, (double)(this.field_174879_c.func_177952_p() + 2));
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    public MultiblockStructureDefinition getRitual(int index) {
        return this.rituals[index];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining);
        nbttagcompound.func_74768_a("maxBurnTime", this.maxBurnTime);
        if (this.inventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a(tag, (byte)i);
                this.inventory[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("BurnInventory", (NBTBase)nbttaglist);
        }
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.burnTimeRemaining = nbttagcompound.func_74762_e("burnTimeRemaining");
        this.setMaxBurnTime(nbttagcompound.func_74762_e("maxBurnTime"));
        if (nbttagcompound.func_74764_b("BurnInventory")) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("BurnInventory", 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c(tag);
                if (byte0 < 0 || byte0 >= this.inventory.length) continue;
                this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    @Override
    public int getChargeRate() {
        return 0;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.NEUTRAL;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.NEUTRAL});
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "obelisk";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return ObeliskFuelHelper.instance.getFuelBurnTime(itemstack) > 0;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public void markForUpdate() {
        this.dirty = true;
    }

    @Override
    public boolean needsUpdate() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }
}

