/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.math.AMVector3;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.blocks.tileentity.TileEntityCraftingAltar;
import am2.defs.ItemDefs;
import am2.entity.EntityShadowHelper;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.utils.InventoryUtilities;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityOtherworldAura
extends TileEntityAMPower {
    private ArrayList<PowerTypes> valid = Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.DARK, PowerTypes.NEUTRAL});
    private ArrayList<AMVector3> nearbyInventories;
    private boolean active;
    private TileEntityCraftingAltar watchTarget;
    private int delayCounter;
    private String placedByUsername = "";
    private EntityShadowHelper helper;

    public TileEntityOtherworldAura() {
        super(200);
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 100;
    }

    public ArrayList<PowerTypes> getValidPowerTypes() {
        return this.valid;
    }

    public void setActive(boolean active, TileEntityCraftingAltar watchMe) {
        if (active && this.active) {
            return;
        }
        this.active = active;
        if (active) {
            this.refreshNearbyInventories();
            this.watchTarget = watchMe;
        } else {
            this.nearbyInventories = null;
            this.watchTarget = null;
            if (this.helper != null) {
                this.helper.unSummon();
                this.helper = null;
            }
        }
    }

    private void refreshNearbyInventories() {
        this.nearbyInventories = new ArrayList();
        int radius = 6;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(i, j, k))) == null || !(te instanceof IInventory)) continue;
                    this.nearbyInventories.add(new AMVector3(te));
                }
            }
        }
    }

    private AMVector3 findInNearbyInventories(ItemStack search) {
        Iterator<AMVector3> it = this.nearbyInventories.iterator();
        while (it.hasNext()) {
            AMVector3 vec = it.next();
            TileEntity te = this.field_145850_b.func_175625_s(vec.toBlockPos());
            if (te == null || !(te instanceof IInventory)) {
                it.remove();
                continue;
            }
            IInventory inventory = (IInventory)te;
            for (EnumFacing facing : EnumFacing.values()) {
                if (!InventoryUtilities.inventoryHasItem(inventory, search, 1, facing)) continue;
                return vec;
            }
        }
        return null;
    }

    private void spawnHelper() {
        if (this.helper != null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.helper = new EntityShadowHelper(this.field_145850_b);
        this.helper.func_70107_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
        if (this.watchTarget != null) {
            this.helper.setAltarTarget(this.watchTarget);
        }
        this.field_145850_b.func_72838_d((Entity)this.helper);
        if (this.watchTarget != null) {
            this.helper.setDropoffLocation(new AMVector3(this.watchTarget.func_174877_v().func_177979_c(2)));
            if (this.placedByUsername != null && !this.placedByUsername.isEmpty()) {
                this.helper.setMimicUser(this.placedByUsername);
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.nearbyInventories == null) {
            return;
        }
        if (this.watchTarget == null || !this.watchTarget.isCrafting()) {
            this.setActive(false, null);
            return;
        }
        if (this.helper != null && this.helper.field_70128_L) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 1.25f)) {
                if (this.delayCounter-- <= 0) {
                    ItemStack next;
                    if (this.helper == null) {
                        this.spawnHelper();
                    }
                    if ((next = this.watchTarget.getNextPlannedItem()) == null) {
                        this.setActive(false, null);
                        return;
                    }
                    if (next.func_77973_b() == ItemDefs.etherium) {
                        if (!this.helper.hasSearchLocation()) {
                            this.helper.setSearchLocationAndItem(new AMVector3(1.0, 1.0, 1.0), next);
                        }
                        this.delayCounter = 100;
                    } else {
                        AMVector3 location = this.findInNearbyInventories(next);
                        if (location == null) {
                            this.delayCounter = 20;
                            return;
                        }
                        if (!this.helper.hasSearchLocation()) {
                            this.helper.setSearchLocationAndItem(location, next);
                        }
                        this.delayCounter = 20;
                    }
                }
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 1.25f);
            } else if (this.helper != null) {
                this.helper.unSummon();
            }
        }
    }

    public void setPlacedByUsername(String userName) {
        this.placedByUsername = userName;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("placedBy", this.placedByUsername);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.placedByUsername = nbttagcompound.func_74779_i("placedBy");
    }
}

