/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.blocks.IKeystoneLockable;
import am2.api.items.ISpellFocus;
import am2.api.items.ItemFilterFocus;
import am2.blocks.BlockSeerStone;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.defs.BlockDefs;
import am2.models.SpriteRenderInfo;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.utils.KeystoneUtilities;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class TileEntitySeerStone
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable<TileEntitySeerStone> {
    private boolean hasSight = false;
    private ArrayList<SpriteRenderInfo> animations;
    private ArrayList<Integer> animationWeighting;
    private SpriteRenderInfo currentAnimation;
    private int ticksToNextCheck;
    private int maxTicksToCheck = 20;
    private ItemStack[] inventory;
    int tickCounter = 0;
    public static int keystoneSlot = 1;
    private List<PowerTypes> validTypes = Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.LIGHT});
    boolean swapDetectionMode = false;

    public TileEntitySeerStone() {
        super(100);
        this.animations = new ArrayList();
        this.animationWeighting = new ArrayList();
        this.animations.add(new SpriteRenderInfo(50, 59, 2));
        this.animationWeighting.add(0);
        this.animations.add(new SpriteRenderInfo(20, 29, 2));
        this.animationWeighting.add(60);
        this.animations.add(new SpriteRenderInfo(30, 39, 2));
        this.animationWeighting.add(11);
        this.animations.add(new SpriteRenderInfo(40, 49, 2));
        this.animationWeighting.add(11);
        this.animations.add(new SpriteRenderInfo(0, 14, 2));
        this.animationWeighting.add(6);
        this.animations.add(new SpriteRenderInfo(60, 74, 2));
        this.animationWeighting.add(6);
        this.animations.add(new SpriteRenderInfo(80, 94, 2));
        this.animationWeighting.add(6);
        this.currentAnimation = this.animations.get(0);
        this.currentAnimation.isDone = true;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.ticksToNextCheck = this.maxTicksToCheck;
    }

    @Override
    public float particleOffset(int axis) {
        EnumFacing meta = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSeerStone.FACING);
        if (axis == 0) {
            switch (meta) {
                case UP: {
                    return 0.15f;
                }
                case DOWN: {
                    return 0.85f;
                }
            }
            return 0.5f;
        }
        if (axis == 1) {
            switch (meta) {
                case EAST: {
                    return 0.85f;
                }
                case WEST: {
                    return 0.2f;
                }
            }
            return 0.5f;
        }
        if (axis == 2) {
            switch (meta) {
                case NORTH: {
                    return 0.15f;
                }
                case SOUTH: {
                    return 0.85f;
                }
            }
            return 0.5f;
        }
        return 0.5f;
    }

    public void invertDetection() {
        this.swapDetectionMode = !this.swapDetectionMode;
    }

    public boolean isInvertingDetection() {
        return this.swapDetectionMode;
    }

    private SpriteRenderInfo GetWeightedRandomAnimation() {
        this.currentAnimation.reset(false);
        int randomNumber = this.field_145850_b.field_73012_v.nextInt(100);
        int index = 0;
        SpriteRenderInfo current = this.animations.get(0);
        for (Integer i : this.animationWeighting) {
            if (randomNumber < i) {
                current = this.animations.get(index);
                break;
            }
            ++index;
            randomNumber -= i.intValue();
        }
        return current == this.animations.get(0) ? this.animations.get(1) : current;
    }

    public boolean isActive() {
        if (this.field_145850_b == null) {
            return false;
        }
        return PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.hasSight ? 2.0f : 1.0f) && this.GetSearchRadius() > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            if (this.hasSight) {
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, 0.25f);
            } else {
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, 0.125f);
            }
        }
        --this.ticksToNextCheck;
        if (this.ticksToNextCheck <= 0 && this.isActive()) {
            this.ticksToNextCheck = this.maxTicksToCheck;
            long key = KeystoneUtilities.instance.getKeyFromRunes(this.getRunesInKey());
            int radius = this.GetSearchRadius();
            Class<? extends Entity> searchClass = this.GetSearchClass();
            ArrayList nearbyMobs = new ArrayList();
            if (searchClass != null) {
                nearbyMobs = (ArrayList)this.field_145850_b.func_72872_a(searchClass, new AxisAlignedBB(this.field_174879_c.func_177982_a(-radius, -radius, -radius), this.field_174879_c.func_177982_a(1 + radius, 1 + radius, 1 + radius)));
                if (key > 0L) {
                    ArrayList<Entity> mobsToIgnore = new ArrayList<Entity>();
                    for (Entity e : nearbyMobs) {
                        if (this.swapDetectionMode) {
                            if (!(e instanceof EntityPlayer)) {
                                mobsToIgnore.add(e);
                                continue;
                            }
                            if (KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)e).contains(key)) continue;
                            mobsToIgnore.add(e);
                            continue;
                        }
                        if (!(e instanceof EntityPlayer) || !KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)e).contains(key)) continue;
                        mobsToIgnore.add(e);
                    }
                    for (Entity e : mobsToIgnore) {
                        nearbyMobs.remove(e);
                    }
                }
            }
            if (nearbyMobs.size() > 0) {
                if (!this.hasSight) {
                    this.hasSight = true;
                    this.notifyNeighborsOfPowerChange();
                    if (this.field_145850_b.field_72995_K) {
                        this.currentAnimation.reset(false);
                        this.currentAnimation = this.animations.get(0);
                        this.currentAnimation.reset(true);
                    }
                }
            } else if (this.hasSight) {
                this.hasSight = false;
                this.notifyNeighborsOfPowerChange();
                if (this.field_145850_b.field_72995_K) {
                    this.currentAnimation.reset(false);
                    this.currentAnimation = this.animations.get(0);
                    this.currentAnimation.reset(false);
                }
            }
        } else if (this.hasSight && !this.isActive()) {
            this.hasSight = false;
            this.notifyNeighborsOfPowerChange();
            if (this.field_145850_b.field_72995_K) {
                this.currentAnimation.reset(false);
                this.currentAnimation = this.animations.get(0);
                this.currentAnimation.reset(false);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.currentAnimation.isDone) {
                ++this.tickCounter;
                if (this.tickCounter == this.currentAnimation.speed) {
                    this.tickCounter = 0;
                    this.currentAnimation.incrementIndex();
                }
            } else if (this.isActive() && this.hasSight) {
                this.currentAnimation = this.GetWeightedRandomAnimation();
            }
            if (this.isActive() && this.hasSight) {
                EnumFacing meta = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSeerStone.FACING);
                double yaw = 0.0;
                double y = (double)this.field_174879_c.func_177958_n() + 0.5;
                double x = (double)this.field_174879_c.func_177956_o() + 0.5;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                switch (meta) {
                    case UP: {
                        y += 0.3;
                        break;
                    }
                    case DOWN: {
                        y -= 0.3;
                        break;
                    }
                    case EAST: {
                        yaw = 270.0;
                        z += 0.3;
                        break;
                    }
                    case WEST: {
                        yaw = 90.0;
                        z -= 0.3;
                        break;
                    }
                    case NORTH: {
                        yaw = 180.0;
                        x += 0.3;
                        break;
                    }
                    case SOUTH: {
                        yaw = 0.0;
                        x -= 0.3;
                    }
                }
                AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "sparkle2", x, y, z));
                if (effect != null) {
                    effect.setIgnoreMaxAge(false);
                    effect.func_187114_a(35);
                    switch (meta) {
                        case UP: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, -0.01f, 1, false));
                            break;
                        }
                        case DOWN: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, 0.01f, 1, false));
                            break;
                        }
                        default: {
                            effect.AddParticleController(new ParticleMoveOnHeading(effect, yaw, 0.0, 0.01f, 1, false));
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, 0.0f, 1, false));
                        }
                    }
                }
            }
        }
    }

    private void notifyNeighborsOfPowerChange() {
        this.field_145850_b.func_180496_d(this.field_174879_c, BlockDefs.seerStone);
        BlockPos otherPos = this.field_174879_c.func_177972_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSeerStone.FACING));
        this.field_145850_b.func_180496_d(otherPos, BlockDefs.seerStone);
        this.field_145850_b.markAndNotifyBlock(otherPos, this.field_145850_b.func_175726_f(otherPos), this.field_145850_b.func_180495_p(otherPos), this.field_145850_b.func_180495_p(otherPos), 3);
    }

    public boolean ShouldAnimate() {
        return this.isActive() && this.hasSight || !this.currentAnimation.isDone;
    }

    public int getAnimationIndex() {
        return this.currentAnimation.curFrame;
    }

    private int GetSearchRadius() {
        int tempFocusLevel;
        int focusLevel = -1;
        int inventoryIndex = 0;
        if (this.inventory[inventoryIndex] != null && this.inventory[inventoryIndex].func_77973_b() instanceof ISpellFocus && (tempFocusLevel = ((ISpellFocus)this.inventory[inventoryIndex].func_77973_b()).getFocusLevel()) > focusLevel) {
            focusLevel = tempFocusLevel;
        }
        int radius = (focusLevel + 1) * 5;
        return radius;
    }

    private Class<? extends Entity> GetSearchClass() {
        if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof ItemFilterFocus) {
            return ((ItemFilterFocus)this.inventory[1].func_77973_b()).getFilterClass();
        }
        return null;
    }

    public boolean HasSight() {
        return this.isActive() && this.hasSight;
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[2], this.inventory[3], this.inventory[4]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Seer Stone";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.swapDetectionMode = nbttagcompound.func_74767_n("seerStoneIsInverting");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SeerStoneInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74757_a("seerStoneIsInverting", this.isInvertingDetection());
        nbttagcompound.func_74782_a("SeerStoneInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 20;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return this.validTypes;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

