/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class TileEntitySlipstreamGenerator
extends TileEntityAMPower {
    private ArrayList<EntityPlayer> levitatingEntities = new ArrayList();
    private int updateTicks = 1;
    private static final int EFFECT_HEIGHT = 50;

    public TileEntitySlipstreamGenerator() {
        super(100);
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.updateTicks;
        if (this.updateTicks > 10) {
            this.refreshPlayerList();
            this.updateTicks = 0;
            if (this.field_145850_b.field_72995_K && this.levitatingEntities.size() > 0) {
                AMNetHandler.INSTANCE.sendPowerRequestToServer(new AMVector3(this).toVec3D());
            }
        }
        if (this.levitatingEntities.isEmpty()) {
            return;
        }
        Iterator<EntityPlayer> it = this.levitatingEntities.iterator();
        while (it.hasNext()) {
            EntityPlayer player = it.next();
            if (!this.playerIsValid(player)) {
                it.remove();
                continue;
            }
            if (!(PowerNodeRegistry.For(this.field_145850_b).getHighestPower(this) >= 0.25f)) continue;
            player.field_70181_x *= 0.5999999;
            if (Math.abs(player.field_70181_x) < 0.2) {
                player.func_70024_g(0.0, -player.field_70181_x, 0.0);
                player.field_70143_R = 0.0f;
            } else {
                player.field_70143_R -= 1.0f;
            }
            if (!player.func_70093_af()) {
                float pitch = player.field_70125_A;
                float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
                if (Math.abs(pitch) > 10.0f) {
                    player.func_70091_d(0.0, (double)factor, 0.0);
                }
            }
            if (this.field_145850_b.field_72995_K) {
                this.spawnParticles(player);
            }
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 0.25f);
        }
    }

    private void spawnParticles(EntityPlayer player) {
        AMParticle wind = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "wind", player.field_70165_t, player.field_70163_u - (double)player.field_70131_O, player.field_70161_v));
        float pitch = player.field_70125_A;
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (player.func_70093_af()) {
            factor = 0.01f;
        }
        if (wind != null) {
            wind.func_187114_a(10);
            wind.addRandomOffset(1.0, 1.0, 1.0);
            wind.setParticleScale(0.1f);
            wind.AddParticleController(new ParticleFloatUpward(wind, 0.0f, Math.abs(factor) * 2.0f, 1, false));
        }
    }

    private boolean playerIsValid(EntityPlayer player) {
        if (player == null || player.field_70128_L) {
            return false;
        }
        float tolerance = 0.2f;
        AxisAlignedBB bb = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - tolerance), (double)(this.field_174879_c.func_177956_o() + 1), (double)((float)this.field_174879_c.func_177952_p() - tolerance), (double)((float)(this.field_174879_c.func_177958_n() + 1) + tolerance), (double)(this.field_174879_c.func_177956_o() + 1 + 50), (double)((float)(this.field_174879_c.func_177952_p() + 1) + tolerance));
        Vec3d myLoc = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5);
        Vec3d playerLoc = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return bb.func_72326_a(player.func_174813_aQ()) && this.field_145850_b.func_72901_a(myLoc, playerLoc, true) == null;
    }

    private void refreshPlayerList() {
        this.levitatingEntities.clear();
        for (int i = 0; i < this.field_145850_b.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.field_145850_b.field_73010_i.get(i);
            if (!this.playerIsValid(player) || this.levitatingEntities.contains(player)) continue;
            this.levitatingEntities.add(player);
        }
    }

    @Override
    public boolean canRequestPower() {
        return true;
    }

    @Override
    public int getChargeRate() {
        return 12;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }
}

