/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.blocks.IKeystoneLockable;
import am2.api.spell.SpellComponent;
import am2.defs.BlockDefs;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntitySpellSealedDoor
extends TileEntity
implements ITickable,
IInventory,
IKeystoneLockable<TileEntitySpellSealedDoor> {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private int lastAppliedTime = -1;
    private int closeTime = -1;
    private int curTime = 0;
    private int opentime = 40;
    private ArrayList<SpellComponent> appliedParts = new ArrayList();
    private ArrayList<SpellComponent> key = new ArrayList();

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Spell Sealed Door";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.analyzeSpellForKey();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SpellSealedDoorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("SpellSealedDoorInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.curTime;
            if (this.closeTime == -1 && this.lastAppliedTime != -1) {
                if (this.curTime > this.lastAppliedTime + 10) {
                    this.clearAppliedParts();
                    return;
                }
                if (this.checkKey()) {
                    this.clearAppliedParts();
                    this.setOpenState(true);
                    this.closeTime = this.curTime + this.opentime;
                }
            }
            if (this.closeTime != -1 && this.curTime > this.closeTime) {
                this.clearAppliedParts();
                this.setOpenState(false);
                this.closeTime = -1;
            }
        }
    }

    private void setOpenState(boolean open) {
        BlockDefs.spellSealedDoor.func_176512_a(this.field_145850_b, this.field_174879_c, open);
    }

    public void addPartToCurrentKey(SpellComponent component) {
        this.appliedParts.add(component);
        this.lastAppliedTime = this.curTime;
    }

    private boolean checkKey() {
        if (this.key.size() != this.appliedParts.size()) {
            return false;
        }
        return this.key.equals(this.appliedParts);
    }

    private void clearAppliedParts() {
        this.appliedParts.clear();
        this.lastAppliedTime = -1;
    }

    public void analyzeSpellForKey() {
        ItemStack spell = this.inventory[3];
        if (spell == null) {
            return;
        }
        this.key.clear();
        int stages = SpellUtils.numStages(spell);
        for (int i = 0; i < stages; ++i) {
            ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(spell, i);
            for (SpellComponent comp : components) {
                this.key.add(comp);
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

