/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.ArsMagicaAPI;
import am2.api.DamageSources;
import am2.api.blocks.IKeystoneLockable;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.items.ItemFocusCharge;
import am2.items.ItemFocusMana;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.spell.component.Summon;
import am2.utils.DummyEntityPlayer;
import am2.utils.EntityUtils;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class TileEntitySummoner
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable<TileEntitySummoner> {
    private static final float summonCost = 2000.0f;
    private static final float maintainCost = 7.5f;
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private int summonEntityID = -1;
    private DummyEntityPlayer dummyCaster;
    private int summonCooldown = 0;
    private int prevSummonCooldown = 0;
    private static final int maxSummonCooldown = 200;
    private static final int powerPadding = 500;
    private static final int SUMMON_SLOT = 3;

    public TileEntitySummoner() {
        super(2500);
    }

    private boolean isRedstonePowered() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevSummonCooldown = this.summonCooldown--;
        if (this.summonCooldown < 0) {
            this.summonCooldown = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.summonCooldown == 0 && this.prevSummonCooldown > 0) {
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
        if (!this.field_145850_b.field_72995_K) {
            EntityLiving ent = this.getSummonedCreature();
            if (ent == null) {
                this.summonEntityID = -1;
            }
            if (this.isRedstonePowered() && this.inventory[3] != null) {
                if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 7.5f)) {
                    if (ent == null && this.canSummon()) {
                        this.summonCreature();
                    } else if (ent != null) {
                        PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 7.5f);
                    }
                } else {
                    this.unsummonCreature();
                }
            } else if (ent != null) {
                this.unsummonCreature();
                PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.NEUTRAL, 1000.0f);
            }
        }
    }

    public float getSummonCost() {
        int numManaFoci = this.numFociOfType(ItemFocusMana.class);
        return 2000.0f * (1.0f - 0.2f * (float)numManaFoci);
    }

    public float getMaintainCost() {
        int numManaFoci = this.numFociOfType(ItemFocusMana.class);
        return 7.5f * (1.0f - 0.2f * (float)numManaFoci);
    }

    public boolean canSummon() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.summonCooldown == 0 && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.getSummonCost() + 500.0f);
    }

    public boolean hasSummon() {
        return this.summonEntityID != -1;
    }

    private void summonCreature() {
        EntityLiving summon;
        if (this.field_145850_b.field_72995_K || this.summonEntityID != -1) {
            return;
        }
        if (this.dummyCaster == null) {
            this.dummyCaster = new DummyEntityPlayer(this.field_145850_b);
        }
        if ((summon = ((Summon)ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation("arsmagica2:summon"))).summonCreature(this.inventory[3], (EntityLivingBase)this.dummyCaster, (EntityLivingBase)this.dummyCaster, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p())) != null) {
            if (summon instanceof EntityCreature) {
                EntityUtils.setGuardSpawnLocation((EntityCreature)summon, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
            this.summonEntityID = summon.func_145782_y();
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 2000.0f);
            this.summonCooldown = 200;
            EntityUtils.setTileSpawned((EntityLivingBase)summon, this);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    private void unsummonCreature() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EntityLiving ent = this.getSummonedCreature();
        if (ent == null) {
            return;
        }
        ent.func_70097_a((DamageSource)DamageSources.unsummon, 1000000.0f);
        this.summonEntityID = -1;
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    private EntityLiving getSummonedCreature() {
        if (this.summonEntityID == -1) {
            return null;
        }
        return (EntityLiving)this.field_145850_b.func_73045_a(this.summonEntityID);
    }

    public int func_70302_i_() {
        return 7;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[4], this.inventory[5], this.inventory[6]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Summoner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SummonerInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("SummonerInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    private int numFociOfType(Class<?> type) {
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.inventory[i] == null || !type.isInstance(this.inventory[i].func_77973_b())) continue;
            ++count;
        }
        return count;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public int getChargeRate() {
        int numChargeFoci = this.numFociOfType(ItemFocusCharge.class);
        return 100 + 50 * numChargeFoci;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

