/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.defs.ItemDefs;
import am2.utils.InventoryUtilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorFishing
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorFishing instance = new FlickerOperatorFishing();

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 500;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> controller, boolean powered) {
        return this.DoOperation(worldObj, controller, powered, new Affinity[0]);
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
        TileEntity te = (TileEntity)controller;
        if (!powered || !this.checkSurroundings(worldObj, te.func_174877_v()) || worldObj.func_175687_A(te.func_174877_v()) == 0) {
            return false;
        }
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)worldObj);
        for (ItemStack itemstack : worldObj.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(worldObj.field_73012_v, lootcontext$builder.func_186471_a())) {
            this.transferOrEjectItem(worldObj, itemstack, te.func_174877_v());
        }
        return true;
    }

    private boolean checkSurroundings(World world, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j >= -2; --j) {
                for (int k = -1; k <= 1; ++k) {
                    Block block = world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c();
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void transferOrEjectItem(World worldObj, ItemStack stack, BlockPos pos) {
        if (worldObj.field_72995_K) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = worldObj.func_175625_s(pos.func_177982_a(i, j, k))) == null || !(te instanceof IInventory)) continue;
                    for (EnumFacing facing : EnumFacing.values()) {
                        if (!InventoryUtilities.mergeIntoInventory((IInventory)te, stack, stack.field_77994_a, facing)) continue;
                        return;
                    }
                }
            }
        }
        EntityItem item = new EntityItem(worldObj);
        item.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        item.func_92058_a(stack);
        worldObj.func_72838_d((Entity)item);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        int time = 2000;
        for (Affinity aff : flickers) {
            if (aff != Affinity.LIGHTNING) continue;
            time = (int)((double)time * 0.8);
        }
        return time;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{" F ", "N W", " R ", Character.valueOf('F'), Items.field_151115_aP, Character.valueOf('W'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.WATER)), Character.valueOf('N'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NATURE)), Character.valueOf('R'), Items.field_151112_aM};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorFishing");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.WATER, Affinity.NATURE};
    }
}

