/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.utils.AffinityShiftUtils;
import am2.utils.DummyEntityPlayer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorFlatLands
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorFlatLands instance = new FlickerOperatorFlatLands();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int searchesPerLoop = 12;
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            boolean actionPerformed = false;
            for (int i = 0; i < searchesPerLoop && !actionPerformed; ++i) {
                int effectX = ((TileEntity)habitat).func_174877_v().func_177958_n() - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectZ = ((TileEntity)habitat).func_174877_v().func_177952_p() - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectY = ((TileEntity)habitat).func_174877_v().func_177956_o() + worldObj.field_73012_v.nextInt(radius);
                BlockPos effectPos = new BlockPos(effectX, effectY, effectZ);
                if (effectPos == ((TileEntity)habitat).func_174877_v()) {
                    return false;
                }
                IBlockState block = worldObj.func_180495_p(effectPos);
                if (block == null || worldObj.func_175623_d(effectPos) || !block.func_185914_p() || block.func_177230_c() == BlockDefs.invisibleUtility || !ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)new DummyEntityPlayer(worldObj), (IBlockState)block, (boolean)true) || !block.func_177230_c().removedByPlayer(block, worldObj, effectPos, (EntityPlayer)new DummyEntityPlayer(worldObj), true)) continue;
                block.func_177230_c().func_176206_d(worldObj, effectPos, block);
                block.func_177230_c().func_176226_b(worldObj, effectPos, block, 0);
                actionPerformed = true;
            }
            return actionPerformed;
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 20;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"S P", "ENI", " R ", Character.valueOf('S'), Items.field_151037_a, Character.valueOf('P'), Items.field_151035_b, Character.valueOf('E'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.EARTH)), Character.valueOf('N'), AffinityShiftUtils.getEssenceForAffinity(Affinity.EARTH), Character.valueOf('I'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ICE)), Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b())};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorFlatLands");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.EARTH, Affinity.ICE};
    }
}

