/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorGentleRains
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorGentleRains instance = new FlickerOperatorGentleRains();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 0;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            int effectY;
            int effectX = ((TileEntity)habitat).func_174877_v().func_177958_n() - radius + worldObj.field_73012_v.nextInt(diameter);
            int effectZ = ((TileEntity)habitat).func_174877_v().func_177952_p() - radius + worldObj.field_73012_v.nextInt(diameter);
            BlockPos effectPos = new BlockPos(effectX, effectY, effectZ);
            for (effectY = ((TileEntity)habitat).func_174877_v().func_177956_o() - 1; worldObj.func_175623_d(effectPos) && effectY > 0; --effectY) {
            }
            while (!worldObj.func_175623_d(effectPos) && worldObj.func_180495_p(effectPos).func_177230_c() != Blocks.field_150458_ak && effectY > 0) {
                ++effectY;
            }
            --effectY;
            IBlockState block = worldObj.func_180495_p(effectPos);
            if (block.func_177230_c() == Blocks.field_150458_ak && (Integer)block.func_177229_b((IProperty)BlockFarmland.field_176531_a) < 7) {
                worldObj.func_175656_a(effectPos, block.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)));
                return true;
            }
        } else {
            for (int i = 0; i < ArsMagica2.config.getGFXLevel() * 2; ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(worldObj, "water_ball", (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5, ((TileEntity)habitat).func_174877_v().func_177958_n() + 3, (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5));
                if (particle == null) continue;
                particle.setAffectedByGravity();
                particle.func_187114_a(10);
                particle.setDontRequireControllers();
                particle.setParticleScale(0.03f);
                particle.addRandomOffset(diameter, 0.0, diameter);
            }
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 1;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{" B ", "CWT", " B ", Character.valueOf('C'), BlockDefs.essenceConduit, Character.valueOf('T'), BlockDefs.tarmaRoot, Character.valueOf('W'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.WATER)), Character.valueOf('B'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b())};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorGentleRains");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.WATER};
    }
}

