/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.IFlickerController;
import am2.blocks.BlockInvisibleUtility;
import am2.blocks.tileentity.flickers.FlickerOperatorContainment;
import am2.defs.ItemDefs;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorInterdiction
extends FlickerOperatorContainment {
    public static final FlickerOperatorInterdiction instance = new FlickerOperatorInterdiction();

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        int calcRadius;
        int lastRadius;
        if (worldObj.field_72995_K) {
            return true;
        }
        boolean hasEnderAugment = false;
        for (Affinity aff : flickers) {
            if (aff != Affinity.ENDER) continue;
            hasEnderAugment = true;
            break;
        }
        if ((lastRadius = this.getLastRadius(habitat)) != (calcRadius = this.calculateRadius(flickers))) {
            this.RemoveOperator(worldObj, habitat, powered, flickers);
        }
        BlockPos habitatPos = ((TileEntity)habitat).func_174877_v();
        for (int i = 0; i < calcRadius * 2 + 1; ++i) {
            if (hasEnderAugment) {
                this.setUtilityBlock(worldObj, habitatPos.func_177982_a(-calcRadius, 0, -calcRadius + i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, habitatPos.func_177982_a(calcRadius + 1, 0, -calcRadius + i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, habitatPos.func_177982_a(-calcRadius + i, 0, -calcRadius), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, habitatPos.func_177982_a(calcRadius + 1 - i, 0, calcRadius + 1), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                continue;
            }
            this.setUtilityBlock(worldObj, habitatPos.func_177982_a(-calcRadius, 0, -calcRadius + i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
            this.setUtilityBlock(worldObj, habitatPos.func_177982_a(calcRadius + 1, 0, -calcRadius + i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
            this.setUtilityBlock(worldObj, habitatPos.func_177982_a(-calcRadius + i, 0, -calcRadius), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
            this.setUtilityBlock(worldObj, habitatPos.func_177982_a(calcRadius + 1 - i, 0, calcRadius + 1), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
        }
        this.setLastRadius(habitat, calcRadius);
        return true;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int radius = 6;
        BlockPos habitatPos = ((TileEntity)habitat).func_174877_v();
        for (int i = 0; i < radius * 2 + 1; ++i) {
            this.clearUtilityBlock(worldObj, habitatPos.func_177982_a(-radius, 0, -radius + i));
            this.clearUtilityBlock(worldObj, habitatPos.func_177982_a(radius + 1, 0, -radius + i));
            this.clearUtilityBlock(worldObj, habitatPos.func_177982_a(-radius + i, 0, -radius));
            this.clearUtilityBlock(worldObj, habitatPos.func_177982_a(radius + 1 - i, 0, radius + 1));
        }
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"FWF", "ARN", "IWI", Character.valueOf('F'), "fenceWood", Character.valueOf('W'), Blocks.field_150463_bK, Character.valueOf('A'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ARCANE)), Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), Character.valueOf('N'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.AIR)), Character.valueOf('I'), Blocks.field_150411_aY};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorInterdiction");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.AIR, Affinity.ARCANE};
    }
}

