/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.blocks.BlockInvisibleUtility;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorLight
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorLight instance = new FlickerOperatorLight();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 0;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        if (!worldObj.field_72995_K) {
            int radius = 16;
            int yRadius = radius / 4;
            int checksPerOperation = 8;
            BlockPos checkPos = ((TileEntity)habitat).func_174877_v().func_177982_a(-radius, -yRadius, -radius);
            byte[] meta = habitat.getMetadata(this);
            if (meta.length != 0) {
                AMDataReader rdr = new AMDataReader(meta, false);
                checkPos = new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt());
            }
            for (int i = 0; i < checksPerOperation; ++i) {
                int light = worldObj.func_175642_b(EnumSkyBlock.BLOCK, checkPos);
                if (light < 10 && worldObj.func_175623_d(checkPos)) {
                    worldObj.func_180501_a(checkPos, BlockDefs.invisibleUtility.func_176223_P().func_177226_a(BlockInvisibleUtility.TYPE, (Comparable)((Object)BlockInvisibleUtility.EnumInvisibleType.SPECIAL_ILLUMINATED)), 2);
                }
                checkPos.func_177974_f();
                if (checkPos.func_177958_n() <= ((TileEntity)habitat).func_174877_v().func_177958_n() + radius) continue;
                checkPos = new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - radius, checkPos.func_177956_o(), checkPos.func_177952_p());
                if ((checkPos = checkPos.func_177984_a()).func_177956_o() <= ((TileEntity)habitat).func_174877_v().func_177956_o() + yRadius) continue;
                checkPos = new BlockPos(checkPos.func_177958_n(), ((TileEntity)habitat).func_174877_v().func_177956_o() - yRadius, checkPos.func_177952_p());
                if ((checkPos = checkPos.func_177968_d()).func_177952_p() <= ((TileEntity)habitat).func_174877_v().func_177952_p() + yRadius) continue;
                checkPos = new BlockPos(checkPos.func_177958_n(), checkPos.func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - radius);
            }
            AMDataWriter writer = new AMDataWriter();
            writer.add(checkPos.func_177958_n()).add(checkPos.func_177956_o()).add(checkPos.func_177952_p());
            habitat.setMetadata(this, writer.generate());
        } else {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(worldObj, "sparkle", (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5, ((TileEntity)habitat).func_174877_v().func_177956_o() + 1, (double)((TileEntity)habitat).func_174877_v().func_177952_p() + 0.5));
            if (particle != null) {
                particle.addRandomOffset(0.5, 0.4, 0.5);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.02f, 1, false));
                particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
                particle.func_187114_a(20);
            }
        }
        return true;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
        habitat.removeMetadata(this);
        if (!worldObj.field_72995_K) {
            int radius = 28;
            int yRadius = radius / 4;
            for (int i = ((TileEntity)habitat).func_174877_v().func_177958_n() - radius; i <= ((TileEntity)habitat).func_174877_v().func_177958_n() + radius; ++i) {
                for (int j = ((TileEntity)habitat).func_174877_v().func_177956_o() - yRadius; j <= ((TileEntity)habitat).func_174877_v().func_177956_o() + yRadius; ++j) {
                    for (int k = ((TileEntity)habitat).func_174877_v().func_177956_o() - radius; k <= ((TileEntity)habitat).func_174877_v().func_177956_o() + radius; ++k) {
                        BlockPos removePos = new BlockPos(i, j, k);
                        Block block = worldObj.func_180495_p(removePos).func_177230_c();
                        if (block != BlockDefs.invisibleUtility || BlockInvisibleUtility.getType(worldObj.func_180495_p(removePos)) != BlockInvisibleUtility.EnumInvisibleType.SPECIAL_ILLUMINATED) continue;
                        worldObj.func_175698_g(removePos);
                    }
                }
            }
        }
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 10;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"ISI", "F L", "ISI", Character.valueOf('F'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.FIRE)), Character.valueOf('S'), new ItemStack((Item)ItemDefs.itemOre, 1, 3), Character.valueOf('L'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIGHTNING)), Character.valueOf('I'), ItemDefs.liquidEssenceBottle};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorLight");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.FIRE, Affinity.LIGHTNING};
    }
}

