/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.api.math.AMVector3;
import am2.blocks.BlockArsMagicaOre;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.utils.AffinityShiftUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorMoonstoneAttractor
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorMoonstoneAttractor instance = new FlickerOperatorMoonstoneAttractor();
    private static final ArrayList<AMVector3> attractors = new ArrayList();

    public static AMVector3 getMeteorAttractor(AMVector3 target) {
        for (AMVector3 attractor : attractors.toArray(new AMVector3[attractors.size()])) {
            if (!(attractor.distanceSqTo(target) <= 16384.0)) continue;
            return attractor.copy();
        }
        return null;
    }

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        AMVector3 vec = new AMVector3((TileEntity)habitat);
        if (powered) {
            if (!attractors.contains(vec)) {
                attractors.add(vec);
            }
            return true;
        }
        attractors.remove(vec);
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
        AMVector3 vec = new AMVector3((TileEntity)habitat);
        attractors.remove(vec);
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 100;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"RLR", "AME", "I T", Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), Character.valueOf('L'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIGHTNING)), Character.valueOf('A'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ARCANE)), Character.valueOf('E'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.EARTH)), Character.valueOf('M'), new ItemStack((Block)BlockDefs.ores, 1, BlockArsMagicaOre.EnumOreType.MOONSTONE.ordinal()), Character.valueOf('I'), AffinityShiftUtils.getEssenceForAffinity(Affinity.AIR), Character.valueOf('T'), AffinityShiftUtils.getEssenceForAffinity(Affinity.EARTH)};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorMoonstoneAttractor");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.LIGHTNING, Affinity.ARCANE, Affinity.EARTH};
    }
}

