/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.defs.ItemDefs;
import am2.utils.AffinityShiftUtils;
import am2.utils.InventoryUtilities;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorPackedEarth
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorPackedEarth instance = new FlickerOperatorPackedEarth();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int searchesPerLoop = 12;
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            boolean actionPerformed = false;
            for (int i = 0; i < searchesPerLoop && !actionPerformed; ++i) {
                int inventoryIndex;
                TileEntity te = worldObj.func_175625_s(((TileEntity)habitat).func_174877_v().func_177977_b());
                if (te == null || !(te instanceof IInventory)) {
                    return false;
                }
                BlockPos effectPos = ((TileEntity)habitat).func_174877_v().func_177982_a(-radius, -1, -radius).func_177982_a(worldObj.field_73012_v.nextInt(diameter), worldObj.field_73012_v.nextInt(diameter), worldObj.field_73012_v.nextInt(radius));
                if (effectPos.func_177956_o() < 3) {
                    effectPos = new BlockPos(effectPos.func_177958_n(), 3, effectPos.func_177956_o());
                }
                Block block = worldObj.func_180495_p(effectPos).func_177230_c();
                if (!worldObj.func_175623_d(effectPos) && !block.func_176200_f((IBlockAccess)worldObj, effectPos) || (inventoryIndex = InventoryUtilities.getFirstBlockInInventory((IInventory)te)) <= -1) continue;
                ItemStack stack = ((IInventory)te).func_70301_a(inventoryIndex);
                InventoryUtilities.decrementStackQuantity((IInventory)te, inventoryIndex, 1);
                worldObj.func_175656_a(effectPos, Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()));
                actionPerformed = true;
            }
        }
        return true;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, controller, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 20;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"DDD", "RFR", " E ", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), Character.valueOf('E'), AffinityShiftUtils.getEssenceForAffinity(Affinity.EARTH), Character.valueOf('F'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.EARTH))};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorPackedEarth");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.EARTH};
    }
}

