/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.blocks.tileentity.TileEntityFlickerHabitat;
import am2.defs.ItemDefs;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TileEntityFlickerControllerBase
extends TileEntityAMPower
implements IFlickerController<TileEntityFlickerControllerBase> {
    private HashMap<Integer, byte[]> sigilMetadata;
    private AbstractFlickerFunctionality operator;
    private int tickCounter;
    Affinity[] nearbyList = new Affinity[6];
    private boolean lastOpWasPowered = false;
    private boolean firstOp = true;

    public TileEntityFlickerControllerBase() {
        super(500);
        this.sigilMetadata = new HashMap();
    }

    protected void setOperator(AbstractFlickerFunctionality operator) {
        if (this.operator != null) {
            this.operator.RemoveOperator(this.field_145850_b, this, PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.operator.PowerPerOperation()), this.nearbyList);
        }
        this.operator = operator;
        this.tickCounter = 0;
    }

    public void updateOperator(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != ItemDefs.flickerFocus) {
            return;
        }
        this.operator = (AbstractFlickerFunctionality)ArsMagicaAPI.getFlickerFocusRegistry().getObjectById(stack.func_77952_i());
    }

    public void scanForNearbyUpgrades() {
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (te == null || !(te instanceof TileEntityFlickerHabitat)) continue;
            this.nearbyList[direction.ordinal()] = ((TileEntityFlickerHabitat)te).getSelectedAffinity();
        }
    }

    public void notifyOfNearbyUpgradeChange(TileEntity neighbor) {
        EnumFacing direction;
        if (neighbor instanceof TileEntityFlickerHabitat && (direction = this.getNeighboringEnumFacing(neighbor)) != null) {
            this.nearbyList[direction.ordinal()] = ((TileEntityFlickerHabitat)neighbor).getSelectedAffinity();
        }
    }

    private EnumFacing getNeighboringEnumFacing(TileEntity neighbor) {
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p() + 1) {
            return EnumFacing.SOUTH;
        }
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p() - 1) {
            return EnumFacing.NORTH;
        }
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() + 1 && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p()) {
            return EnumFacing.EAST;
        }
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() - 1 && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p()) {
            return EnumFacing.WEST;
        }
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() + 1 && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p()) {
            return EnumFacing.UP;
        }
        if (neighbor.func_174877_v().func_177958_n() == this.field_174879_c.func_177958_n() && neighbor.func_174877_v().func_177956_o() == this.field_174879_c.func_177956_o() - 1 && neighbor.func_174877_v().func_177952_p() == this.field_174879_c.func_177952_p()) {
            return EnumFacing.DOWN;
        }
        return null;
    }

    @Override
    public void func_73660_a() {
        Affinity[] unpoweredNeighbors;
        boolean powered;
        super.func_73660_a();
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            ++this.tickCounter;
            return;
        }
        if (this.operator != null && this.tickCounter++ >= this.operator.TimeBetweenOperation(powered = PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.operator.PowerPerOperation()), unpoweredNeighbors = this.getUnpoweredNeighbors())) {
            this.tickCounter = 0;
            if (powered && this.operator.RequiresPower() || !this.operator.RequiresPower()) {
                boolean success;
                if (this.firstOp) {
                    this.scanForNearbyUpgrades();
                    this.firstOp = false;
                }
                if ((success = this.operator.DoOperation(this.field_145850_b, this, powered, unpoweredNeighbors)) || this.operator.RequiresPower()) {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), this.operator.PowerPerOperation());
                }
                this.lastOpWasPowered = true;
            } else if (this.lastOpWasPowered && this.operator.RequiresPower() && !powered) {
                this.operator.RemoveOperator(this.field_145850_b, this, powered, unpoweredNeighbors);
                this.lastOpWasPowered = false;
            }
        }
    }

    private Affinity[] getUnpoweredNeighbors() {
        Affinity[] aff = new Affinity[EnumFacing.values().length];
        for (int i = 0; i < this.nearbyList.length; ++i) {
            EnumFacing dir = EnumFacing.values()[i];
            aff[i] = this.nearbyList[i] == null || this.field_145850_b.func_175687_A(this.field_174879_c.func_177972_a(dir)) > 0 ? null : this.nearbyList[i];
        }
        return aff;
    }

    private Integer getFlagForOperator(AbstractFlickerFunctionality operator) {
        return ArsMagicaAPI.getFlickerFocusRegistry().getId((IForgeRegistryEntry)operator);
    }

    @Override
    public void setMetadata(AbstractFlickerFunctionality operator, byte[] meta) {
        this.sigilMetadata.put(this.getFlagForOperator(operator), meta);
    }

    @Override
    public byte[] getMetadata(AbstractFlickerFunctionality operator) {
        byte[] arr = this.sigilMetadata.get(this.getFlagForOperator(operator));
        return arr != null ? arr : new byte[]{};
    }

    @Override
    public void removeMetadata(AbstractFlickerFunctionality operator) {
        this.sigilMetadata.remove(this.getFlagForOperator(operator));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound par1nbtTagCompound) {
        super.func_189515_b(par1nbtTagCompound);
        NBTTagList sigilMetaStore = new NBTTagList();
        for (Integer i : this.sigilMetadata.keySet()) {
            NBTTagCompound sigilMetaEntry = new NBTTagCompound();
            sigilMetaEntry.func_74768_a("sigil_mask", i.intValue());
            sigilMetaEntry.func_74773_a("sigil_meta", this.sigilMetadata.get(i));
            sigilMetaStore.func_74742_a((NBTBase)sigilMetaEntry);
        }
        par1nbtTagCompound.func_74782_a("sigil_metadata_collection", (NBTBase)sigilMetaStore);
        return par1nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.sigilMetadata = new HashMap();
        NBTTagList sigilMetaStore = par1nbtTagCompound.func_150295_c("sigil_metadata_collection", 10);
        for (int i = 0; i < sigilMetaStore.func_74745_c(); ++i) {
            NBTTagCompound sigilMetaEntry = sigilMetaStore.func_150305_b(i);
            Integer mask = sigilMetaEntry.func_74762_e("sigil_mask");
            byte[] meta = sigilMetaEntry.func_74770_j("sigil_meta");
            this.sigilMetadata.put(mask, meta);
        }
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public boolean canRequestPower() {
        return true;
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 100;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return PowerTypes.all();
    }

    @Override
    public float particleOffset(int axis) {
        return 0.5f;
    }

    public Affinity[] getNearbyUpgrades() {
        return this.getUnpoweredNeighbors();
    }
}

