/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIDispel;
import am2.bosses.ai.EntityAISummonAllies;
import am2.bosses.ai.ISpellCastCallback;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.entity.EntityDarkling;
import am2.entity.EntityEarthElemental;
import am2.entity.EntityFireElemental;
import am2.entity.EntityManaElemental;
import am2.utils.NPCSpells;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityLifeGuardian
extends AM2Boss {
    private ArrayList<EntityLiving> minions;
    public ArrayList<EntityLiving> queued_minions;
    private static final DataParameter<Integer> DATA_MINION_COUNT = EntityDataManager.func_187226_a(EntityLifeGuardian.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLifeGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
        this.minions = new ArrayList();
        this.queued_minions = new ArrayList();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_MINION_COUNT, (Object)0);
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDispel(this));
        this.field_70714_bg.func_75776_a(1, new EntityAICastSpell<EntityLifeGuardian>(this, NPCSpells.instance.healSelf, 16, 23, 100, BossActions.CASTING, new ISpellCastCallback<EntityLifeGuardian>(){

            @Override
            public boolean shouldCast(EntityLifeGuardian host, ItemStack spell) {
                return host.func_110143_aJ() < host.func_110138_aP();
            }
        }));
        this.field_70714_bg.func_75776_a(2, new EntityAICastSpell<EntityLifeGuardian>(this, NPCSpells.instance.nauseate, 16, 23, 20, BossActions.CASTING, new ISpellCastCallback<EntityLifeGuardian>(){

            @Override
            public boolean shouldCast(EntityLifeGuardian host, ItemStack spell) {
                return EntityLifeGuardian.this.minions.size() == 0;
            }
        }));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISummonAllies(this, EntityEarthElemental.class, EntityFireElemental.class, EntityManaElemental.class, EntityDarkling.class));
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76364_f() != null && par1DamageSource.func_76364_f() instanceof EntityLivingBase) {
            for (EntityLivingBase minion : this.minions.toArray(new EntityLivingBase[this.minions.size()])) {
                ((EntityLiving)minion).func_70624_b((EntityLivingBase)par1DamageSource.func_76364_f());
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (this.minions.size() > 0) {
            damageAmt = 0.0f;
            this.minions.get(this.func_70681_au().nextInt(this.minions.size())).func_70097_a(source, damageAmt);
        }
        return damageAmt;
    }

    public int getNumMinions() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_MINION_COUNT);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.minions.addAll(this.queued_minions);
            this.queued_minions.clear();
            Iterator<EntityLiving> it = this.minions.iterator();
            while (it.hasNext()) {
                EntityLiving minion = it.next();
                if (minion != null && !minion.field_70128_L) continue;
                it.remove();
            }
            this.field_70180_af.func_187227_b(DATA_MINION_COUNT, (Object)this.minions.size());
            if (this.field_70173_aa % 100 == 0) {
                for (EntityLivingBase entityLivingBase : this.minions) {
                    ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "textures/blocks/oreblocksunstone.png", (Entity)this, (Entity)entityLivingBase);
                }
            }
        }
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(2.0f);
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.LIFE_GUARDIAN_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.LIFE_GUARDIAN_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.LIFE_GUARDIAN_IDLE;
    }

    @Override
    public SoundEvent getAttackSound() {
        return AMSounds.LIFE_GUARDIAN_HEAL;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.infinityOrb, 1, 1), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIFE)), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemDefs.lifeWardEnchanted.func_77946_l(), 0.0f);
        }
    }

    public float func_70047_e() {
        return 1.5f;
    }

    @Override
    protected BossInfo.Color getBarColor() {
        return BossInfo.Color.GREEN;
    }
}

