/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.sources.DamageSourceFrost;
import am2.api.sources.DamageSourceLightning;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIChaosWaterBolt;
import am2.bosses.ai.EntityAICloneSelf;
import am2.bosses.ai.EntityAISpinAttack;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.packet.AMNetHandler;
import am2.utils.NPCSpells;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityWaterGuardian
extends AM2Boss {
    private EntityWaterGuardian master;
    private final EntityWaterGuardian[] clones;
    private float orbitRotation;
    private boolean uberSpinAvailable = false;
    private static final DataParameter<Boolean> IS_CLONE = EntityDataManager.func_187226_a(EntityWaterGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    public float spinRotation = 0.0f;

    public EntityWaterGuardian(World par1World) {
        super(par1World);
        this.currentAction = BossActions.IDLE;
        this.master = null;
        this.clones = new EntityWaterGuardian[2];
        this.func_70105_a(1.0f, 2.0f);
        EntityExtension.For((EntityLivingBase)this).setMagicLevelWithMana(10);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(75.0);
    }

    public void setClones(EntityWaterGuardian clone1, EntityWaterGuardian clone2) {
        this.clones[0] = clone1;
        this.clones[1] = clone2;
    }

    private boolean hasClones() {
        return this.clones[0] != null || this.clones[1] != null;
    }

    public void clearClones() {
        if (this.clones[0] != null) {
            this.clones[0].func_70106_y();
        }
        if (this.clones[1] != null) {
            this.clones[1].func_70106_y();
        }
        this.clones[0] = null;
        this.clones[1] = null;
    }

    private void enableUberAttack() {
        this.uberSpinAvailable = true;
    }

    public void setMaster(EntityWaterGuardian master) {
        this.field_70180_af.func_187227_b(IS_CLONE, (Object)true);
        this.master = master;
    }

    public boolean isClone() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CLONE);
    }

    public void clearMaster() {
        this.master = null;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIChaosWaterBolt(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICloneSelf(this));
        this.field_70714_bg.func_75776_a(4, new EntityAICastSpell<EntityWaterGuardian>(this, NPCSpells.instance.waterBolt, 12, 23, 5, BossActions.CASTING));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISpinAttack(this, 0.5f, 4.0f));
    }

    @Override
    public void func_70071_h_() {
        if (this.currentAction == BossActions.CASTING) {
            this.uberSpinAvailable = false;
        }
        if (!this.field_70170_p.field_72995_K && this.uberSpinAvailable && this.currentAction != BossActions.CASTING && this.currentAction != BossActions.IDLE) {
            this.setCurrentAction(BossActions.IDLE);
        }
        if (!this.field_70170_p.field_72995_K && this.isClone() && (this.master == null || this.field_70173_aa > 400)) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateRotations();
        }
        super.func_70071_h_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CLONE, (Object)false);
    }

    private void updateRotations() {
        this.orbitRotation = !this.isClone() ? (this.orbitRotation += 2.0f) : (this.orbitRotation -= 2.0f);
        this.orbitRotation %= 360.0f;
        if (this.getCurrentAction() == BossActions.SPINNING || this.getCurrentAction() == BossActions.CASTING) {
            this.spinRotation = (this.spinRotation - 30.0f) % 360.0f;
        }
    }

    public float getOrbitRotation() {
        return this.orbitRotation;
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        this.spinRotation = 0.0f;
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76364_f() instanceof EntityWaterGuardian) {
            return false;
        }
        if (this.isClone() && this.master != null) {
            this.master.enableUberAttack();
            this.master.clearClones();
        } else if (this.hasClones()) {
            this.clearClones();
        }
        if (!this.isClone() && this.field_70146_Z.nextInt(10) < 6) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184639_G(), SoundCategory.HOSTILE, 1.0f, 0.4f + this.field_70146_Z.nextFloat() * 0.6f, false);
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source instanceof DamageSourceLightning) {
            damageAmt *= 2.0f;
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityWaterGuardian) {
            damageAmt = 0.0f;
        }
        if (source instanceof DamageSourceFrost) {
            damageAmt = 0.0f;
        }
        return damageAmt;
    }

    @Override
    public boolean isActionValid(BossActions action) {
        if (this.uberSpinAvailable && action != BossActions.CASTING) {
            return false;
        }
        if (action == BossActions.CASTING) {
            return this.uberSpinAvailable;
        }
        if (action == BossActions.CLONE) {
            return !this.isClone();
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a("isClone", this.isClone());
    }

    public int func_70658_aO() {
        return 10;
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.field_70180_af.func_187227_b(IS_CLONE, (Object)par1nbtTagCompound.func_74767_n("isClone"));
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.infinityOrb, 1, 0), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.WATER)), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3) {
            this.func_70099_a(ItemDefs.waterOrbsEnchanted.func_77946_l(), 0.0f);
        }
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.WATER_GUARDIAN_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.WATER_GUARDIAN_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.WATER_GUARDIAN_IDLE;
    }

    @Override
    public SoundEvent getAttackSound() {
        return AMSounds.WATER_GUARDIAN_ATTACK;
    }

    @Override
    protected BossInfo.Color getBarColor() {
        return BossInfo.Color.BLUE;
    }
}

