/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import am2.defs.IDDefs;
import am2.defs.PotionEffectsDefs;
import am2.utils.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Potion;

public class BuffStatModifiers {
    public static final BuffStatModifiers instance = new BuffStatModifiers();
    private static final AttributeModifier furyMoveMod = new AttributeModifier(IDDefs.furyMoveID, "Fury (Movement)", 2.0, 2);
    private static final AttributeModifier furyDmgMod = new AttributeModifier(IDDefs.furyDmgID, "Fury (Damage)", 5.0, 2);
    private static final AttributeModifier entangled = new AttributeModifier(IDDefs.entangledID, "Entangled", -10.0, 2);
    private static final AttributeModifier frostSlow_Diminished = new AttributeModifier(IDDefs.frostSlowID, "Frost Slow (Diminished)", -0.2, 2);
    private static final AttributeModifier frostSlow_Normal = new AttributeModifier(IDDefs.frostSlowID, "Frost Slow (Normal)", -0.5, 2);
    private static final AttributeModifier frostSlow_Augmented = new AttributeModifier(IDDefs.frostSlowID, "Frost Slow (Augmented)", -0.8, 2);

    public void applyStatModifiersBasedOnBuffs(EntityLivingBase entity) {
        this.applyOrRemoveModifiersForBuff(entity, PotionEffectsDefs.entangle, ResourceUtils.createHashMap(SharedMonsterAttributes.field_111263_d, entangled));
        this.applyOrRemoveScalingModifiersForBuff(entity, PotionEffectsDefs.frostSlow, SharedMonsterAttributes.field_111263_d, frostSlow_Diminished, frostSlow_Normal, frostSlow_Augmented);
        HashMap<IAttribute, AttributeModifier> fury = new HashMap<IAttribute, AttributeModifier>();
        fury.put(SharedMonsterAttributes.field_111263_d, furyMoveMod);
        fury.put(SharedMonsterAttributes.field_111264_e, furyDmgMod);
        this.applyOrRemoveModifiersForBuff(entity, PotionEffectsDefs.fury, fury);
    }

    private void applyOrRemoveModifiersForBuff(EntityLivingBase entity, Potion buffID, Map<IAttribute, AttributeModifier> modifiers) {
        if (entity.func_70644_a(buffID)) {
            this.applyAllModifiers(entity, modifiers);
        } else {
            this.clearAllModifiers(entity, modifiers);
        }
    }

    private void applyOrRemoveScalingModifiersForBuff(EntityLivingBase entity, Potion potionID, IAttribute attribute, AttributeModifier ... modifiers) {
        IAttributeInstance inst = entity.func_110148_a(attribute);
        if (inst == null) {
            return;
        }
        AttributeModifier currentModifier = inst.func_111127_a(modifiers[0].func_111167_a());
        if (entity.func_70644_a(potionID)) {
            AttributeModifier modifier;
            int magnitude = entity.func_70660_b(potionID).func_76458_c();
            if (magnitude < 0) {
                magnitude = 0;
            }
            if (currentModifier != (modifier = modifiers[Math.min(magnitude, modifiers.length - 1)])) {
                if (currentModifier != null) {
                    inst.func_111124_b(currentModifier);
                }
                inst.func_111121_a(modifier);
            }
        } else if (currentModifier != null) {
            inst.func_111124_b(currentModifier);
        }
    }

    private void applyAllModifiers(EntityLivingBase entity, Map<IAttribute, AttributeModifier> modifiers) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : modifiers.entrySet()) {
            AttributeModifier currentModifier;
            IAttributeInstance inst = entity.func_110148_a(entry.getKey());
            if (inst == null || (currentModifier = inst.func_111127_a(entry.getValue().func_111167_a())) == entry.getValue()) continue;
            if (currentModifier != null) {
                inst.func_111124_b(currentModifier);
            }
            inst.func_111121_a(entry.getValue());
        }
    }

    private void clearAllModifiers(EntityLivingBase entity, Map<IAttribute, AttributeModifier> modifiers) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : modifiers.entrySet()) {
            AttributeModifier currentModifier;
            IAttributeInstance inst = entity.func_110148_a(entry.getKey());
            if (inst == null || (currentModifier = inst.func_111127_a(entry.getValue().func_111167_a())) != entry.getValue()) continue;
            inst.func_111124_b(currentModifier);
        }
    }
}

