/*
 * Decompiled with CFR 0.152.
 */
package am2.config;

import am2.api.ArsMagicaAPI;
import am2.api.skill.Skill;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SpellPartConfiguration
extends Configuration {
    private final ArrayList<String> disabled = new ArrayList();

    public SpellPartConfiguration(File file) {
        super(file);
    }

    public ArrayList<String> getDisabledSkills(boolean reload) {
        if (reload) {
            this.load();
            this.disabled.clear();
            for (ResourceLocation rl : ArsMagicaAPI.getSpellRegistry().func_148742_b()) {
                String name = rl.toString();
                if (name.startsWith("arsmagica2:")) {
                    name = rl.func_110623_a();
                }
                Property prop = this.get("enabled_spell_part", name, true);
                prop.setRequiresWorldRestart(true);
                if (prop.getBoolean()) continue;
                this.disabled.add(name);
            }
            this.save();
        }
        return this.disabled;
    }

    public boolean isSkillDisabled(String name) {
        name = name.replaceAll("arsmagica2:", "");
        for (String str : this.disabled) {
            if (!str.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public int[] getDisabledSkillIDs() {
        ArrayList<Integer> intArray = new ArrayList<Integer>();
        for (String disabled : this.disabled) {
            ResourceLocation rl = new ResourceLocation(disabled);
            if (!disabled.contains(":")) {
                rl = new ResourceLocation("arsmagica2:" + disabled);
            }
            intArray.add(ArsMagicaAPI.getSkillRegistry().getId(rl));
        }
        int[] ret = new int[intArray.size()];
        for (int i = 0; i < intArray.size(); ++i) {
            int d;
            ret[i] = d = ((Integer)intArray.get(i)).intValue();
        }
        return ret;
    }

    public void disableAllSkillsIn(int[] disabledSkills) {
        this.disabled.clear();
        for (int i : disabledSkills) {
            ResourceLocation rl = ((Skill)ArsMagicaAPI.getSkillRegistry().getObjectById(i)).getRegistryName();
            String name = rl.toString();
            if (name.startsWith("arsmagica2:")) {
                name = rl.func_110623_a();
            }
            this.disabled.add(name);
        }
    }
}

