/*
 * Decompiled with CFR 0.152.
 */
package am2.container;

import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.blocks.tileentity.TileEntityInscriptionTable;
import am2.container.slot.SlotInscriptionTable;
import am2.spell.SpellValidator;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;

public class ContainerInscriptionTable
extends Container {
    private final TileEntityInscriptionTable table;
    private final InventoryPlayer inventoryPlayer;
    private static final int PLAYER_INVENTORY_START = 1;
    private static final int PLAYER_ACTION_BAR_START = 28;
    private static final int PLAYER_ACTION_BAR_END = 37;

    public ContainerInscriptionTable(TileEntityInscriptionTable table, InventoryPlayer inventoryplayer) {
        this.table = table;
        this.inventoryPlayer = inventoryplayer;
        this.func_75146_a(new SlotInscriptionTable(table, 0, 102, 74));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 30 + k * 18, 170 + i * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j1, 30 + j1 * 18, 228));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.table.func_70300_a(entityplayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot == null || !slot.func_75216_d()) return itemstack;
        ItemStack itemstack1 = slot.func_75211_c();
        itemstack = itemstack1.func_77946_l();
        if (i < 1) {
            if (!this.func_75135_a(itemstack1, 1, 37, true)) {
                return null;
            }
        } else if (i >= 1 && i < 28) {
            if (this.mergeSpecialItems(itemstack1, slot)) return null;
            if (!this.func_75135_a(itemstack1, 28, 37, false)) {
                return null;
            }
        } else if (i >= 28 && i < 37) {
            if (this.mergeSpecialItems(itemstack1, slot)) return null;
            if (!this.func_75135_a(itemstack1, 1, 27, false)) {
                return null;
            }
        } else if (!this.func_75135_a(itemstack1, 1, 37, false)) {
            return null;
        }
        if (itemstack1.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (itemstack1.field_77994_a == itemstack.field_77994_a) return null;
        slot.func_75220_a(itemstack1, itemstack);
        return itemstack;
    }

    private boolean mergeSpecialItems(ItemStack stack, Slot slot) {
        if (stack.func_77973_b() instanceof ItemWritableBook) {
            Slot bookSlot = (Slot)this.field_75151_b.get(0);
            if (bookSlot.func_75216_d()) {
                return false;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = 1;
            bookSlot.func_75215_d(newStack);
            bookSlot.func_75218_e();
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
                slot.func_75218_e();
            }
            return true;
        }
        return false;
    }

    public int getCurrentRecipeSize() {
        return this.table.getCurrentRecipe().size();
    }

    public boolean currentRecipeContains(AbstractSpellPart part) {
        return this.table.getCurrentRecipe().contains((Object)part);
    }

    public AbstractSpellPart getRecipeItemAt(int index) {
        return this.table.getCurrentRecipe().get(index);
    }

    public void removeMultipleRecipeParts(int startIndex, int length) {
        this.table.removeMultipleSpellParts(startIndex, length);
    }

    public void removeSingleRecipePart(int index) {
        this.table.removeSpellPart(index);
    }

    public void addRecipePart(AbstractSpellPart part) {
        this.table.addSpellPart(part);
    }

    public void addRecipePartToGroup(int groupIndex, AbstractSpellPart part) {
        this.table.addSpellPartToStageGroup(groupIndex, part);
    }

    public void removeSingleRecipePartFromGroup(int groupIndex, int index) {
        this.table.removeSpellPartFromStageGroup(index, groupIndex);
    }

    public void removeMultipleRecipePartsFromGroup(int groupIndex, int startIndex, int length) {
        this.table.removeMultipleSpellPartsFromStageGroup(startIndex, length, groupIndex);
    }

    public int getNumStageGroups() {
        return this.table.getNumStageGroups();
    }

    public int getShapeGroupSize(int groupIndex) {
        return this.table.getShapeGroupSize(groupIndex);
    }

    public AbstractSpellPart getShapeGroupPartAt(int groupIndex, int index) {
        return this.table.getShapeGroupPartAt(groupIndex, index);
    }

    public void setSpellName(String name) {
        this.table.setSpellName(name);
    }

    public String getSpellName() {
        return this.table.getSpellName();
    }

    public void giveSpellToPlayer(EntityPlayer player) {
        this.table.createSpellForPlayer(player);
    }

    public boolean slotHasStack(int slot) {
        return ((Slot)this.field_75151_b.get(slot)).func_75216_d();
    }

    public boolean slotIsBook(int slot) {
        return this.slotHasStack(slot) && ((Slot)this.field_75151_b.get(slot)).func_75211_c().func_77973_b() == Items.field_151164_bB && ((Slot)this.field_75151_b.get(slot)).func_75211_c().func_77978_p() != null && !((Slot)this.field_75151_b.get(slot)).func_75211_c().func_77978_p().func_74767_n("spellFinalized");
    }

    public SpellValidator.ValidationResult validateCurrentDefinition() {
        return this.table.currentRecipeIsValid();
    }

    public boolean modifierCanBeAdded(SpellModifier modifier) {
        EnumSet<SpellModifiers> modifiers = modifier.getAspectsModified();
        for (SpellModifiers mod : modifiers) {
            if (this.table.getModifierCount(mod) <= 2) continue;
            return false;
        }
        return true;
    }

    public boolean currentSpellDefIsReadOnly() {
        return this.table.currentSpellDefIsReadOnly();
    }

    public void resetSpellNameAndIcon() {
        ItemStack stack = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (stack != null) {
            this.table.resetSpellNameAndIcon(stack, this.inventoryPlayer.field_70458_d);
        }
        ((Slot)this.field_75151_b.get(0)).func_75218_e();
        this.func_75142_b();
    }
}

