/*
 * Decompiled with CFR 0.152.
 */
package am2.container;

import am2.container.InventoryKeyStone;
import am2.container.InventoryRuneBag;
import am2.container.slot.SlotRuneOnly;
import am2.defs.ItemDefs;
import am2.items.ItemKeystone;
import am2.items.ItemRune;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.utils.InventoryUtilities;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerKeystone
extends Container {
    private final ItemStack keystoneStack;
    private final ItemStack runeBagStack;
    private final InventoryKeyStone keyStoneInventory;
    private final InventoryRuneBag runeBag;
    public final int runebagSlot;
    private final EntityPlayer player;
    public int specialSlotIndex;
    private int PLAYER_INVENTORY_START = 3;
    private int PLAYER_ACTION_BAR_START = 30;
    private int PLAYER_ACTION_BAR_END = 38;

    public ContainerKeystone(InventoryPlayer inventoryplayer, ItemStack bookStack, ItemStack runeBagStack, InventoryKeyStone inventoryKeystone, InventoryRuneBag runeBag, int runeBagSlot) {
        this.keyStoneInventory = inventoryKeystone;
        this.keystoneStack = bookStack;
        this.runeBag = runeBag;
        this.runebagSlot = runeBagSlot;
        this.runeBagStack = runeBagStack;
        this.player = inventoryplayer.field_70458_d;
        int slotIndex = 0;
        this.func_75146_a(new SlotRuneOnly(this.keyStoneInventory, slotIndex++, 80, 18));
        this.func_75146_a(new SlotRuneOnly(this.keyStoneInventory, slotIndex++, 91, 36));
        this.func_75146_a(new SlotRuneOnly(this.keyStoneInventory, slotIndex++, 69, 36));
        if (this.runeBag != null) {
            int runeSlotIndex = 0;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.func_75146_a(new SlotRuneOnly(this.runeBag, runeSlotIndex++, 8 + i * 18, 109 + j * 17));
                }
            }
            this.PLAYER_INVENTORY_START += 16;
            this.PLAYER_ACTION_BAR_START += 16;
            this.PLAYER_ACTION_BAR_END += 16;
        }
        int playerInventoryCounter = 0;
        int y = this.runebagSlot > -1 ? 216 : 179;
        for (int j1 = 0; j1 < 9; ++j1) {
            if (playerInventoryCounter++ == runeBagSlot) continue;
            if (inventoryplayer.func_70301_a(j1) == bookStack) {
                this.specialSlotIndex = j1 + 32;
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j1, 8 + j1 * 18, y));
        }
        y = this.runebagSlot > -1 ? 158 : 121;
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                if (playerInventoryCounter++ == runeBagSlot) continue;
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, y + i * 18));
            }
        }
    }

    public ItemStack[] GetFullKeystoneInventory() {
        ItemStack[] stack = new ItemStack[3];
        for (int i = 0; i < 3; ++i) {
            stack[i] = ((Slot)this.field_75151_b.get(i)).func_75211_c();
        }
        return stack;
    }

    public ItemStack[] GetFullRuneBagInventory() {
        ItemStack[] stack = new ItemStack[16];
        for (int i = 3; i < 19; ++i) {
            stack[i - 3] = ((Slot)this.field_75151_b.get(i)).func_75211_c();
        }
        return stack;
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        if (!world.field_72995_K) {
            ItemStack keyStoneItemStack = this.keystoneStack;
            ItemStack[] items = this.GetFullKeystoneInventory();
            ItemDefs.keystone.UpdateStackTagCompound(keyStoneItemStack, items);
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, keyStoneItemStack);
            if (this.runeBagStack != null) {
                ItemStack runebagItemStack = this.runeBagStack;
                items = this.GetFullRuneBagInventory();
                ItemDefs.runeBag.UpdateStackTagCompound(runebagItemStack, items);
                entityplayer.field_71071_by.func_70299_a(InventoryUtilities.getInventorySlotIndexFor((IInventory)entityplayer.field_71071_by, ItemDefs.runeBag), runebagItemStack);
            }
        }
        super.func_75134_a(entityplayer);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.keyStoneInventory.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (i < this.PLAYER_INVENTORY_START) {
                if (this.PLAYER_INVENTORY_START > 3) {
                    if (i > 3) {
                        for (int n = 0; n < 3; ++n) {
                            Slot runeSlot = (Slot)this.field_75151_b.get(n);
                            if (runeSlot.func_75216_d()) continue;
                            runeSlot.func_75215_d(new ItemStack(itemstack1.func_77973_b(), 1, itemstack1.func_77952_i()));
                            runeSlot.func_75218_e();
                            --itemstack1.field_77994_a;
                            if (itemstack1.field_77994_a == 0) {
                                slot.func_75215_d(null);
                                slot.func_75218_e();
                            }
                            return null;
                        }
                    } else {
                        for (int n = 3; n < this.PLAYER_INVENTORY_START; ++n) {
                            Slot runeSlot = (Slot)this.field_75151_b.get(n);
                            if (runeSlot.func_75216_d()) continue;
                            runeSlot.func_75215_d(new ItemStack(itemstack1.func_77973_b(), 1, itemstack1.func_77952_i()));
                            runeSlot.func_75218_e();
                            --itemstack1.field_77994_a;
                            if (itemstack1.field_77994_a == 0) {
                                slot.func_75215_d(null);
                                slot.func_75218_e();
                            }
                            return null;
                        }
                    }
                }
                if (!this.func_75135_a(itemstack1, this.PLAYER_INVENTORY_START, this.PLAYER_ACTION_BAR_END - 1, true)) {
                    return null;
                }
            } else if (i >= this.PLAYER_INVENTORY_START && i < this.PLAYER_ACTION_BAR_START) {
                if (itemstack.func_77973_b() instanceof ItemRune) {
                    for (int n = 0; n < this.PLAYER_INVENTORY_START; ++n) {
                        Slot runeSlot = (Slot)this.field_75151_b.get(n);
                        if (runeSlot.func_75216_d()) continue;
                        runeSlot.func_75215_d(new ItemStack(itemstack1.func_77973_b(), 1, itemstack1.func_77952_i()));
                        runeSlot.func_75218_e();
                        --itemstack1.field_77994_a;
                        if (itemstack1.field_77994_a == 0) {
                            slot.func_75215_d(null);
                            slot.func_75218_e();
                        }
                        return null;
                    }
                }
                if (!this.func_75135_a(itemstack1, this.PLAYER_ACTION_BAR_START, this.PLAYER_ACTION_BAR_END - 1, false)) {
                    return null;
                }
            } else if (i >= this.PLAYER_ACTION_BAR_START && i < this.PLAYER_ACTION_BAR_END) {
                if (itemstack.func_77973_b() instanceof ItemRune) {
                    for (int n = 0; n < this.PLAYER_INVENTORY_START; ++n) {
                        Slot runeSlot = (Slot)this.field_75151_b.get(n);
                        if (runeSlot.func_75216_d()) continue;
                        runeSlot.func_75215_d(new ItemStack(itemstack1.func_77973_b(), 1, itemstack1.func_77952_i()));
                        runeSlot.func_75218_e();
                        --itemstack1.field_77994_a;
                        if (itemstack1.field_77994_a == 0) {
                            slot.func_75215_d(null);
                            slot.func_75218_e();
                        }
                        return null;
                    }
                }
                if (!this.func_75135_a(itemstack1, this.PLAYER_INVENTORY_START, this.PLAYER_ACTION_BAR_START, false)) {
                    return null;
                }
            } else if (!this.func_75135_a(itemstack1, this.PLAYER_INVENTORY_START, this.PLAYER_ACTION_BAR_END, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a != itemstack.field_77994_a) {
                slot.func_75220_a(itemstack1, itemstack);
            } else {
                return null;
            }
        }
        return itemstack;
    }

    public ItemKeystone.KeystoneCombination getCurrentMatchedCombination() {
        int savedCombos = ItemDefs.keystone.numCombinations(this.keystoneStack);
        int[] curMeta = new int[3];
        for (int c = 0; c < 3; ++c) {
            ItemStack stack = this.keyStoneInventory.func_70301_a(c);
            curMeta[c] = stack != null ? stack.func_77952_i() : -1;
        }
        for (int i = 0; i < savedCombos; ++i) {
            ItemKeystone.KeystoneCombination currentCombo = ItemDefs.keystone.getCombinationAt(this.keystoneStack, i);
            if (currentCombo.metas.length < 3) continue;
            boolean match = true;
            for (int c = 0; c < 3; ++c) {
                match &= curMeta[c] == currentCombo.metas[c];
            }
            if (!match) continue;
            return currentCombo;
        }
        return null;
    }

    public ItemStack getKeystoneStack() {
        return this.keystoneStack;
    }

    public boolean setInventoryToCombination(int comboIndex) {
        ItemKeystone.KeystoneCombination combo = ItemDefs.keystone.getCombinationAt(this.keystoneStack, comboIndex);
        if (combo == null) {
            return false;
        }
        if (!this.inventoryContainsAllMetas(combo.metas)) {
            return false;
        }
        if (this.player.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendPacketToServer((byte)41, new AMDataWriter().add(comboIndex).generate());
            return true;
        }
        int matchIndex = 0;
        int searchIndex = 0;
        while (matchIndex < combo.metas.length && searchIndex < 3 + (this.runeBag != null ? 16 : 0)) {
            int inventoryIndex;
            Object searchInventory = searchIndex >= 3 ? this.runeBag : this.keyStoneInventory;
            ItemStack stack = searchInventory.func_70301_a(inventoryIndex = searchIndex >= 3 ? searchIndex - 3 : searchIndex);
            if (stack != null && stack.func_77952_i() == combo.metas[matchIndex]) {
                this.swapInventorySlots(this.keyStoneInventory, (IInventory)searchInventory, matchIndex, inventoryIndex);
                searchIndex = ++matchIndex;
                continue;
            }
            if (stack == null && combo.metas[matchIndex] == -1) {
                this.swapInventorySlots(this.keyStoneInventory, (IInventory)searchInventory, matchIndex, inventoryIndex);
                searchIndex = ++matchIndex;
                continue;
            }
            ++searchIndex;
        }
        this.func_75142_b();
        return true;
    }

    private void swapInventorySlots(IInventory firstInventory, IInventory secondInventory, int slot1, int slot2) {
        if (firstInventory == secondInventory && slot1 == slot2) {
            return;
        }
        ItemStack stack1 = firstInventory.func_70301_a(slot1);
        ItemStack stack2 = secondInventory.func_70301_a(slot2);
        firstInventory.func_70299_a(slot1, stack2);
        secondInventory.func_70299_a(slot2, stack1);
    }

    private boolean inventoryContainsAllMetas(int[] metas) {
        int qty;
        int meta;
        int i;
        HashMap<Integer, Integer> metaQuantities = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> invQuantities = new HashMap<Integer, Integer>();
        for (int i2 : metas) {
            if (i2 == -1) continue;
            if (metaQuantities.containsKey(i2)) {
                int qty2 = (Integer)metaQuantities.get(i2);
                metaQuantities.put(i2, ++qty2);
                continue;
            }
            metaQuantities.put(i2, 1);
        }
        for (i = 0; i < this.keyStoneInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.keyStoneInventory.func_70301_a(i);
            if (stack == null) continue;
            meta = stack.func_77952_i();
            if (invQuantities.containsKey(meta)) {
                qty = (Integer)invQuantities.get(meta);
                invQuantities.put(meta, ++qty);
                continue;
            }
            invQuantities.put(meta, 1);
        }
        if (this.runeBag != null) {
            for (i = 0; i < this.runeBag.func_70302_i_(); ++i) {
                ItemStack stack = this.runeBag.func_70301_a(i);
                if (stack == null) continue;
                meta = stack.func_77952_i();
                if (invQuantities.containsKey(meta)) {
                    qty = (Integer)invQuantities.get(meta);
                    invQuantities.put(meta, ++qty);
                    continue;
                }
                invQuantities.put(meta, 1);
            }
        }
        Iterator iterator = metaQuantities.keySet().iterator();
        while (iterator.hasNext()) {
            int i3 = (Integer)iterator.next();
            if (!invQuantities.containsKey(i3)) {
                return false;
            }
            if ((Integer)invQuantities.get(i3) >= (Integer)metaQuantities.get(i3)) continue;
            return false;
        }
        return true;
    }
}

