/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.defs.ItemDefs;
import am2.defs.LootTablesArsMagica;
import am2.entity.EntityLightMage;
import am2.entity.EntityManaVortex;
import am2.entity.SpawnBlacklists;
import am2.entity.ai.EntityAIRangedAttackSpell;
import am2.entity.ai.selectors.DarkMageEntitySelector;
import am2.extensions.EntityExtension;
import am2.utils.NPCSpells;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDarkMage
extends EntityMob {
    private static ItemStack diminishedHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NONE));
    private static ItemStack normalHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NONE));
    private static ItemStack augmentedHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NONE));
    public static final DataParameter<Integer> MAGE_SKIN = EntityDataManager.func_187226_a(EntityDarkMage.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> MAGE_BOOK = EntityDataManager.func_187226_a(EntityDarkMage.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDarkMage(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        EntityExtension.For((EntityLivingBase)this).setMagicLevelWithMana(10 + this.field_70146_Z.nextInt(20));
        this.initAI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGE_BOOK, (Object)0);
        this.field_70180_af.func_187214_a(MAGE_SKIN, (Object)(this.field_70146_Z.nextInt(10) + 1));
    }

    public void disarm() {
        if ((Integer)this.field_70180_af.func_187225_a(MAGE_BOOK) != -1) {
            this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)-1);
            for (Object a : this.field_70714_bg.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!(ai instanceof EntityAIRangedAttackSpell)) continue;
                this.field_70714_bg.func_85156_a(ai);
            }
        }
        this.func_98053_h(true);
    }

    public ItemStack func_184614_ca() {
        int cm = (Integer)this.field_70180_af.func_187225_a(MAGE_BOOK);
        if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null) {
            return this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        }
        if (cm == -1) {
            return null;
        }
        if (cm == 0) {
            return diminishedHeldItem;
        }
        if (cm == 1) {
            return normalHeldItem;
        }
        return augmentedHeldItem;
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLightMage.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)this.MovementSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityManaVortex.class, 10.0f, (double)this.MovementSpeed(), (double)this.ActionSpeed()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 40, NPCSpells.instance.darkMage_DiminishedAttack));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)this.MovementSpeed(), false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLightMage.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, (Predicate)DarkMageEntitySelector.instance));
    }

    public int func_70658_aO() {
        return 5;
    }

    protected float MovementSpeed() {
        return 0.4f;
    }

    protected float ActionSpeed() {
        return 0.5f;
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesArsMagica.DARK_MAGE_LOOT;
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.field_70180_af.func_187227_b(MAGE_SKIN, (Object)par1nbtTagCompound.func_74762_e("am2_dm_skin"));
        this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)par1nbtTagCompound.func_74762_e("am2_dm_book"));
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("am2_dm_skin", ((Integer)this.field_70180_af.func_187225_a(MAGE_SKIN)).intValue());
        par1nbtTagCompound.func_74768_a("am2_dm_book", ((Integer)this.field_70180_af.func_187225_a(MAGE_BOOK)).intValue());
    }

    private int getAverageNearbyPlayerMagicLevel() {
        if (this.field_70170_p == null) {
            return 0;
        }
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - 250.0, 0.0, this.field_70161_v - 250.0, this.field_70165_t + 250.0, 250.0, this.field_70161_v + 250.0));
        if (players.size() == 0) {
            return 0;
        }
        int avgLvl = 0;
        for (EntityPlayer player : players) {
            avgLvl += EntityExtension.For((EntityLivingBase)player).getCurrentLevel();
        }
        return (int)Math.ceil(avgLvl / players.size());
    }

    public boolean func_70601_bi() {
        if (!SpawnBlacklists.entityCanSpawnHere(this.func_180425_c(), this.field_70170_p, (EntityLivingBase)this)) {
            return false;
        }
        if (this.getAverageNearbyPlayerMagicLevel() < 8) {
            return false;
        }
        EntityExtension.For((EntityLivingBase)this).setMagicLevelWithMana(5);
        int avgLevel = this.getAverageNearbyPlayerMagicLevel();
        if (avgLevel == 0) {
            if (this.field_70146_Z.nextInt(100) < 10) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 80, NPCSpells.instance.darkMage_NormalAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)1);
            }
        } else {
            int levelRand = this.field_70146_Z.nextInt(avgLevel * 2);
            if (levelRand > 60) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 160, NPCSpells.instance.darkMage_AugmentedAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)2);
            } else if (levelRand > 30) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 80, NPCSpells.instance.darkMage_NormalAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)1);
            }
        }
        return super.func_70601_bi();
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if ((Integer)this.field_70180_af.func_187225_a(MAGE_BOOK) == -1) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        return String.format("arsmagica2:textures/mobs/dark_mages/dark_mage_%d.png", (int)((Integer)this.field_70180_af.func_187225_a(MAGE_SKIN)));
    }
}

