/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.defs.ItemDefs;
import am2.defs.LootTablesArsMagica;
import am2.defs.SkillDefs;
import am2.entity.EntityDarkMage;
import am2.entity.EntityManaVortex;
import am2.entity.SpawnBlacklists;
import am2.entity.ai.EntityAIAllyManaLink;
import am2.entity.ai.EntityAIRangedAttackSpell;
import am2.entity.ai.selectors.LightMageEntitySelector;
import am2.extensions.EntityExtension;
import am2.extensions.SkillData;
import am2.utils.EntityUtils;
import am2.utils.NPCSpells;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightMage
extends EntityCreature {
    int hp;
    private static ItemStack diminishedHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, 2);
    private static ItemStack normalHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, 7);
    private static ItemStack augmentedHeldItem = new ItemStack((Item)ItemDefs.affinityTome, 1, 5);
    public static final DataParameter<Integer> MAGE_SKIN = EntityDataManager.func_187226_a(EntityLightMage.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> MAGE_BOOK = EntityDataManager.func_187226_a(EntityLightMage.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLightMage(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.hp = this.field_70146_Z.nextInt(10) + 12;
        this.initAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGE_BOOK, (Object)0);
        this.field_70180_af.func_187214_a(MAGE_SKIN, (Object)(this.field_70146_Z.nextInt(12) + 1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(22.0);
    }

    public ItemStack func_184614_ca() {
        int cm = (Integer)this.field_70180_af.func_187225_a(MAGE_BOOK);
        if (cm == 0) {
            return diminishedHeldItem;
        }
        if (cm == 1) {
            return normalHeldItem;
        }
        return augmentedHeldItem;
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)this.MovementSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityManaVortex.class, 10.0f, (double)this.MovementSpeed(), (double)this.ActionSpeed()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAllyManaLink(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 20, NPCSpells.instance.lightMage_DiminishedAttack));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDarkMage.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, false, (Predicate)LightMageEntitySelector.instance));
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.field_70180_af.func_187227_b(MAGE_SKIN, (Object)par1nbtTagCompound.func_74762_e("am2_lm_skin"));
        this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)par1nbtTagCompound.func_74762_e("am2_lm_book"));
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("am2_lm_skin", ((Integer)this.field_70180_af.func_187225_a(MAGE_SKIN)).intValue());
        par1nbtTagCompound.func_74768_a("am2_lm_book", ((Integer)this.field_70180_af.func_187225_a(MAGE_BOOK)).intValue());
    }

    public int func_70658_aO() {
        return 1;
    }

    protected float MovementSpeed() {
        return 0.4f;
    }

    protected float ActionSpeed() {
        return 0.5f;
    }

    public boolean func_175446_cd() {
        return false;
    }

    private int getAverageNearbyPlayerMagicLevel() {
        if (this.field_70170_p == null) {
            return 0;
        }
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(250.0, 250.0, 250.0));
        if (players.size() == 0) {
            return 0;
        }
        int avgLvl = 0;
        for (EntityPlayer player : players) {
            avgLvl += EntityExtension.For((EntityLivingBase)player).getCurrentLevel();
        }
        return (int)Math.ceil(avgLvl / players.size());
    }

    public boolean func_70601_bi() {
        if (!SpawnBlacklists.entityCanSpawnHere(this.func_180425_c(), this.field_70170_p, (EntityLivingBase)this)) {
            return false;
        }
        if (this.getAverageNearbyPlayerMagicLevel() < 8) {
            return false;
        }
        int avgLevel = this.getAverageNearbyPlayerMagicLevel();
        if (avgLevel == 0) {
            EntityExtension.For((EntityLivingBase)this).setMagicLevelWithMana(10);
            if (this.field_70146_Z.nextInt(100) < 10) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 40, NPCSpells.instance.lightMage_NormalAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)1);
            }
        } else {
            EntityExtension.For((EntityLivingBase)this).setMagicLevelWithMana(10 + this.field_70146_Z.nextInt(avgLevel));
            int levelRand = this.field_70146_Z.nextInt(avgLevel * 2);
            if (levelRand > 60) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 100, NPCSpells.instance.lightMage_AugmentedAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)2);
            }
            if (levelRand > 30) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 40, NPCSpells.instance.lightMage_NormalAttack));
                this.field_70180_af.func_187227_b(MAGE_BOOK, (Object)1);
            }
        }
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    protected boolean isValidLightLevel() {
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, this.func_180425_c()) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int var4 = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, this.func_180425_c());
        if (this.field_70170_p.func_72911_I()) {
            int var5 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            var4 = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, this.func_180425_c());
            this.field_70170_p.func_175692_b(var5);
        }
        return var4 <= this.field_70146_Z.nextInt(8);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesArsMagica.LIGHT_MAGE_LOOT;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemNameTag) {
            return EnumActionResult.PASS;
        }
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        if (SkillData.For((EntityLivingBase)player).hasSkill(SkillDefs.MAGE_POSSE_1.getID())) {
            if (EntityUtils.isSummon((EntityLivingBase)this)) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("\u00a7o%s", I18n.func_74838_a((String)"am2.npc.partyleave"))));
                EntityUtils.revertAI(this);
            } else if (EntityExtension.For((EntityLivingBase)player).getCanHaveMoreSummons()) {
                if (EntityExtension.For((EntityLivingBase)player).getCurrentLevel() - 5 >= EntityExtension.For((EntityLivingBase)this).getCurrentLevel()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format("\u00a7o%s", I18n.func_74838_a((String)"am2.npc.partyjoin"))));
                    EntityUtils.setOwner((EntityLivingBase)this, (EntityLivingBase)player);
                    EntityUtils.makeSummon_PlayerFaction(this, player, true);
                    EntityUtils.setSummonDuration((EntityLivingBase)this, -1);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format("\u00a7o%s", I18n.func_74838_a((String)"am2.npc.partyrefuse"))));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("\u00a7o%s", I18n.func_74838_a((String)"am2.npc.partyfull"))));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("\u00a7o%s", I18n.func_74838_a((String)"am2.npc.nopartyskill"))));
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        return String.format("arsmagica2:textures/mobs/light_mages/light_mage_%d.png", (int)((Integer)this.field_70180_af.func_187225_a(MAGE_SKIN)));
    }
}

