/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToEntity;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.utils.MathUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityManaVortex
extends Entity {
    private float rotation;
    private float scale = 0.0f;
    public static final DataParameter<Integer> TICKS_TO_EXIST = EntityDataManager.func_187226_a(EntityManaVortex.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> MANA_STOLEN = EntityDataManager.func_187226_a(EntityManaVortex.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean hasGoneBoom = false;

    public EntityManaVortex(World par1World) {
        super(par1World);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TICKS_TO_EXIST, (Object)(50 + this.field_70146_Z.nextInt(250)));
        this.field_70180_af.func_187214_a(MANA_STOLEN, (Object)Float.valueOf(0.0f));
    }

    public int getTicksToExist() {
        try {
            return (Integer)this.field_70180_af.func_187225_a(TICKS_TO_EXIST);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void func_70071_h_() {
        List players;
        ++this.field_70173_aa;
        this.rotation += 5.0f;
        if (!this.field_70170_p.field_72995_K && (this.field_70128_L || this.field_70173_aa >= this.getTicksToExist())) {
            this.func_70106_y();
            return;
        }
        if (this.getTicksToExist() - this.field_70173_aa <= 20) {
            this.scale -= 0.05f;
        } else if (this.scale < 0.99f) {
            this.scale = (float)Math.sin((float)this.field_70173_aa / 50.0f);
        }
        if (this.getTicksToExist() - this.field_70173_aa <= 5 && !this.hasGoneBoom) {
            this.hasGoneBoom = true;
            if (!this.field_70170_p.field_72995_K) {
                Object[] playerArray;
                players = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(3.0 + Math.floor(this.field_70173_aa / 50), 2.0, 3.0 + Math.floor(this.field_70173_aa / 50)));
                float damage = ((Float)this.field_70180_af.func_187225_a(MANA_STOLEN)).floatValue() * 0.005f;
                if (damage > 100.0f) {
                    damage = 100.0f;
                }
                Object[] objectArray = playerArray = players.toArray();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object o = objectArray[i];
                    EntityLivingBase e = (EntityLivingBase)o;
                    RayTraceResult mop = this.field_70170_p.func_72901_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v), false);
                    if (mop != null) continue;
                    e.func_70097_a(DamageSources.causePhysicalDamage(this), damage);
                }
            } else {
                for (int i = 0; i < 360; i += ArsMagica2.config.FullGFX() ? 5 : (ArsMagica2.config.LowGFX() ? 10 : 20)) {
                    AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "ember", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                    if (effect == null) continue;
                    effect.setIgnoreMaxAge(true);
                    effect.AddParticleController(new ParticleMoveOnHeading(effect, i, 0.0, 0.7f, 1, false));
                    effect.setRGBColorF(0.24f, 0.24f, 0.8f);
                    effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
                    effect.AddParticleController(new ParticleLeaveParticleTrail(effect, "ember", false, 5, 1, false).addControllerToParticleList(new ParticleMoveOnHeading(effect, i, 0.0, 0.1f, 1, false)).addControllerToParticleList(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.1f).setKillParticleOnFinish(true)).setParticleRGB_F(0.24f, 0.24f, 0.8f).addRandomOffset(0.2f, 0.2f, 0.2f));
                }
            }
        }
        if (this.getTicksToExist() - this.field_70173_aa > 30) {
            Object[] playerArray;
            players = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(3.0 + Math.floor(this.field_70173_aa / 50), 2.0, 3.0 + Math.floor(this.field_70173_aa / 50)));
            for (Object o : playerArray = players.toArray()) {
                float curMana;
                float manaStolen;
                EntityLivingBase e = (EntityLivingBase)o;
                RayTraceResult mop = this.field_70170_p.func_72901_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v), false);
                if (mop != null) continue;
                if (this.field_70170_p.field_72995_K) {
                    if (ArsMagica2.config.NoGFX() || ArsMagica2.config.LowGFX() && this.field_70173_aa % 4 != 0) break;
                    AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "ember", e.field_70165_t, e.field_70163_u + (double)(e.func_70047_e() / 2.0f), e.field_70161_v));
                    if (effect != null) {
                        effect.setRGBColorF(0.24f, 0.24f, 0.8f);
                        effect.AddParticleController(new ParticleArcToEntity(effect, 1, this, false).generateControlPoints().setKillParticleOnFinish(true));
                        effect.setIgnoreMaxAge(true);
                    }
                }
                if ((manaStolen = EntityExtension.For(e).getMaxMana() * 0.01f) > (curMana = EntityExtension.For(e).getCurrentMana())) {
                    manaStolen = curMana;
                }
                this.field_70180_af.func_187227_b(MANA_STOLEN, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(MANA_STOLEN)).floatValue() + manaStolen));
                EntityExtension.For(e).setCurrentMana(EntityExtension.For(e).getCurrentMana() - manaStolen);
                Vec3d movement = MathUtilities.GetMovementVectorBetweenEntities((Entity)e, this);
                float speed = -0.075f;
                e.func_70024_g(movement.field_72450_a * (double)speed, movement.field_72448_b * (double)speed, movement.field_72449_c * (double)speed);
            }
        }
    }

    public float getManaStolenPercent() {
        float damage = ((Float)this.field_70180_af.func_187225_a(MANA_STOLEN)).floatValue() * 0.005f;
        if (damage > 100.0f) {
            damage = 100.0f;
        }
        return damage / 100.0f;
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.field_70180_af.func_187227_b(TICKS_TO_EXIST, (Object)var1.func_74762_e("ticksToExist"));
        this.field_70180_af.func_187227_b(MANA_STOLEN, (Object)Float.valueOf(var1.func_74760_g("manaStolen")));
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74768_a("ticksToExist", this.getTicksToExist());
        var1.func_74776_a("manaStolen", ((Float)this.field_70180_af.func_187225_a(MANA_STOLEN)).floatValue());
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScale() {
        return this.scale;
    }

    public float getManaStolen() {
        return ((Float)this.field_70180_af.func_187225_a(MANA_STOLEN)).floatValue();
    }
}

