/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.buffs.BuffEffectFrostSlowed;
import am2.entity.EntityDummyCaster;
import am2.particles.AMParticle;
import am2.particles.AMParticleDefs;
import am2.particles.ParticleFleePoint;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitPoint;
import am2.spell.modifier.Colour;
import am2.utils.AMLineSegment;
import am2.utils.AffinityShiftUtils;
import am2.utils.DummyEntityPlayer;
import am2.utils.MathUtilities;
import am2.utils.SpellUtils;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySpellEffect
extends Entity {
    private float rotation = 0.0f;
    private final float rotationSpeed;
    private int ticksToEffect = 20;
    private int maxTicksToEffect = 20;
    private int maxTicksToEffect_wall = 5;
    private int ticksToExist = 100;
    private ItemStack spellStack;
    private EntityPlayer dummycaster;
    private int casterEntityID;
    private float moveSpeed;
    private static final DataParameter<Optional<ItemStack>> WATCHER_STACK = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Float> WATCHER_RADIUS = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> WATCHER_GRAVITY = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> WATCHER_TYPE = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> WATCHER_ROF_IGNITE = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> WATCHER_DAMAGEBONUS = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final int TYPE_ZONE = 0;
    private static final int TYPE_ROF = 1;
    private static final int TYPE_BLIZ = 2;
    private static final int TYPE_WALL = 3;
    private static final int TYPE_WAVE = 4;
    private boolean firstApply = true;

    public EntitySpellEffect(World par1World) {
        super(par1World);
        this.rotationSpeed = 10.0f;
        this.func_70105_a(0.25f, 0.25f);
    }

    public void SetCasterAndStack(EntityLivingBase caster, ItemStack spellScroll) {
        this.spellStack = spellScroll;
        this.dummycaster = DummyEntityPlayer.fromEntityLiving(caster);
        this.casterEntityID = caster.func_145782_y();
        if (this.spellStack != null) {
            this.field_70180_af.func_187227_b(WATCHER_STACK, (Object)Optional.fromNullable((Object)this.spellStack));
        }
    }

    public void setRadius(float newRadius) {
        this.field_70180_af.func_187227_b(WATCHER_RADIUS, (Object)Float.valueOf(newRadius));
    }

    public void setTickRate(int newTickRate) {
        this.maxTicksToEffect = newTickRate;
    }

    public void setTicksToExist(int ticks) {
        this.ticksToExist = ticks;
    }

    public void setGravity(double gravity) {
        this.field_70180_af.func_187227_b(WATCHER_GRAVITY, (Object)Float.valueOf((float)gravity));
    }

    public void setDamageBonus(float damageBonus) {
        this.field_70180_af.func_187227_b(WATCHER_DAMAGEBONUS, (Object)Float.valueOf(damageBonus));
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setWall(float rotation) {
        this.func_70101_b(rotation, 0.0f);
        this.field_70180_af.func_187227_b(WATCHER_TYPE, (Object)3);
    }

    public void setWave(float rotation, float speed) {
        this.func_70101_b(rotation, 0.0f);
        this.field_70180_af.func_187227_b(WATCHER_TYPE, (Object)4);
        this.moveSpeed = speed;
        this.field_70138_W = 0.6f;
        this.maxTicksToEffect_wall = 1;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(WATCHER_RADIUS, (Object)Float.valueOf(3.0f));
        this.field_70180_af.func_187214_a(WATCHER_STACK, (Object)Optional.of((Object)new ItemStack(Items.field_151153_ao)));
        this.field_70180_af.func_187214_a(WATCHER_GRAVITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(WATCHER_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(WATCHER_ROF_IGNITE, (Object)false);
        this.field_70180_af.func_187214_a(WATCHER_DAMAGEBONUS, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        if (this.dummycaster != null && this.dummycaster instanceof DummyEntityPlayer) {
            this.dummycaster.func_70071_h_();
        }
        switch ((Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE)) {
            case 0: {
                this.zoneUpdate();
                break;
            }
            case 1: {
                this.rainOfFireUpdate();
                break;
            }
            case 2: {
                this.blizzardUpdate();
                break;
            }
            case 3: {
                this.wallUpdate();
                break;
            }
            case 4: {
                this.waveUpdate();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.ticksToExist) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (this.dummycaster instanceof DummyEntityPlayer) {
            this.dummycaster.func_70106_y();
        }
        super.func_70106_y();
    }

    private void zoneUpdate() {
        if (this.field_70170_p.field_72995_K && !ArsMagica2.config.NoGFX()) {
            this.rotation += this.rotationSpeed;
            this.rotation %= 360.0f;
            double dist = this.getRadius();
            double _rotation = this.rotation;
            if (this.spellStack == null) {
                this.spellStack = this.getEffectStack();
                if (this.spellStack == null) {
                    return;
                }
            }
            this.spellStack = this.spellStack.func_77946_l();
            int color = 0xFFFFFF;
            if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, this.spellStack)) {
                ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(this.spellStack, -1);
                for (SpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, this.spellStack.func_77978_p());
                }
            }
            if (ArsMagica2.config.FullGFX() && this.field_70173_aa % 2 == 0 || this.field_70173_aa % 8 == 0) {
                for (int i = 0; i < 4; ++i) {
                    _rotation = (this.rotation + (float)(90 * i)) % 360.0f;
                    double x = this.field_70165_t - Math.cos(0.01745 * _rotation) * dist;
                    double z = this.field_70161_v - Math.sin(0.01745 * _rotation) * dist;
                    AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, AMParticleDefs.getParticleForAffinity(AffinityShiftUtils.getMainShiftForStack(this.spellStack)), x, this.field_70163_u, z));
                    if (effect == null) continue;
                    effect.setIgnoreMaxAge(false);
                    effect.func_187114_a(20);
                    effect.setParticleScale(0.15f);
                    effect.setRGBColorI(color);
                    effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                    if (!ArsMagica2.config.LowGFX()) continue;
                    effect.AddParticleController(new ParticleOrbitPoint(effect, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2, false).setIgnoreYCoordinate(true).SetOrbitSpeed(0.05f).SetTargetDistance(dist).setRotateDirection(true));
                }
            }
        }
        this.func_70091_d(0.0, ((Float)this.field_70180_af.func_187225_a(WATCHER_GRAVITY)).floatValue(), 0.0);
        --this.ticksToEffect;
        if (this.spellStack == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        if (this.dummycaster == null) {
            this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
        }
        if (this.ticksToEffect <= 0) {
            this.ticksToEffect = this.maxTicksToEffect;
            float radius = ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
            List possibleTargets = this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - 3.0, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + 3.0, this.field_70161_v + (double)radius));
            for (Entity e : possibleTargets) {
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if (!(e instanceof EntityLivingBase)) continue;
                SpellUtils.applyStackStage(this.spellStack.func_77946_l(), (EntityLivingBase)this.dummycaster, (EntityLivingBase)e, e.field_70165_t, e.field_70163_u - 1.0, e.field_70161_v, null, this.field_70170_p, false, false, this.field_70173_aa);
            }
            if (((Float)this.field_70180_af.func_187225_a(WATCHER_GRAVITY)).floatValue() < 0.0f && !this.firstApply) {
                SpellUtils.applyStackStage(this.spellStack.func_77946_l(), (EntityLivingBase)this.dummycaster, null, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, null, this.field_70170_p, false, false, this.field_70173_aa);
            } else {
                SpellUtils.applyStackStage(this.spellStack.func_77946_l(), (EntityLivingBase)this.dummycaster, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, null, this.field_70170_p, false, false, this.field_70173_aa);
            }
            this.firstApply = false;
            for (float i = -radius; i <= radius; i += 1.0f) {
                for (int j = -3; j <= 3; ++j) {
                    Vec3d[] blocks;
                    for (Vec3d vec : blocks = this.getAllBlockLocationsBetween(new Vec3d(this.field_70165_t + (double)i, this.field_70163_u + (double)j, this.field_70161_v - (double)radius), new Vec3d(this.field_70165_t + (double)i, this.field_70163_u + (double)j, this.field_70161_v + (double)radius))) {
                        SpellUtils.applyStageToGround(this.spellStack.func_77946_l(), (EntityLivingBase)this.dummycaster, this.field_70170_p, new BlockPos(vec), EnumFacing.UP, vec.field_72450_a + 0.5, vec.field_72448_b + 0.5, vec.field_72449_c + 0.5, false);
                    }
                }
            }
        }
    }

    private void rainOfFireUpdate() {
        float radius = ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
        if (this.field_70170_p.field_72995_K) {
            if (this.spellStack == null) {
                this.spellStack = this.getEffectStack();
                if (this.spellStack == null) {
                    return;
                }
            }
            this.spellStack = this.spellStack.func_77946_l();
            int color = 0xFFFFFF;
            if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, this.spellStack)) {
                ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(this.spellStack, -1);
                for (SpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, this.spellStack.func_77978_p());
                }
            }
            for (int i = 0; i < 10; ++i) {
                double z;
                double y;
                double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", x, y = this.field_70163_u + 10.0, z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0));
                if (particle == null) continue;
                particle.func_187114_a(20);
                particle.addVelocity(this.field_70146_Z.nextDouble() * (double)0.2f, 0.0, this.field_70146_Z.nextDouble() * (double)0.2f);
                particle.setAffectedByGravity();
                particle.setDontRequireControllers();
                particle.setRGBColorI(color);
            }
        } else {
            int pZ;
            int pY;
            int pX;
            List possibleTargets = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - 1.0, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + 3.0, this.field_70161_v + (double)radius));
            for (Entity e : possibleTargets) {
                if (e == this.dummycaster) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                double lastVelX = e.field_70159_w;
                double lastVelY = e.field_70181_x;
                double lastVelZ = e.field_70179_y;
                float damage = 0.75f * ((Float)this.field_70180_af.func_187225_a(WATCHER_DAMAGEBONUS)).floatValue();
                if (SpellUtils.attackTargetSpecial(null, e, (DamageSource)DamageSources.causeFireDamage((EntityLivingBase)this.dummycaster), damage) && !(e instanceof EntityPlayer)) {
                    e.field_70172_ad = 10;
                }
                e.func_70024_g(-(e.field_70159_w - lastVelX), -(e.field_70181_x - lastVelY), -(e.field_70179_y - lastVelZ));
            }
            if (this.canRoFIgnite() && this.field_70146_Z.nextInt(10) < 2 && this.field_70170_p.func_175623_d(new BlockPos(pX = (int)(this.field_70165_t - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)), pY = (int)this.field_70163_u, pZ = (int)(this.field_70161_v - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2))))) {
                this.field_70170_p.func_175656_a(new BlockPos(pX, pY, pZ), Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private void blizzardUpdate() {
        float radius = ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
        if (this.field_70170_p.field_72995_K) {
            if (this.spellStack == null) {
                this.spellStack = this.getEffectStack();
                if (this.spellStack == null) {
                    return;
                }
            }
            this.spellStack = this.spellStack.func_77946_l();
            int color = 0xFFFFFF;
            if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, this.spellStack)) {
                ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(this.spellStack, -1);
                for (SpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, this.spellStack.func_77978_p());
                }
            }
            for (int i = 0; i < 20; ++i) {
                double z;
                double y;
                double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "snowflakes", x, y = this.field_70163_u + 10.0, z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0));
                if (particle == null) continue;
                particle.func_187114_a(20);
                particle.setParticleScale(0.1f);
                particle.addVelocity(this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f, 0.0, this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f);
                particle.setAffectedByGravity();
                particle.setRGBColorI(color);
                particle.setDontRequireControllers();
            }
            double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
            double z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
            double y = this.field_70163_u + this.field_70146_Z.nextDouble();
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "smoke", x, y, z));
            if (particle != null) {
                particle.setParticleScale(2.0f);
                particle.func_187114_a(20);
                particle.setRGBColorF(0.5098f, 0.7843f, 0.7843f);
                particle.SetParticleAlpha(0.6f);
                particle.AddParticleController(new ParticleFleePoint(particle, new Vec3d(x, y, z), 0.1f, 3.0, 1, false));
            }
        } else {
            int pZ;
            int pY;
            int pX;
            BlockPos pos;
            List possibleTargets = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - 1.0, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + 3.0, this.field_70161_v + (double)radius));
            for (Entity e : possibleTargets) {
                if (e == this.dummycaster) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if (e instanceof EntityLivingBase) {
                    ((EntityLivingBase)e).func_70690_d((PotionEffect)new BuffEffectFrostSlowed(80, 3));
                }
                float damage = 1.0f * ((Float)this.field_70180_af.func_187225_a(WATCHER_DAMAGEBONUS)).floatValue();
                double lastVelX = e.field_70159_w;
                double lastVelY = e.field_70181_x;
                double lastVelZ = e.field_70179_y;
                if (SpellUtils.attackTargetSpecial(null, e, (DamageSource)DamageSources.causeFrostDamage((EntityLivingBase)this.dummycaster), damage) && !(e instanceof EntityPlayer)) {
                    e.field_70172_ad = 15;
                }
                e.func_70024_g(-(e.field_70159_w - lastVelX), -(e.field_70181_x - lastVelY), -(e.field_70179_y - lastVelZ));
            }
            if (this.field_70146_Z.nextInt(10) < 2 && this.field_70170_p.func_175623_d(pos = new BlockPos(pX = (int)(this.field_70165_t - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)), pY = (int)this.field_70163_u + this.field_70146_Z.nextInt(2), pZ = (int)(this.field_70161_v - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)))) && !this.field_70170_p.func_175623_d(pos.func_177977_b()) && this.field_70170_p.func_180495_p(pos).func_185914_p()) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
            }
        }
    }

    private void wallUpdate() {
        block17: {
            block16: {
                if (!this.field_70170_p.field_72995_K) break block16;
                if (this.spellStack == null) {
                    this.spellStack = this.getEffectStack();
                    if (this.spellStack == null) {
                        return;
                    }
                }
                this.spellStack = this.spellStack.func_77946_l();
                double dist = this.getRadius();
                int color = 0xFFFFFF;
                if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, this.spellStack)) {
                    ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(this.spellStack, -1);
                    for (SpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, this.spellStack.func_77978_p());
                    }
                }
                double px = Math.cos(0.01745 * (double)(this.field_70177_z + 90.0f)) * (double)0.1f;
                double pz = Math.sin(0.01745 * (double)(this.field_70177_z + 90.0f)) * (double)0.1f;
                double py = 0.1f;
                float i = 0.0f;
                while ((double)i < dist) {
                    double x = this.field_70165_t - Math.cos(0.01745 * (double)this.field_70177_z) * (double)i;
                    double z = this.field_70161_v - Math.sin(0.01745 * (double)this.field_70177_z) * (double)i;
                    AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, AMParticleDefs.getParticleForAffinity(AffinityShiftUtils.getMainShiftForStack(this.spellStack)), x, this.field_70163_u, z));
                    if (effect != null) {
                        effect.setIgnoreMaxAge(false);
                        effect.func_187114_a(20);
                        effect.addRandomOffset(1.0, 1.0, 1.0);
                        effect.setParticleScale(0.15f);
                        effect.setRGBColorI(color);
                        if ((Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE) == 3) {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                        } else {
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                            effect.addVelocity(px, py, pz);
                        }
                    }
                    x = this.field_70165_t - Math.cos(Math.toRadians(this.field_70177_z)) * (double)(-i);
                    z = this.field_70161_v - Math.sin(Math.toRadians(this.field_70177_z)) * (double)(-i);
                    effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, AMParticleDefs.getParticleForAffinity(AffinityShiftUtils.getMainShiftForStack(this.spellStack)), x, this.field_70163_u, z));
                    if (effect != null) {
                        effect.setIgnoreMaxAge(false);
                        effect.addRandomOffset(1.0, 1.0, 1.0);
                        effect.func_187114_a(20);
                        effect.setParticleScale(0.15f);
                        effect.setRGBColorI(color);
                        if ((Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE) == 3) {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                        } else {
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                            effect.addVelocity(px, py, pz);
                        }
                    }
                    i += 0.5f;
                }
                break block17;
            }
            --this.ticksToEffect;
            if (this.spellStack == null) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
                return;
            }
            if (this.dummycaster == null) {
                this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
            }
            if (this.ticksToEffect > 0) break block17;
            this.ticksToEffect = this.maxTicksToEffect_wall;
            float radius = ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
            List possibleTargets = this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - 1.0, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + 3.0, this.field_70161_v + (double)radius));
            for (Entity e : possibleTargets) {
                if (e == this || e == this.dummycaster || e.func_145782_y() == this.casterEntityID) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                Vec3d target = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                double dirX = Math.cos(0.01745 * (double)this.field_70177_z);
                double dirZ = Math.sin(0.01745 * (double)this.field_70177_z);
                Vec3d a = new Vec3d(this.field_70165_t - dirX * (double)radius, this.field_70163_u, this.field_70161_v - dirZ * (double)radius);
                Vec3d b = new Vec3d(this.field_70165_t - dirX * (double)(-radius), this.field_70163_u, this.field_70161_v - dirZ * (double)(-radius));
                Vec3d closest = new AMLineSegment(a, b).closestPointOnLine(target);
                closest = new Vec3d(closest.field_72450_a, 0.0, closest.field_72449_c);
                target = new Vec3d(target.field_72450_a, 0.0, target.field_72449_c);
                double hDistance = closest.func_72438_d(target);
                double vDistance = Math.abs(this.field_70163_u - e.field_70163_u);
                if (!(e instanceof EntityLivingBase) || !(hDistance < 0.75) || !(vDistance < 2.0)) continue;
                SpellUtils.applyStackStage(this.spellStack.func_77946_l(), (EntityLivingBase)this.dummycaster, (EntityLivingBase)e, this.field_70165_t, this.field_70163_u, this.field_70161_v, null, this.field_70170_p, false, false, 0);
            }
        }
    }

    private void waveUpdate() {
        this.ticksToEffect = 0;
        this.wallUpdate();
        double dx = Math.cos(Math.toRadians(this.field_70177_z + 90.0f));
        double dz = Math.sin(Math.toRadians(this.field_70177_z + 90.0f));
        this.func_70091_d(dx * (double)this.moveSpeed, 0.0, dz * (double)this.moveSpeed);
        double dxH = Math.cos(Math.toRadians(this.field_70177_z));
        double dzH = Math.sin(Math.toRadians(this.field_70177_z));
        float radius = ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
        for (int j = -1; j <= 1; ++j) {
            Vec3d[] vecs;
            Vec3d a = new Vec3d(this.field_70165_t + dx - dxH * (double)radius, this.field_70163_u + (double)j, this.field_70161_v + dz - dzH * (double)radius);
            Vec3d b = new Vec3d(this.field_70165_t + dx - dxH * (double)(-radius), this.field_70163_u + (double)j, this.field_70161_v + dz - dzH * (double)(-radius));
            if (this.dummycaster == null) {
                this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
            }
            for (Vec3d vec : vecs = this.getAllBlockLocationsBetween(a, b)) {
                SpellUtils.applyStageToGround(SpellUtils.popStackStage(this.spellStack.func_77946_l()), (EntityLivingBase)this.dummycaster, this.field_70170_p, new BlockPos(vec), EnumFacing.UP, vec.field_72450_a + 0.5, vec.field_72448_b + 0.5, vec.field_72449_c + 0.5, false);
            }
        }
    }

    private Vec3d[] getAllBlockLocationsBetween(Vec3d a, Vec3d b) {
        a = MathUtilities.floorToI(a);
        b = MathUtilities.floorToI(b);
        double stepX = a.field_72450_a < b.field_72450_a ? (double)0.2f : (double)-0.2f;
        double stepZ = a.field_72449_c < b.field_72449_c ? (double)0.2f : (double)-0.2f;
        ArrayList<Vec3d> vecList = new ArrayList<Vec3d>();
        Vec3d curPos = new Vec3d(a.field_72450_a, a.field_72448_b, a.field_72449_c);
        int i = 0;
        while ((float)i < this.field_70131_O) {
            vecList.add(new Vec3d(curPos.field_72450_a, curPos.field_72448_b + (double)i, curPos.field_72449_c));
            ++i;
        }
        while (stepX != 0.0 || stepZ != 0.0) {
            if (stepX < 0.0 && curPos.field_72450_a <= b.field_72450_a || stepX > 0.0 && curPos.field_72450_a >= b.field_72450_a) {
                stepX = 0.0;
            }
            if (stepZ < 0.0 && curPos.field_72449_c <= b.field_72449_c || stepZ > 0.0 && curPos.field_72449_c >= b.field_72449_c) {
                stepZ = 0.0;
            }
            curPos = new Vec3d(curPos.field_72450_a + stepX, curPos.field_72448_b, curPos.field_72449_c + stepZ);
            Vec3d tempPos = curPos.func_178787_e(Vec3d.field_186680_a);
            if (vecList.contains(tempPos = MathUtilities.roundToI(tempPos))) continue;
            int i2 = 0;
            while ((float)i2 < this.field_70131_O) {
                vecList.add(new Vec3d(tempPos.field_72450_a, tempPos.field_72448_b + (double)i2, tempPos.field_72449_c));
                ++i2;
            }
        }
        return vecList.toArray(new Vec3d[vecList.size()]);
    }

    public void func_70030_z() {
    }

    protected void func_70037_a(NBTTagCompound var1) {
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }

    public void setRainOfFire(boolean ignite) {
        this.field_70180_af.func_187227_b(WATCHER_TYPE, (Object)1);
        if (ignite) {
            this.field_70180_af.func_187227_b(WATCHER_ROF_IGNITE, (Object)true);
        }
    }

    public void setBlizzard() {
        this.field_70180_af.func_187227_b(WATCHER_TYPE, (Object)2);
    }

    public boolean isBlizzard() {
        return (Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE) == 2;
    }

    public boolean isRainOfFire() {
        return (Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE) == 1;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public double getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(WATCHER_RADIUS)).floatValue();
    }

    public ItemStack getEffectStack() {
        return (ItemStack)((Optional)this.field_70180_af.func_187225_a(WATCHER_STACK)).orNull();
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(WATCHER_TYPE);
    }

    public double getGravity() {
        return ((Float)this.field_70180_af.func_187225_a(WATCHER_GRAVITY)).floatValue();
    }

    public float getBonusDamage() {
        return ((Float)this.field_70180_af.func_187225_a(WATCHER_DAMAGEBONUS)).floatValue();
    }

    public boolean canRoFIgnite() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_ROF_IGNITE);
    }
}

