/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.utils.AffinityShiftUtils;
import am2.utils.NBTUtils;
import am2.utils.SpellUtils;
import com.google.common.base.Optional;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySpellProjectile
extends Entity {
    private static final DataParameter<Integer> DW_BOUNCE_COUNTER = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DW_GRAVITY = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<ItemStack>> DW_EFFECT = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<String> DW_ICON_NAME = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DW_PIERCE_COUNT = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_COLOR = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_SHOOTER = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DW_TARGETGRASS = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DW_HOMING = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DW_HOMING_TARGET = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static int currentPierces;

    public EntitySpellProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void setTargetWater() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(DW_TARGETGRASS, (Object)true);
        }
    }

    public boolean targetWater() {
        return (Boolean)this.func_184212_Q().func_187225_a(DW_TARGETGRASS);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DW_BOUNCE_COUNTER, (Object)0);
        this.func_184212_Q().func_187214_a(DW_GRAVITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DW_EFFECT, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(DW_ICON_NAME, (Object)"arcane");
        this.func_184212_Q().func_187214_a(DW_PIERCE_COUNT, (Object)0);
        this.func_184212_Q().func_187214_a(DW_COLOR, (Object)0xFFFFFF);
        this.func_184212_Q().func_187214_a(DW_SHOOTER, (Object)0);
        this.func_184212_Q().func_187214_a(DW_TARGETGRASS, (Object)false);
        this.func_184212_Q().func_187214_a(DW_HOMING, (Object)false);
        this.func_184212_Q().func_187214_a(DW_HOMING_TARGET, (Object)-1);
    }

    public void setShooter(EntityLivingBase living) {
        this.func_184212_Q().func_187227_b(DW_SHOOTER, (Object)living.func_145782_y());
    }

    public void decreaseBounces() {
        this.setBounces(this.getBounces() - 1);
    }

    public int getBounces() {
        return (Integer)this.func_184212_Q().func_187225_a(DW_BOUNCE_COUNTER);
    }

    public int getPierces() {
        return (Integer)this.func_184212_Q().func_187225_a(DW_PIERCE_COUNT) - currentPierces;
    }

    public ItemStack getSpell() {
        return (ItemStack)((Optional)this.func_184212_Q().func_187225_a(DW_EFFECT)).orNull();
    }

    public void bounce(EnumFacing facing) {
        if (facing == null) {
            this.field_70159_w = -this.field_70159_w;
            this.field_70181_x = -this.field_70181_x;
            this.field_70179_y = -this.field_70179_y;
        } else {
            double projectileSpeed = SpellUtils.getModifiedDouble_Mul(1.0, this.getSpell(), this.getShooter(), null, this.field_70170_p, SpellModifiers.VELOCITY_ADDED);
            double newMotionX = this.field_70159_w / projectileSpeed;
            double newMotionY = this.field_70181_x / projectileSpeed;
            double newMotionZ = this.field_70179_y / projectileSpeed;
            if (facing.equals((Object)EnumFacing.UP) || facing.equals((Object)EnumFacing.DOWN)) {
                newMotionY = -newMotionY;
            } else if (facing.equals((Object)EnumFacing.NORTH) || facing.equals((Object)EnumFacing.SOUTH)) {
                newMotionZ = -newMotionZ;
            } else if (facing.equals((Object)EnumFacing.EAST) || facing.equals((Object)EnumFacing.WEST)) {
                newMotionX = -newMotionX;
            }
            this.field_70159_w = newMotionX * projectileSpeed;
            this.field_70181_x = newMotionY * projectileSpeed;
            this.field_70179_y = newMotionZ * projectileSpeed;
        }
        this.decreaseBounces();
    }

    public void func_70071_h_() {
        try {
            RayTraceResult mop;
            if (this.field_70173_aa > 200) {
                this.func_70106_y();
            }
            if ((mop = this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y))) != null && mop.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK)) {
                if (this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c().func_176212_b((IBlockAccess)this.field_70170_p, mop.func_178782_a(), mop.field_178784_b) || this.targetWater()) {
                    this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c().func_180634_a(this.field_70170_p, mop.func_178782_a(), this.field_70170_p.func_180495_p(mop.func_178782_a()), (Entity)this);
                    if (this.getBounces() > 0) {
                        this.bounce(mop.field_178784_b);
                    } else {
                        SpellUtils.applyStageToGround(this.getSpell(), this.getShooter(), this.field_70170_p, mop.func_178782_a(), mop.field_178784_b, this.field_70165_t, this.field_70163_u, this.field_70161_v, true);
                        SpellUtils.applyStackStage(this.getSpell(), this.getShooter(), null, mop.field_72307_f.field_72450_a + this.field_70159_w, mop.field_72307_f.field_72448_b + this.field_70181_x, mop.field_72307_f.field_72449_c + this.field_70179_y, mop.field_178784_b, this.field_70170_p, false, true, 0);
                        if (this.getPierces() == 1 || !SpellUtils.modifierIsPresent(SpellModifiers.PIERCING, this.getSpell())) {
                            this.func_70106_y();
                        } else {
                            ++currentPierces;
                        }
                    }
                }
            } else {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(0.25, 0.25, 0.25));
                int effSize = list.size();
                for (Entity entity : list) {
                    if (entity instanceof EntityLivingBase) {
                        if (entity.equals((Object)this.getShooter())) {
                            --effSize;
                            continue;
                        }
                        if (entity instanceof EntityDragonPart && ((EntityDragonPart)entity).field_70259_a instanceof EntityLivingBase) {
                            entity = (EntityLivingBase)((EntityDragonPart)entity).field_70259_a;
                        }
                        SpellUtils.applyStageToEntity(this.getSpell(), this.getShooter(), this.field_70170_p, entity, true);
                        SpellUtils.applyStackStage(this.getSpell(), this.getShooter(), (EntityLivingBase)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, null, this.field_70170_p, false, true, 0);
                        break;
                    }
                    --effSize;
                }
                if (effSize != 0) {
                    if (this.getPierces() == 1 || !SpellUtils.modifierIsPresent(SpellModifiers.PIERCING, this.getSpell())) {
                        this.func_70106_y();
                    } else {
                        ++currentPierces;
                    }
                }
            }
            this.field_70181_x += (double)((Float)this.func_184212_Q().func_187225_a(DW_GRAVITY)).floatValue();
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        }
        catch (NullPointerException e) {
            this.func_70106_y();
        }
    }

    public EntityLivingBase getShooter() {
        try {
            return (EntityLivingBase)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_SHOOTER)).intValue());
        }
        catch (RuntimeException e) {
            this.func_70106_y();
            return null;
        }
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        NBTTagCompound am2Tag = NBTUtils.getAM2Tag(tagCompund);
        this.field_70180_af.func_187227_b(DW_BOUNCE_COUNTER, (Object)am2Tag.func_74762_e("BounceCount"));
        this.field_70180_af.func_187227_b(DW_GRAVITY, (Object)Float.valueOf(am2Tag.func_74760_g("Gravity")));
        this.field_70180_af.func_187227_b(DW_EFFECT, (Object)Optional.of((Object)ItemStack.func_77949_a((NBTTagCompound)am2Tag.func_74775_l("Effect"))));
        this.field_70180_af.func_187227_b(DW_ICON_NAME, (Object)am2Tag.func_74779_i("IconName"));
        this.field_70180_af.func_187227_b(DW_PIERCE_COUNT, (Object)am2Tag.func_74762_e("PierceCount"));
        this.field_70180_af.func_187227_b(DW_COLOR, (Object)am2Tag.func_74762_e("Color"));
        this.field_70180_af.func_187227_b(DW_SHOOTER, (Object)am2Tag.func_74762_e("Shooter"));
        this.field_70180_af.func_187227_b(DW_TARGETGRASS, (Object)am2Tag.func_74767_n("TargetGrass"));
        this.field_70180_af.func_187227_b(DW_HOMING, (Object)am2Tag.func_74767_n("Homing"));
        this.field_70180_af.func_187227_b(DW_HOMING_TARGET, (Object)am2Tag.func_74762_e("HomingTarget"));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        NBTTagCompound am2Tag = NBTUtils.getAM2Tag(tagCompound);
        am2Tag.func_74768_a("BounceCount", ((Integer)this.field_70180_af.func_187225_a(DW_BOUNCE_COUNTER)).intValue());
        am2Tag.func_74776_a("Gravity", ((Float)this.field_70180_af.func_187225_a(DW_GRAVITY)).floatValue());
        NBTTagCompound tmp = new NBTTagCompound();
        ((ItemStack)((Optional)this.field_70180_af.func_187225_a(DW_EFFECT)).or((Object)new ItemStack((Item)ItemDefs.spell))).func_77955_b(tmp);
        am2Tag.func_74782_a("Effect", (NBTBase)tmp);
        am2Tag.func_74778_a("IconName", (String)this.field_70180_af.func_187225_a(DW_ICON_NAME));
        am2Tag.func_74768_a("PierceCount", ((Integer)this.field_70180_af.func_187225_a(DW_PIERCE_COUNT)).intValue());
        am2Tag.func_74768_a("Color", ((Integer)this.field_70180_af.func_187225_a(DW_COLOR)).intValue());
        am2Tag.func_74768_a("Shooter", ((Integer)this.field_70180_af.func_187225_a(DW_SHOOTER)).intValue());
        am2Tag.func_74757_a("TargetGrass", ((Boolean)this.field_70180_af.func_187225_a(DW_TARGETGRASS)).booleanValue());
        am2Tag.func_74757_a("Homing", ((Boolean)this.field_70180_af.func_187225_a(DW_HOMING)).booleanValue());
        am2Tag.func_74768_a("HomingTarget", ((Integer)this.field_70180_af.func_187225_a(DW_HOMING_TARGET)).intValue());
    }

    public void selectHomingTarget() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_70046_E().func_72314_b(10.0, 10.0, 10.0));
        Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        EntityLivingBase target = null;
        double dist = 900.0;
        for (Entity entity : entities) {
            Vec3d ePos;
            double eDist;
            if (!(entity instanceof EntityLivingBase) || entity.equals((Object)this.getShooter()) || !((eDist = pos.func_72438_d(ePos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) < dist)) continue;
            dist = eDist;
            target = (EntityLivingBase)entity;
        }
        if (target != null) {
            this.func_184212_Q().func_187227_b(DW_HOMING_TARGET, (Object)target.func_145782_y());
        }
    }

    public EntityLivingBase getHomingTarget() {
        return (EntityLivingBase)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_HOMING_TARGET)).intValue());
    }

    public void setGravity(float projectileGravity) {
        this.func_184212_Q().func_187227_b(DW_GRAVITY, (Object)Float.valueOf(projectileGravity));
    }

    public void setSpell(ItemStack stack) {
        this.func_184212_Q().func_187227_b(DW_EFFECT, (Object)Optional.fromNullable((Object)stack));
        Affinity mainAff = AffinityShiftUtils.getMainShiftForStack(stack);
        if (mainAff.equals(Affinity.ENDER)) {
            this.func_184212_Q().func_187227_b(DW_COLOR, (Object)0x550055);
        } else if (mainAff.equals(Affinity.ICE)) {
            this.func_184212_Q().func_187227_b(DW_COLOR, (Object)0x2299FF);
        } else if (mainAff.equals(Affinity.LIFE)) {
            this.func_184212_Q().func_187227_b(DW_COLOR, (Object)0x22FF44);
        }
    }

    public void setBounces(int projectileBounce) {
        this.func_184212_Q().func_187227_b(DW_BOUNCE_COUNTER, (Object)projectileBounce);
    }

    public void setNumPierces(int pierces) {
        this.func_184212_Q().func_187227_b(DW_PIERCE_COUNT, (Object)pierces);
        currentPierces = 0;
    }

    public void setHoming(boolean homing) {
        this.func_184212_Q().func_187227_b(DW_HOMING, (Object)homing);
    }

    public void setIcon(String icon) {
        this.func_184212_Q().func_187227_b(DW_ICON_NAME, (Object)icon);
    }

    public String getIcon() {
        return (String)this.func_184212_Q().func_187225_a(DW_ICON_NAME);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(DW_COLOR);
    }
}

