/*
 * Decompiled with CFR 0.152.
 */
package am2.entity.ai;

import am2.extensions.EntityExtension;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.pathfinding.Path;

public class EntityAITargetNearbyInanimate
extends EntityAITarget {
    private float targetDistance;
    private Entity target;
    private int timeSinceLastSight;
    private Class<? extends Entity>[] targetTypes;

    @SafeVarargs
    public EntityAITargetNearbyInanimate(EntityCreature taskOwner, float targetDistance, boolean needsLineofSight, Class<? extends Entity> ... classes) {
        super(taskOwner, needsLineofSight);
        this.targetTypes = classes;
        this.targetDistance = targetDistance;
    }

    public boolean func_75250_a() {
        return this.field_75299_d.func_70638_az() == null && EntityExtension.For((EntityLivingBase)this.field_75299_d).getInanimateTarget() == null;
    }

    public boolean func_75253_b() {
        Entity inanimateTarget = EntityExtension.For((EntityLivingBase)this.field_75299_d).getInanimateTarget();
        if (this.field_75299_d.func_70638_az() != null || inanimateTarget == null || inanimateTarget.field_70128_L) {
            return false;
        }
        if (this.field_75299_d.func_70068_e(inanimateTarget) > (double)(this.targetDistance * this.targetDistance)) {
            return false;
        }
        if (this.field_75297_f) {
            if (this.field_75299_d.func_70635_at().func_75522_a(inanimateTarget)) {
                this.timeSinceLastSight = 0;
            } else if (++this.timeSinceLastSight > 60) {
                return false;
            }
        }
        return true;
    }

    public void func_75251_c() {
        EntityExtension.For((EntityLivingBase)this.field_75299_d).setInanimateTarget(null);
        this.target = null;
    }

    protected boolean isSuitableTarget(Entity target) {
        if (target.field_70128_L) {
            return false;
        }
        for (Class<? extends Entity> c : this.targetTypes) {
            if (target.getClass() != c) continue;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        double dist = 10000.0;
        for (Class<? extends Entity> c : this.targetTypes) {
            List potentialTargets = this.field_75299_d.field_70170_p.func_72872_a(c, this.field_75299_d.func_174813_aQ().func_72314_b((double)this.targetDistance, 1.0, (double)this.targetDistance));
            for (Entity e : potentialTargets) {
                double eDist;
                Path pe;
                if (!this.isSuitableTarget(e) || (pe = this.field_75299_d.func_70661_as().func_75488_a(e.field_70165_t, e.field_70163_u, e.field_70161_v)) == null || !((eDist = this.field_75299_d.func_70068_e(e)) < dist)) continue;
                this.target = e;
                dist = eDist;
            }
        }
        if (this.target != null) {
            EntityExtension.For((EntityLivingBase)this.field_75299_d).setInanimateTarget(this.target);
        }
        super.func_75249_e();
    }
}

