/*
 * Decompiled with CFR 0.152.
 */
package am2.extensions.datamanager;

import am2.api.extensions.IDataSyncExtension;
import am2.extensions.datamanager.ArsMagicaManager;
import am2.extensions.datamanager.SavedObject;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class DataSyncExtension
implements IDataSyncExtension {
    public static final ResourceLocation ID = new ResourceLocation("arsmagica2:DataSync");
    @CapabilityInject(value=IDataSyncExtension.class)
    public static Capability<IDataSyncExtension> INSTANCE = null;
    private ArrayList<Object> internalData = new ArrayList();
    private ArrayList<Boolean> hasChanged = new ArrayList();
    private Entity entity;

    public static DataSyncExtension For(EntityLivingBase living) {
        return (DataSyncExtension)living.getCapability(INSTANCE, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == INSTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void init(Entity entity) {
        this.entity = entity;
    }

    @Override
    public <T> T get(SavedObject<T> data) {
        this.fillWithNull(data.getId());
        return (T)this.internalData.get(data.getId());
    }

    public void scheduleFullUpdate() {
        for (int i = 0; i < this.hasChanged.size(); ++i) {
            this.hasChanged.set(i, true);
        }
    }

    @Override
    public <T> void set(SavedObject<T> data, T object) {
        this.fillWithNull(data.getId());
        Object checkObj = this.internalData.get(data.getId());
        boolean isDifferent = object != null && !object.equals(checkObj);
        this.hasChanged.set(data.getId(), isDifferent);
        this.internalData.set(data.getId(), object);
    }

    @Override
    public <T> void setWithSync(SavedObject<T> data, T defaultValue) {
        this.fillWithNull(data.getId());
        this.hasChanged.set(data.getId(), true);
        this.internalData.set(data.getId(), defaultValue);
    }

    private void fillWithNull(int upTo) {
        while (this.internalData.size() <= upTo) {
            this.internalData.add(null);
        }
        while (this.hasChanged.size() <= upTo) {
            this.hasChanged.add(false);
        }
    }

    @Override
    public byte[] createUpdatePacket() {
        int i;
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.entity.func_145782_y());
        int size = 0;
        for (i = 0; i < this.internalData.size(); ++i) {
            if (this.internalData.get(i) == null || ArsMagicaManager.getById(i) == null || !this.hasChanged.get(i).booleanValue()) continue;
            ++size;
        }
        writer.add(size);
        for (i = 0; i < this.internalData.size(); ++i) {
            if (this.internalData.get(i) == null || ArsMagicaManager.getById(i) == null || !this.hasChanged.get(i).booleanValue()) continue;
            writer.add(i);
            try {
                ArsMagicaManager.getById(i).serialize(writer, this.internalData.get(i));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.hasChanged.clear();
        this.fillWithNull(this.internalData.size());
        return writer.generate();
    }

    @Override
    public void handleUpdatePacket(AMDataReader reader) {
        int size = reader.getInt();
        for (int i = 0; i < size; ++i) {
            int index = reader.getInt();
            try {
                this.fillWithNull(index);
                this.internalData.set(index, ArsMagicaManager.getById(index).deserialize(reader));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean shouldSync() {
        boolean bool = false;
        for (Boolean b : this.hasChanged) {
            if (bool |= b.booleanValue()) break;
        }
        return bool;
    }
}

