/*
 * Decompiled with CFR 0.152.
 */
package am2.gui;

import am2.api.compendium.CompendiumCategory;
import am2.api.compendium.CompendiumEntry;
import am2.api.extensions.ISkillData;
import am2.extensions.SkillData;
import am2.gui.AMGuiHelper;
import am2.gui.GuiArcaneCompendium;
import am2.gui.controls.GuiButtonCompendiumLink;
import am2.gui.controls.GuiButtonCompendiumNext;
import am2.gui.controls.GuiButtonCompendiumTab;
import am2.gui.controls.GuiSpellImageButton;
import am2.lore.ArcaneCompendium;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiCompendiumIndex
extends GuiScreen {
    private CompendiumCategory currentCategory;
    private final ImmutableList<CompendiumCategory> categories = CompendiumCategory.getCategories();
    int xSize = 360;
    int ySize = 256;
    int page = 0;
    int numPages = 0;
    ArrayList<String> lines;
    int lineWidth = 140;
    int maxLines = 22;
    GuiButtonCompendiumNext nextPage;
    GuiButtonCompendiumNext prevPage;
    GuiSpellImageButton updateButton;
    ISkillData sk;
    private static final ResourceLocation background = new ResourceLocation("arsmagica2", "textures/gui/ArcaneCompendiumIndexGui.png");

    public GuiCompendiumIndex() {
        CompendiumCategory category;
        this.currentCategory = (CompendiumCategory)this.categories.iterator().next();
        this.lines = new ArrayList();
        String path = ArcaneCompendium.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getPath();
        if (path != null && (category = CompendiumCategory.getCategoryFromID(path)) != null) {
            this.currentCategory = category;
        }
        this.sk = SkillData.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
    }

    public void func_73866_w_() {
        int idCount = 0;
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2;
        int tabY = posY + 40;
        int tabWidth = 1;
        this.nextPage = new GuiButtonCompendiumNext(idCount++, posX + 320, posY + 13, true);
        this.prevPage = new GuiButtonCompendiumNext(idCount++, posX + 33, posY + 13, false);
        for (CompendiumCategory category : this.categories) {
            int locPage = 0;
            if (!category.hasParents()) {
                GuiButtonCompendiumTab tab = new GuiButtonCompendiumTab(idCount++, posX + 10, tabY, category);
                if (category == this.currentCategory) {
                    tab.setActive(true);
                }
                this.field_146292_n.add(tab);
                if (tabWidth < tab.getWidth()) {
                    tabWidth = tab.getWidth();
                }
                tabY += 18;
            }
            int buttonY = posY + 35;
            int buttonX = posX + 40;
            ArrayList sortedCategories = Lists.newArrayList(this.categories);
            sortedCategories.sort(new Comparator<CompendiumCategory>(){

                @Override
                public int compare(CompendiumCategory o1, CompendiumCategory o2) {
                    return o1.getCategoryName().compareTo(o2.getCategoryName());
                }
            });
            for (CompendiumCategory sub : sortedCategories) {
                if (!sub.getParentsString().equals(category.getID())) continue;
                boolean hasSubItems = false;
                for (CompendiumEntry entry : category.getEntries()) {
                    if (entry.getRenderObject() != null && !ArcaneCompendium.For((EntityPlayer)this.field_146297_k.field_71439_g).isUnlocked(entry.getID())) continue;
                    hasSubItems = true;
                    break;
                }
                if (!hasSubItems) continue;
                GuiButtonCompendiumLink tab = new GuiButtonCompendiumLink(idCount++, buttonX, buttonY, this.field_146289_q, locPage, null, sub);
                boolean bl = tab.field_146125_m = sub.getParentsString().equals(this.currentCategory.getID()) && this.page == locPage;
                if ((buttonY += 12) > posY + this.ySize - 25) {
                    if (buttonX > posX + 40) {
                        buttonX = posX + 40;
                        ++locPage;
                    } else {
                        buttonX += 155;
                    }
                    buttonY = posY + 30;
                }
                this.field_146292_n.add(tab);
            }
            ArrayList sortedEntries = Lists.newArrayList(category.getEntries());
            sortedEntries.sort(new Comparator<CompendiumEntry>(){

                @Override
                public int compare(CompendiumEntry o1, CompendiumEntry o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CompendiumEntry entry : sortedEntries) {
                if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && entry.getRenderObject() != null && !ArcaneCompendium.For((EntityPlayer)this.field_146297_k.field_71439_g).isUnlocked(entry.getID())) continue;
                GuiButtonCompendiumLink link = new GuiButtonCompendiumLink(idCount++, buttonX, buttonY, this.field_146289_q, locPage, entry, null);
                boolean bl = link.field_146125_m = entry.canBeDisplayed(category.getID()) && this.page == locPage;
                if ((buttonY += 12) > posY + this.ySize - 25) {
                    if (buttonX > posX + 40) {
                        buttonX = posX + 40;
                        ++locPage;
                    } else {
                        buttonX += 155;
                    }
                    buttonY = posY + 30;
                }
                this.field_146292_n.add(link);
            }
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonCompendiumTab)) continue;
            ((GuiButtonCompendiumTab)button).setDimensions(tabWidth, 16);
        }
        this.nextPage.field_146125_m = this.numPages > 0;
        this.prevPage.field_146125_m = false;
        this.switchCategory(this.currentCategory);
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.prevPage);
        super.func_73866_w_();
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (int l = 0; l < this.field_146292_n.size(); ++l) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
            if (!guibutton.func_146116_c(Minecraft.func_71410_x(), par1, par2) || par3 != 0) continue;
            this.func_146284_a(guibutton);
            return;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.nextPage) {
            ++this.page;
            if (this.page > this.numPages) {
                this.page = this.numPages;
            }
            this.switchCategory(this.currentCategory);
        } else if (button == this.prevPage) {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.switchCategory(this.currentCategory);
        } else if (button instanceof GuiButtonCompendiumTab) {
            this.switchCategory(((GuiButtonCompendiumTab)button).category);
        } else if (button instanceof GuiButtonCompendiumLink) {
            GuiButtonCompendiumLink target = (GuiButtonCompendiumLink)button;
            if (target.getEntry() != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiArcaneCompendium(target.getEntry()));
            } else if (target.getCategory() != null) {
                this.switchCategory(target.getCategory());
            }
        }
        super.func_146284_a(button);
    }

    private void switchCategory(CompendiumCategory category) {
        if (category != this.currentCategory) {
            this.page = 0;
            this.nextPage.field_146125_m = this.numPages > 0;
            this.prevPage.field_146125_m = false;
        }
        int numButton = 0;
        for (GuiButton button : this.field_146292_n) {
            if (button instanceof GuiButtonCompendiumLink) {
                GuiButtonCompendiumLink link = (GuiButtonCompendiumLink)button;
                if (link.getEntry() != null) {
                    link.field_146125_m = link.getEntry().canBeDisplayed(category.getID());
                } else if (link.getCategory() != null) {
                    link.field_146125_m = link.getCategory().getParentsString().equals(category.getID());
                }
                if (link.field_146125_m) {
                    ++numButton;
                }
                link.field_146125_m = link.field_146125_m & this.page == link.getPage();
                continue;
            }
            if (!(button instanceof GuiButtonCompendiumTab)) continue;
            GuiButtonCompendiumTab tab = (GuiButtonCompendiumTab)button;
            tab.setActive(tab.category == category && this.page == this.numPages);
        }
        this.numPages = (int)Math.floor((double)numButton / 34.0);
        this.nextPage.field_146125_m = this.page < this.numPages;
        this.prevPage.field_146125_m = this.page > 0;
        this.currentCategory = category;
        ArcaneCompendium.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g).setPath(category.getID());
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1) {
            this.func_146281_b();
        }
        super.func_73869_a(par1, par2);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        RenderHelper.func_74520_c();
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(background);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect_Classic(l, i1, 0, 0, this.xSize, this.ySize, 256, 240);
        String compendiumTitle = "\u00a7nArcane Compendium";
        int y_start_title = i1 + 20;
        int x_start_title = l + 100 - this.field_146289_q.func_78256_a(compendiumTitle) / 2;
        if (this.page == 0) {
            this.field_146289_q.func_78276_b(compendiumTitle, x_start_title, y_start_title, 0);
        }
        int x_start_line = l + 35;
        int y_start_line = i1 + 35;
        if (this.lines != null && this.lines.size() > this.page) {
            AMGuiHelper.drawCompendiumText(this.lines.get(this.page), x_start_line, y_start_line, this.lineWidth, 0, this.field_146289_q);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public void drawTexturedModalRect_Classic(int dst_x, int dst_y, int src_x, int src_y, int dst_width, int dst_height, int src_width, int src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)(dst_x + 0), (double)(dst_y + dst_height), (double)this.field_73735_i).func_187315_a((double)((float)(src_x + 0) * var7), (double)((float)(src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.field_73735_i).func_187315_a((double)((float)(src_x + src_width) * var7), (double)((float)(src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(src_x + src_width) * var7), (double)((float)(src_y + 0) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + 0), (double)(dst_y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(src_x + 0) * var7), (double)((float)(src_y + 0) * var8)).func_181675_d();
        var9.func_78381_a();
    }
}

