/*
 * Decompiled with CFR 0.152.
 */
package am2.handler;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.DamageSources;
import am2.api.IBoundItem;
import am2.api.SkillPointRegistry;
import am2.api.affinity.Affinity;
import am2.api.event.PlayerMagicLevelChangeEvent;
import am2.api.extensions.IAffinityData;
import am2.api.skill.SkillPoint;
import am2.armor.ArmorHelper;
import am2.armor.infusions.GenericImbuement;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.entity.EntitySpellProjectile;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import am2.extensions.RiftStorage;
import am2.extensions.SkillData;
import am2.extensions.datamanager.DataSyncExtension;
import am2.items.SpellBase;
import am2.lore.ArcaneCompendium;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.spell.ContingencyType;
import am2.spell.SpellCastResult;
import am2.trackers.EntityItemWatcher;
import am2.utils.CloakUtils;
import am2.utils.EntityUtils;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EntityHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseEvent(MouseEvent event) {
        event.setCanceled(ArsMagica2.proxy.setMouseDWheel(event.getDwheel()));
    }

    @SubscribeEvent
    public void attachEntity(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            DataSyncExtension dataSync = new DataSyncExtension();
            dataSync.init(event.getEntity());
            event.addCapability(DataSyncExtension.ID, (ICapabilityProvider)dataSync);
            EntityExtension ext = new EntityExtension();
            ext.init((EntityLivingBase)event.getEntity(), dataSync);
            event.addCapability(EntityExtension.ID, (ICapabilityProvider)ext);
            if (event.getEntity() instanceof EntityPlayer) {
                ArcaneCompendium compendium = new ArcaneCompendium();
                AffinityData affData = new AffinityData();
                SkillData skillData = new SkillData();
                RiftStorage storage = new RiftStorage();
                affData.init((EntityPlayer)event.getEntity(), dataSync);
                skillData.init((EntityPlayer)event.getEntity(), dataSync);
                compendium.init((EntityPlayer)event.getEntity(), dataSync);
                event.addCapability(new ResourceLocation("arsmagica2", "Compendium"), (ICapabilityProvider)compendium);
                event.addCapability(SkillData.ID, (ICapabilityProvider)skillData);
                event.addCapability(AffinityData.ID, (ICapabilityProvider)affData);
                event.addCapability(new ResourceLocation("arsmagica2", "RiftStorage"), (ICapabilityProvider)storage);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructed(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)event.getEntity();
            living.func_110140_aT().func_111150_b(ArsMagicaAPI.burnoutReductionRate);
            living.func_110140_aT().func_111150_b(ArsMagicaAPI.manaRegenTimeModifier);
            living.func_110140_aT().func_111150_b(ArsMagicaAPI.maxBurnoutBonus);
            living.func_110140_aT().func_111150_b(ArsMagicaAPI.maxManaBonus);
            living.func_110140_aT().func_111150_b(ArsMagicaAPI.xpGainModifier);
        }
    }

    @SubscribeEvent
    public void onPlayerMagicLevelChange(PlayerMagicLevelChangeEvent event) {
        if (event.getEntityPlayer() != null) {
            for (SkillPoint point : SkillPointRegistry.getSkillPointMap().values()) {
                if (point.getMinEarnLevel() > event.getLevel() || (event.getLevel() - point.getMinEarnLevel()) % point.getLevelsForPoint() != 0) continue;
                SkillData.For((EntityLivingBase)event.getEntityPlayer()).setSkillPoint(point, SkillData.For((EntityLivingBase)event.getEntityPlayer()).getSkillPoint(point) + 1);
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            DataSyncExtension.For((EntityLivingBase)event.getEntity()).scheduleFullUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityItemFrame) {
            ArsMagica2.proxy.itemFrameWatcher.startWatchingFrame((EntityItemFrame)event.getTarget());
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        this.transferCapability(AffinityData.INSTANCE, AffinityData.For((EntityLivingBase)event.getOriginal()), AffinityData.For((EntityLivingBase)event.getEntityPlayer()));
        this.transferCapability(EntityExtension.INSTANCE, EntityExtension.For((EntityLivingBase)event.getOriginal()), EntityExtension.For((EntityLivingBase)event.getEntityPlayer()));
        this.transferCapability(SkillData.INSTANCE, SkillData.For((EntityLivingBase)event.getOriginal()), SkillData.For((EntityLivingBase)event.getEntityPlayer()));
        this.transferCapability(RiftStorage.INSTANCE, RiftStorage.For((EntityLivingBase)event.getOriginal()), RiftStorage.For((EntityLivingBase)event.getEntityPlayer()));
        this.transferCapability(ArcaneCompendium.INSTANCE, ArcaneCompendium.For(event.getOriginal()), ArcaneCompendium.For(event.getEntityPlayer()));
        DataSyncExtension.For((EntityLivingBase)event.getEntityPlayer()).scheduleFullUpdate();
    }

    private <T> void transferCapability(Capability<T> capability, T original, T target) {
        capability.getStorage().readNBT(capability, target, null, capability.getStorage().writeNBT(capability, original, null));
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && DataSyncExtension.For(event.getEntityLiving()).shouldSync()) {
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(event.getEntity().field_71093_bK, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 64.0, (byte)62, DataSyncExtension.For(event.getEntityLiving()).createUpdatePacket());
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            this.playerTick((EntityPlayer)event.getEntityLiving());
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            EntityExtension.For(event.getEntityLiving()).spawnManaLinkParticles();
        } else {
            EntityExtension.For(event.getEntityLiving()).manaBurnoutTick();
        }
        EntityExtension ext = EntityExtension.For(event.getEntityLiving());
        EntityLivingBase ent = event.getEntityLiving();
        if (event.getEntity().field_70173_aa % 20 == 0) {
            ArrayList<ItemStack> rs = ext.runningStacks;
            int foundID = -1;
            for (int i = 0; i < rs.size(); ++i) {
                SpellCastResult result;
                ItemStack is = rs.get(i);
                if (is == null || is.func_77978_p() == null || (result = SpellUtils.applyStackStage(is.func_77946_l(), ent, ent, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, null, ent.field_70170_p, true, true, 0)) == SpellCastResult.SUCCESS || result == SpellCastResult.SUCCESS_REDUCE_MANA) continue;
                foundID = i;
                break;
            }
            if (foundID != -1) {
                ItemStack is = ext.runningStacks.get(foundID);
                ext.runningStacks.remove(foundID);
                if (ent instanceof EntityPlayer) {
                    InventoryPlayer inv = ((EntityPlayer)ent).field_71071_by;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack is2 = inv.func_70301_a(i);
                        if (is2 == null || !(is2.func_77973_b() instanceof SpellBase) || is2.func_77978_p() == null || !is.func_77978_p().func_74779_i("ToggleShapeID").equals(is2.func_77978_p().func_74779_i("ToggleShapeID"))) continue;
                        is.func_77978_p().func_74757_a("HasEffect", true);
                    }
                }
            }
        }
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.spellReflect)) {
            int d0 = 3;
            AxisAlignedBB bb = new AxisAlignedBB(event.getEntityLiving().field_70165_t - 0.5, event.getEntityLiving().field_70163_u - 0.5, event.getEntityLiving().field_70161_v - 0.5, event.getEntityLiving().field_70165_t + 0.5, event.getEntityLiving().field_70163_u + 0.5, event.getEntityLiving().field_70161_v + 0.5).func_72314_b((double)d0, (double)d0, (double)d0);
            List entityList = event.getEntityLiving().func_130014_f_().func_72872_a(Entity.class, bb);
            for (Object thing : entityList) {
                EntitySpellProjectile projectile;
                if (!(thing instanceof EntitySpellProjectile) || (projectile = (EntitySpellProjectile)((Object)thing)).getShooter() == event.getEntityLiving()) continue;
                double rX = projectile.field_70165_t - event.getEntityLiving().field_70165_t;
                double rY = projectile.field_70163_u - event.getEntityLiving().field_70163_u;
                double rZ = projectile.field_70161_v - event.getEntityLiving().field_70161_v;
                System.out.println("Reflecting entity");
                double angle = (rX * projectile.field_70159_w + rZ * projectile.field_70179_y) / (Math.sqrt(rX * rX + rZ * rZ) * Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70179_y * projectile.field_70179_y));
                angle = Math.acos(angle);
                if (angle < 2.356194490192345) continue;
                double curvVel = Math.sqrt(rX * rX + rY * rY + rZ * rZ);
                rY /= curvVel;
                double newVel = Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y);
                projectile.field_70159_w = newVel * (rX /= curvVel);
                projectile.field_70179_y = newVel * (rZ /= curvVel);
            }
        }
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.wateryGrave) && event.getEntityLiving().func_70090_H()) {
            event.getEntityLiving().func_70024_g(0.0, -0.1, 0.0);
        } else if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.entangle)) {
            event.getEntityLiving().field_70159_w = 0.0;
            event.getEntityLiving().field_70181_x = 0.0;
            event.getEntityLiving().field_70179_y = 0.0;
        }
        ContingencyType type = ext.getContingencyType();
        if (event.getEntityLiving().func_70027_ad() && type == ContingencyType.FIRE) {
            SpellUtils.applyStackStage(ext.getContingencyStack(), event.getEntityLiving(), null, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, null, event.getEntityLiving().field_70170_p, false, true, 0);
            if (ext.getContingencyType() == ContingencyType.FIRE) {
                ext.setContingency(ContingencyType.NULL, null);
            }
        } else if (event.getEntityLiving().func_110143_aJ() * 4.0f < event.getEntityLiving().func_110138_aP() && type == ContingencyType.HEALTH) {
            SpellUtils.applyStackStage(ext.getContingencyStack(), event.getEntityLiving(), null, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, null, event.getEntityLiving().field_70170_p, false, true, 0);
            if (ext.getContingencyType() == ContingencyType.HEALTH) {
                ext.setContingency(ContingencyType.NULL, null);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTick(RenderGameOverlayEvent event) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ArsMagica2-Overlay");
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ArsMagica2.proxy.renderGameOverlay();
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public void playerTick(EntityPlayer player) {
        EntityExtension ext = EntityExtension.For((EntityLivingBase)player);
        IAffinityData affData = (IAffinityData)player.getCapability(AffinityData.INSTANCE, null);
        ext.flipTick();
        if (!player.field_70170_p.field_72995_K) {
            affData.tickDiminishingReturns();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IBoundItem)) continue;
                if (ext.hasEnoughtMana(((IBoundItem)stack.func_77973_b()).maintainCost(player, stack))) {
                    ext.deductMana(((IBoundItem)stack.func_77973_b()).maintainCost(player, stack));
                    continue;
                }
                stack.func_77973_b().onDroppedByPlayer(stack, player);
            }
        }
        if (player.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendPacketToServer((byte)61, new AMDataWriter().add(ext.getIsFlipped()).generate());
        }
        if (ext.getIsFlipped()) {
            double posY;
            World world;
            RayTraceResult mop;
            if (player.field_70181_x < 2.0 && !player.field_71075_bZ.field_75100_b) {
                player.field_70181_x += (double)0.15f;
            }
            if ((mop = (world = player.field_70170_p).func_72901_a(new Vec3d(player.field_70165_t, posY = player.field_70163_u + (double)player.field_70131_O, player.field_70161_v), new Vec3d(player.field_70165_t, posY + 1.0, player.field_70161_v), true)) != null) {
                if (!player.field_70122_E) {
                    world.func_180495_p(mop.func_178782_a()).func_177230_c().func_180658_a(world, mop.func_178782_a(), (Entity)player, Math.abs(player.field_70143_R));
                    player.field_70143_R = 0.0f;
                }
                player.field_70122_E = true;
                player.field_70160_al = false;
            } else {
                if (player.field_70181_x > 0.0) {
                    player.field_70143_R = (float)((double)player.field_70143_R + (player.field_70163_u - player.field_70167_r));
                    player.func_70637_d(false);
                }
                player.field_70160_al = true;
                player.field_70122_E = false;
            }
        }
        if (ArmorHelper.isInfusionPreset(player.func_184582_a(EntityEquipmentSlot.LEGS), "step_up")) {
            player.field_70138_W = 1.0111f;
        } else if (player.field_70138_W == 1.0111f) {
            player.field_70138_W = 0.6f;
        }
        IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (ArmorHelper.isInfusionPreset(player.func_184582_a(EntityEquipmentSlot.FEET), "run_spd")) {
            if (attr.func_111127_a(GenericImbuement.imbuedHasteID) == null) {
                attr.func_111121_a(GenericImbuement.imbuedHaste);
            }
        } else if (attr.func_111127_a(GenericImbuement.imbuedHasteID) != null) {
            attr.func_111124_b(GenericImbuement.imbuedHaste);
        }
        double lifeDepth = affData.getAffinityDepth(Affinity.LIFE);
        ext.lowerHealCooldown((int)Math.max(1.0, lifeDepth * 10.0));
        ext.lowerAffinityHealCooldown((int)Math.max(1.0, lifeDepth * 10.0));
    }

    @SubscribeEvent
    public void entityDeath(LivingDeathEvent e) {
        EntityExtension ext = EntityExtension.For(e.getEntityLiving());
        ContingencyType type = ext.getContingencyType();
        EntityLivingBase target = null;
        if (e.getEntityLiving() instanceof EntityPlayer) {
            ArsMagica2.proxy.playerTracker.onPlayerDeath((EntityPlayer)e.getEntityLiving());
        }
        if (e.getSource() != null && e.getEntityLiving() != null && e.getEntityLiving() instanceof EntityLiving && e.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getSource().func_76346_g();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemDefs.crystalPhylactery) continue;
                if (ItemDefs.crystalPhylactery.getSpawnClass(stack) == null) {
                    ItemDefs.crystalPhylactery.setSpawnClass(stack, e.getEntityLiving().getClass());
                }
                if (!ItemDefs.crystalPhylactery.canStore(stack, (EntityLiving)e.getEntityLiving())) continue;
                ItemDefs.crystalPhylactery.addFill(stack);
            }
        }
        if (e.getSource() != null && e.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = target = e.getSource().func_76346_g() != null ? (EntityLivingBase)e.getSource().func_76346_g() : null;
        }
        if (type == ContingencyType.DEATH) {
            SpellUtils.applyStackStage(ext.getContingencyStack(), e.getEntityLiving(), target, e.getEntity().field_70165_t, e.getEntity().field_70163_u, e.getEntity().field_70161_v, null, e.getEntityLiving().field_70170_p, false, true, 0);
            if (ext.getContingencyType() == ContingencyType.DEATH) {
                ext.setContingency(ContingencyType.NULL, null);
            }
        }
    }

    @SubscribeEvent
    public void attackEntity(LivingAttackEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            ItemStack stack = player.func_184607_cu();
            if (e.getAmount() > 0.0f && stack != null && stack.func_77973_b() == ItemDefs.BoundShield && EntityUtils.canBlockDamageSource((EntityLivingBase)player, e.getSource())) {
                if (EntityExtension.For((EntityLivingBase)player).hasEnoughtMana(e.getAmount() * 10.0f)) {
                    stack.func_77973_b().onDroppedByPlayer(stack, player);
                    EntityExtension.For((EntityLivingBase)player).deductMana(e.getAmount() * 10.0f);
                } else if (EntityExtension.For((EntityLivingBase)player).hasEnoughtMana(SpellUtils.getManaCost(stack, e.getEntity()))) {
                    EntityLivingBase target = e.getSource().func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)e.getSource().func_76346_g() : null;
                    double posX = target != null ? target.field_70165_t : player.field_70165_t;
                    double posY = target != null ? target.field_70163_u : player.field_70163_u;
                    double posZ = target != null ? target.field_70161_v : player.field_70161_v;
                    ItemStack copiedStack = SpellUtils.merge(stack.func_77946_l());
                    copiedStack.func_77978_p().func_74775_l("AM2").func_74768_a("CurrentGroup", SpellUtils.currentStage(stack) + 1);
                    copiedStack.func_150996_a((Item)ItemDefs.spell);
                    SpellUtils.applyStackStage(copiedStack, (EntityLivingBase)player, target, posX, posY, posZ, null, player.field_70170_p, true, true, 0);
                } else {
                    stack.func_77973_b().onDroppedByPlayer(stack, player);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        float shrink;
        ItemStack chestPlate = event.getEntityPlayer().field_71071_by.field_70460_b[2];
        ModelPlayer mainModel = event.getRenderer().func_177087_b();
        if (!ArsMagica2.proxy.playerTracker.hasCLS(event.getEntityPlayer().func_110124_au().toString())) {
            if (chestPlate != null && chestPlate.func_77973_b() == ItemDefs.earthArmor) {
                if (mainModel != null) {
                    mainModel.field_178724_i.field_78807_k = event.getEntityPlayer().func_184592_cb() != null;
                    mainModel.field_178723_h.field_78807_k = event.getEntityPlayer().func_184614_ca() != null;
                }
            } else if (mainModel != null) {
                mainModel.field_178724_i.field_78807_k = false;
                mainModel.field_178723_h.field_78807_k = false;
            }
        }
        double dX = Minecraft.func_71410_x().field_71439_g.field_70165_t - event.getEntityPlayer().field_70165_t;
        double dY = Minecraft.func_71410_x().field_71439_g.field_70163_u - event.getEntityPlayer().field_70163_u;
        double dZ = Minecraft.func_71410_x().field_71439_g.field_70161_v - event.getEntityPlayer().field_70161_v;
        double dpX = Minecraft.func_71410_x().field_71439_g.field_70169_q - event.getEntityPlayer().field_70169_q;
        double dpY = Minecraft.func_71410_x().field_71439_g.field_70167_r - event.getEntityPlayer().field_70167_r;
        double dpZ = Minecraft.func_71410_x().field_71439_g.field_70166_s - event.getEntityPlayer().field_70166_s;
        double transX = dpX + (dX - dpX) * (double)event.getPartialRenderTick();
        double transY = dpY + (dY - dpY) * (double)event.getPartialRenderTick();
        double transZ = dpZ + (dZ - dpZ) * (double)event.getPartialRenderTick();
        if (EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getFlipRotation() > 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-transX), (double)(-transY), (double)(-transZ));
            GL11.glRotatef((float)EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getFlipRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)transX, (double)transY, (double)transZ);
            float offset = event.getEntityPlayer().field_70131_O * (EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getFlipRotation() / 180.0f);
            GL11.glTranslatef((float)0.0f, (float)(-offset), (float)0.0f);
        }
        if ((shrink = EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getShrinkPct()) > 0.0f) {
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f - 0.5f * shrink), (float)(1.0f - 0.5f * shrink), (float)(1.0f - 0.5f * shrink));
        }
        CloakUtils.renderCloakModel(event.getEntityPlayer(), (ModelBiped)mainModel, event.getPartialRenderTick());
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (EntityUtils.isSummon(event.getEntityLiving()) && !(event.getEntityLiving() instanceof EntityHorse)) {
            event.setCanceled(true);
        }
        if (event.getSource() == DamageSources.darkNexus) {
            event.setCanceled(true);
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPig && event.getEntityLiving().func_70681_au().nextDouble() < (double)0.3f) {
            EntityItem animalFat = new EntityItem(event.getEntityLiving().field_70170_p);
            ItemStack stack = new ItemStack((Item)ItemDefs.itemOre, 1, 8);
            animalFat.func_70107_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
            animalFat.func_92058_a(stack);
            event.getDrops().add(animalFat);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Post event) {
        ModelPlayer mainModel = event.getRenderer().func_177087_b();
        if (mainModel != null) {
            mainModel.field_178724_i.field_78807_k = false;
            mainModel.field_178723_h.field_78807_k = false;
        }
        if (EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getFlipRotation() > 0.0f) {
            GL11.glPopMatrix();
        }
        if (EntityExtension.For((EntityLivingBase)event.getEntityPlayer()).getShrinkPct() > 0.0f) {
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        if (event.player == null) {
            return;
        }
        if (!event.player.field_70170_p.field_72995_K && EntityExtension.For((EntityLivingBase)event.player).getCurrentLevel() <= 0 && event.pickedUp.func_92059_d().func_77973_b() == ItemDefs.arcaneCompendium) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("You have unlocked the secrets of the arcane!"));
            AMNetHandler.INSTANCE.sendCompendiumUnlockPacket((EntityPlayerMP)event.player, "shapes", true);
            AMNetHandler.INSTANCE.sendCompendiumUnlockPacket((EntityPlayerMP)event.player, "components", true);
            AMNetHandler.INSTANCE.sendCompendiumUnlockPacket((EntityPlayerMP)event.player, "modifiers", true);
            EntityExtension.For((EntityLivingBase)event.player).setMagicLevelWithMana(1);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ItemStack boots = ((EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.FEET);
            if (boots != null && boots.func_77973_b() == ItemDefs.enderBoots && event.getEntityLiving().func_70093_af()) {
                EntityExtension.For(event.getEntityLiving()).setInverted(!EntityExtension.For(event.getEntityLiving()).isInverted());
            }
            if (EntityExtension.For(event.getEntityLiving()).getFlipRotation() > 0.0f) {
                ((EntityPlayer)event.getEntityLiving()).func_70024_g(0.0, -2.0 * event.getEntityLiving().field_70181_x, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem) {
            EntityItemWatcher.instance.addWatchedItem((EntityItem)event.getEntity());
        }
    }
}

