/*
 * Decompiled with CFR 0.152.
 */
package am2.handler;

import am2.api.event.PotionEvent;
import am2.api.event.SpellCastEvent;
import am2.blocks.tileentity.TileEntityAstralBarrier;
import am2.buffs.BuffEffect;
import am2.buffs.BuffEffectTemporalAnchor;
import am2.buffs.BuffStatModifiers;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.utils.DimensionUtilities;
import am2.utils.KeystoneUtilities;
import am2.utils.SelectionUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class PotionEffectHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerPreDeathEvent(LivingDeathEvent e) {
        PotionEffect effect = e.getEntityLiving().func_70660_b(PotionEffectsDefs.temporalAnchor);
        if (effect != null) {
            ((BuffEffectTemporalAnchor)effect).stopEffect(e.getEntityLiving());
            e.getEntityLiving().func_184589_d(PotionEffectsDefs.temporalAnchor);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void applyPotionEffect(PotionEvent.EventPotionAdded e) {
        if (PotionEffectsDefs.getEffect(e.effect) != null) {
            e.effect = PotionEffectsDefs.getEffect(e.effect);
        }
    }

    @SubscribeEvent
    public void loadPotionEffect(PotionEvent.EventPotionLoaded e) {
        PotionEvent.EventPotionAdded event = new PotionEvent.EventPotionAdded(e.getEffect());
        MinecraftForge.EVENT_BUS.post((Event)event);
        e.effect = event.getEffect();
        if (e.getEffect() instanceof BuffEffect) {
            ((BuffEffect)e.getEffect()).readFromNBT(e.getCompound());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void entityDamageEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().field_76373_n.equals(DamageSource.field_76380_i.field_76373_n)) {
            return;
        }
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.magicShield)) {
            event.setAmount(event.getAmount() * 0.25f);
        }
        float damage = EntityExtension.For(event.getEntityLiving()).protect(event.getAmount());
        event.setAmount(damage);
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent e) {
        BuffStatModifiers.instance.applyStatModifiersBasedOnBuffs(e.getEntityLiving());
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.slowfall)) {
            e.getEntityLiving().func_70107_b(e.getEntityLiving().field_70165_t, e.getEntityLiving().field_70163_u + (double)e.getEntityLiving().field_70143_R / 1.1, e.getEntityLiving().field_70161_v);
            e.getEntityLiving().field_70143_R = 0.0f;
        }
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.gravityWell) && e.getEntityLiving().field_70181_x < 0.0) {
            e.getEntityLiving().field_70181_x *= 2.0;
        }
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.agility)) {
            e.getEntityLiving().field_70138_W = 1.01f;
        } else if (e.getEntityLiving().field_70138_W == 1.01f) {
            e.getEntityLiving().field_70138_W = 0.6f;
        }
    }

    @SubscribeEvent
    public void playerJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.agility)) {
            event.getEntityLiving().field_70181_x *= 1.5;
        }
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.leap)) {
            EntityLivingBase velocityTarget = event.getEntityLiving();
            if (event.getEntityLiving().func_184187_bx() != null) {
                if (event.getEntityLiving().func_184187_bx() instanceof EntityMinecart) {
                    event.getEntityLiving().func_184187_bx().func_70107_b(event.getEntityLiving().func_184187_bx().field_70165_t, event.getEntityLiving().func_184187_bx().field_70163_u + 1.5, event.getEntityLiving().func_184187_bx().field_70161_v);
                }
                velocityTarget = event.getEntityLiving().func_184187_bx();
            }
            double yVelocity = 0.0;
            double xVelocity = 0.0;
            double zVelocity = 0.0;
            Vec3d vec = event.getEntityLiving().func_70040_Z().func_72432_b();
            yVelocity = 0.4 + (double)event.getEntityLiving().func_70660_b(PotionEffectsDefs.leap).func_76458_c() * 0.3;
            xVelocity = velocityTarget.field_70159_w * Math.pow(2.0, event.getEntityLiving().func_70660_b(PotionEffectsDefs.leap).func_76458_c()) * Math.abs(vec.field_72450_a);
            zVelocity = velocityTarget.field_70179_y * Math.pow(2.0, event.getEntityLiving().func_70660_b(PotionEffectsDefs.leap).func_76458_c()) * Math.abs(vec.field_72449_c);
            float maxHorizontalVelocity = 1.45f;
            if (event.getEntityLiving().func_184187_bx() != null && (event.getEntityLiving().func_184187_bx() instanceof EntityMinecart || event.getEntityLiving().func_184187_bx() instanceof EntityBoat) || event.getEntityLiving().func_70644_a(PotionEffectsDefs.haste)) {
                maxHorizontalVelocity += 25.0f;
                xVelocity *= 2.5;
                zVelocity *= 2.5;
            }
            if (xVelocity > (double)maxHorizontalVelocity) {
                xVelocity = maxHorizontalVelocity;
            } else if (xVelocity < (double)(-maxHorizontalVelocity)) {
                xVelocity = -maxHorizontalVelocity;
            }
            if (zVelocity > (double)maxHorizontalVelocity) {
                zVelocity = maxHorizontalVelocity;
            } else if (zVelocity < (double)(-maxHorizontalVelocity)) {
                zVelocity = -maxHorizontalVelocity;
            }
            if (EntityExtension.For(event.getEntityLiving()).getIsFlipped()) {
                yVelocity *= -1.0;
            }
            velocityTarget.func_70024_g(xVelocity, yVelocity, zVelocity);
        }
        if (event.getEntityLiving().func_70644_a(PotionEffectsDefs.entangle)) {
            event.getEntityLiving().field_70181_x = 0.0;
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent e) {
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.agility)) {
            e.setDistance(e.getDistance() / 1.5f);
        }
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.leap)) {
            if (e.getDistance() < (float)((e.getEntityLiving().func_70660_b(PotionEffectsDefs.leap).func_76458_c() + 1) * 10)) {
                e.setCanceled(true);
            } else {
                e.setDistance(e.getDistance() - (float)((e.getEntityLiving().func_70660_b(PotionEffectsDefs.leap).func_76458_c() + 1) * 10));
            }
        }
    }

    @SubscribeEvent
    public void spellCast(SpellCastEvent.Pre e) {
        if (e.entityLiving.func_70644_a(PotionEffectsDefs.clarity)) {
            e.manaCost = 0.0f;
            e.burnout = 0.0f;
            PotionEffect effect = e.entityLiving.func_70660_b(PotionEffectsDefs.clarity);
            e.entityLiving.func_184589_d(PotionEffectsDefs.clarity);
            if (effect.func_76458_c() <= 0) {
                return;
            }
            e.entityLiving.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() - 1));
        }
    }

    @SubscribeEvent
    public void teleportEvent(EnderTeleportEvent e) {
        ArrayList<Long> keystoneKeys = KeystoneUtilities.instance.GetKeysInInvenory(e.getEntityLiving());
        TileEntityAstralBarrier blockingBarrier = DimensionUtilities.GetBlockingAstralBarrier(e.getEntityLiving().field_70170_p, new BlockPos(e.getTargetX(), e.getTargetY(), e.getTargetZ()), keystoneKeys);
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.astralDistortion) || blockingBarrier != null) {
            e.setCanceled(true);
            if (blockingBarrier != null) {
                blockingBarrier.onEntityBlocked(e.getEntityLiving());
            }
            return;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerRender(RenderPlayerEvent.Pre e) {
        if (e.getEntityLiving().func_70644_a(PotionEffectsDefs.trueSight)) {
            GL11.glPushMatrix();
            GL11.glRotated((double)e.getEntityPlayer().field_70759_as, (double)0.0, (double)-1.0, (double)0.0);
            int[] runes = SelectionUtils.getRuneSet(e.getEntityPlayer());
            int numRunes = runes.length;
            double start = ((double)numRunes - 1.0) / 8.0;
            GL11.glTranslated((double)(-start), (double)2.2, (double)0.0);
            for (int rune : runes) {
                GL11.glPushMatrix();
                GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)e.getEntityPlayer(), new ItemStack((Item)ItemDefs.rune, 1, rune), ItemCameraTransforms.TransformType.GUI);
                GL11.glPopMatrix();
                GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            }
            GL11.glPopMatrix();
        }
    }
}

