/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.blocks.tileentity.TileEntityCrystalMarker;
import am2.blocks.tileentity.TileEntityFlickerHabitat;
import am2.blocks.tileentity.TileEntityParticleEmitter;
import am2.items.ItemArsMagicaRotated;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemCrystalWrench
extends ItemArsMagicaRotated {
    private static String KEY_PAIRLOC = "PAIRLOC";
    private static String HAB_PAIRLOC = "HABLOC";
    private static String KEEP_BINDING = "KEEPBINDING";
    private static String MODE = "WRENCHMODE";
    private static final int MODE_PAIR = 0;
    private static final int MODE_DISCONNECT = 1;

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int cMode = ItemCrystalWrench.getMode(stack);
        if (te != null && !(te instanceof IPowerNode) && !(te instanceof TileEntityParticleEmitter) && cMode == 1) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.wrongWrenchMode")));
            return EnumActionResult.FAIL;
        }
        if (te != null && te instanceof IPowerNode) {
            if (cMode == 1) {
                this.doDisconnect((IPowerNode)te, world, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ, player);
                return EnumActionResult.FAIL;
            }
            if (stack.func_77978_p().func_74764_b(KEY_PAIRLOC)) {
                this.doPairNodes(world, pos, stack, player, hitX, hitY, hitZ, te);
            } else {
                this.storePairLocation(world, te, stack, player, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
            }
        } else if (te != null && te instanceof TileEntityCrystalMarker && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(HAB_PAIRLOC)) {
            this.handleCMPair(stack, world, player, te, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        } else if (player.func_70093_af()) {
            this.handleModeChanges(stack);
        }
        return EnumActionResult.PASS;
    }

    private void handleCMPair(ItemStack stack, World world, EntityPlayer player, TileEntity te, double hitX, double hitY, double hitZ) {
        AMVector3 habLocation = AMVector3.readFromNBT(stack.func_77978_p().func_74775_l(HAB_PAIRLOC));
        if (world.field_72995_K) {
            this.spawnLinkParticles(world, hitX, hitY, hitZ);
        } else {
            TileEntityCrystalMarker tecm = (TileEntityCrystalMarker)te;
            tecm.linkToHabitat(habLocation, player);
            if (!stack.func_77978_p().func_74764_b(KEEP_BINDING)) {
                stack.func_77978_p().func_82580_o(HAB_PAIRLOC);
            }
        }
    }

    private void storePairLocation(World world, TileEntity te, ItemStack stack, EntityPlayer player, double hitX, double hitY, double hitZ) {
        AMVector3 destination = new AMVector3(te);
        if (!world.field_72995_K) {
            if (te instanceof TileEntityFlickerHabitat) {
                NBTTagCompound habLoc = new NBTTagCompound();
                destination.writeToNBT(habLoc);
                stack.func_77978_p().func_74782_a(HAB_PAIRLOC, (NBTBase)habLoc);
            } else {
                NBTTagCompound pairLoc = new NBTTagCompound();
                destination.writeToNBT(pairLoc);
                stack.func_77978_p().func_74782_a(KEY_PAIRLOC, (NBTBase)pairLoc);
            }
            if (player.func_70093_af()) {
                stack.func_77978_p().func_74757_a(KEEP_BINDING, true);
            }
        } else {
            this.spawnLinkParticles(world, hitX, hitY, hitZ);
        }
    }

    private void doPairNodes(World world, BlockPos pos, ItemStack stack, EntityPlayer player, double hitX, double hitY, double hitZ, TileEntity te) {
        AMVector3 source = AMVector3.readFromNBT(stack.func_77978_p().func_74775_l(KEY_PAIRLOC));
        TileEntity sourceTE = world.func_175625_s(source.toBlockPos());
        if (sourceTE != null && sourceTE instanceof IPowerNode && !world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(PowerNodeRegistry.For(world).tryPairNodes((IPowerNode)sourceTE, (IPowerNode)te)));
        } else if (world.field_72995_K) {
            this.spawnLinkParticles(world, (double)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + hitY, (double)pos.func_177952_p() + hitZ);
        }
        if (!stack.func_77978_p().func_74764_b(KEEP_BINDING)) {
            stack.func_77978_p().func_82580_o(KEY_PAIRLOC);
        }
    }

    private void doDisconnect(IPowerNode<?> node, World world, double hitX, double hitY, double hitZ, EntityPlayer player) {
        PowerNodeRegistry.For(world).tryDisconnectAllNodes(node);
        if (world.field_72995_K) {
            this.spawnLinkParticles(player.field_70170_p, hitX, hitY, hitZ, true);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.disconnectPower")));
        }
    }

    private void handleModeChanges(ItemStack stack) {
        if (stack.func_77978_p().func_74764_b(KEEP_BINDING)) {
            stack.func_77978_p().func_82580_o(KEEP_BINDING);
            if (stack.func_77978_p().func_74764_b(KEY_PAIRLOC)) {
                stack.func_77978_p().func_82580_o(KEY_PAIRLOC);
            }
            if (stack.func_77978_p().func_74764_b(HAB_PAIRLOC)) {
                stack.func_77978_p().func_82580_o(HAB_PAIRLOC);
            }
        } else if (ItemCrystalWrench.getMode(stack) == 0) {
            stack.func_77978_p().func_74768_a(MODE, 1);
        } else {
            stack.func_77978_p().func_74768_a(MODE, 0);
        }
    }

    public static int getMode(ItemStack stack) {
        if (stack.func_77978_p().func_74764_b(MODE)) {
            return stack.func_77978_p().func_74762_e(MODE);
        }
        return 0;
    }

    private void spawnLinkParticles(World world, double hitX, double hitY, double hitZ) {
        this.spawnLinkParticles(world, hitX, hitY, hitZ, false);
    }

    private void spawnLinkParticles(World world, double hitX, double hitY, double hitZ, boolean disconnect) {
        for (int i = 0; i < 10; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "none_hand", hitX, hitY, hitZ));
            if (particle == null) continue;
            if (disconnect) {
                particle.setRGBColorF(1.0f, 0.0f, 0.0f);
                particle.addRandomOffset(0.5, 0.5, 0.5);
            }
            particle.func_187114_a(10);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleMoveOnHeading(particle, world.field_73012_v.nextInt(360), world.field_73012_v.nextInt(360), world.field_73012_v.nextDouble() * 0.2, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.1f));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public int func_77639_j() {
        return 1;
    }
}

