/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.ItemArsMagica;
import am2.utils.EntityUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemJournal
extends ItemArsMagica {
    private static final String KEY_NBT_XP = "Stored_XP";
    private static final String KEY_NBT_OWNER = "Owner";

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack journal, EntityPlayer player, List<String> list, boolean par4) {
        String owner = this.getOwner(journal);
        if (owner == null) {
            list.add(I18n.func_74838_a((String)"am2.tooltip.unowned"));
            list.add(I18n.func_74838_a((String)"am2.tooltip.journalUse"));
            return;
        }
        list.add(String.format(I18n.func_74838_a((String)"am2.tooltip.journalOwner"), new Object[0]));
        list.add(String.format(I18n.func_74838_a((String)"am2.tooltip.journalOwner2"), owner));
        if (owner.equals(player.func_70005_c_())) {
            list.add(String.format(I18n.func_74838_a((String)"am2.tooltip.containedXP"), this.getXPInJournal(journal)));
        }
        if (owner == null || owner.equals(player.func_70005_c_())) {
            list.add(I18n.func_74838_a((String)"am2.tooltip.journalUse"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack journal, World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.getOwner(journal) == null) {
                this.setOwner(journal, player);
            } else if (!this.getOwner(journal).equals(player.func_70005_c_())) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.notYourJournal")));
                return super.func_77659_a(journal, world, player, hand);
            }
            if (player.func_70093_af()) {
                int removedXP = EntityUtils.deductXP(10, player);
                this.addXPToJournal(journal, removedXP);
            } else {
                int amt = Math.min(this.getXPInJournal(journal), 10);
                if (amt > 0) {
                    player.func_71023_q(amt);
                    this.deductXPFromJournal(journal, amt);
                }
            }
        }
        return super.func_77659_a(journal, world, player, hand);
    }

    private void addXPToJournal(ItemStack journal, int amount) {
        if (!journal.func_77942_o()) {
            journal.func_77982_d(new NBTTagCompound());
        }
        journal.func_77978_p().func_74768_a(KEY_NBT_XP, journal.func_77978_p().func_74762_e(KEY_NBT_XP) + amount);
    }

    private void deductXPFromJournal(ItemStack journal, int amount) {
        this.addXPToJournal(journal, -amount);
    }

    private int getXPInJournal(ItemStack journal) {
        if (!journal.func_77942_o()) {
            return 0;
        }
        return journal.func_77978_p().func_74762_e(KEY_NBT_XP);
    }

    private String getOwner(ItemStack journal) {
        if (!journal.func_77942_o()) {
            return null;
        }
        return journal.func_77978_p().func_74779_i(KEY_NBT_OWNER);
    }

    private void setOwner(ItemStack journal, EntityPlayer player) {
        if (!journal.func_77942_o()) {
            journal.func_77982_d(new NBTTagCompound());
        }
        journal.func_77978_p().func_74778_a(KEY_NBT_OWNER, player.func_70005_c_());
    }
}

