/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.ArsMagica2;
import am2.container.InventoryKeyStone;
import am2.defs.ItemDefs;
import am2.items.ItemArsMagica;
import am2.utils.KeystoneUtilities;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class ItemKeystone
extends ItemArsMagica {
    public static final int KEYSTONE_INVENTORY_SIZE = 3;

    public ItemKeystone() {
        this.func_77625_d(1);
    }

    public void addCombination(ItemStack stack, String name, int[] metas) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int comboID = this.numCombinations(stack);
        boolean isNew = true;
        for (int i = 0; i < comboID; ++i) {
            if (!name.equals(stack.func_77978_p().func_74779_i("Combination_" + i + "_name"))) continue;
            comboID = i;
            isNew = false;
            break;
        }
        stack.func_77978_p().func_74778_a("Combination_" + comboID + "_name", name);
        stack.func_77978_p().func_74783_a("Combination_" + comboID + "_metas", metas);
        if (isNew) {
            stack.func_77978_p().func_74768_a("numKeystoneCombinations", comboID + 1);
        }
    }

    public void removeCombination(ItemStack stack, String name) {
        int i;
        int c = this.numCombinations(stack);
        int removedIndex = -1;
        for (i = 0; i < c; ++i) {
            KeystoneCombination combo = this.getCombinationAt(stack, i);
            if (!combo.name.equals(name)) continue;
            removedIndex = i;
            break;
        }
        if (removedIndex == -1) {
            return;
        }
        for (i = removedIndex + 1; i < c; ++i) {
            String tName = stack.func_77978_p().func_74779_i("Combination_" + i + "_name");
            int[] tMetas = stack.func_77978_p().func_74759_k("Combination_" + i + "_metas");
            stack.func_77978_p().func_74778_a("Combination_" + (i - 1) + "_name", tName);
            stack.func_77978_p().func_74783_a("Combination_" + (i - 1) + "_metas", tMetas);
        }
        stack.func_77978_p().func_82580_o("Combination_" + c + "_name");
        stack.func_77978_p().func_82580_o("Combination_" + c + "_metas");
        stack.func_77978_p().func_74768_a("numKeystoneCombinations", c - 1);
    }

    public int numCombinations(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("numKeystoneCombinations");
    }

    public KeystoneCombination getCombinationAt(ItemStack stack, int index) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (this.numCombinations(stack) <= index) {
            return null;
        }
        String name = stack.func_77978_p().func_74779_i("Combination_" + index + "_name");
        int[] metas = stack.func_77978_p().func_74759_k("Combination_" + index + "_metas");
        return new KeystoneCombination(name, metas);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArsMagica2.instance, (int)8, (World)world, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u), (int)((int)player.field_70161_v));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private ItemStack[] getMyInventory(ItemStack itemStack) {
        return this.ReadFromStackTagCompound(itemStack);
    }

    public String getRecipeAsString(ItemStack keystoneStack) {
        String s = "Recipe: ";
        for (ItemStack stack : this.getMyInventory(keystoneStack)) {
            s = s + stack.func_82833_r().replace("Rune ", "") + " ";
        }
        return s;
    }

    public void UpdateStackTagCompound(ItemStack itemStack, ItemStack[] values) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        for (int i = 0; i < values.length; ++i) {
            ItemStack stack = values[i];
            if (stack == null) {
                itemStack.func_77978_p().func_74768_a("keystonemeta" + i, -1);
                continue;
            }
            itemStack.func_77978_p().func_74768_a("keystonemeta" + i, stack.func_77952_i());
        }
    }

    public ItemStack[] ReadFromStackTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return new ItemStack[3];
        }
        ItemStack[] items = new ItemStack[3];
        for (int i = 0; i < items.length; ++i) {
            int meta = 0;
            if (!itemStack.func_77978_p().func_74764_b("keystonemeta" + i)) {
                items[i] = null;
                continue;
            }
            if (itemStack.func_77978_p().func_74762_e("keystonemeta" + i) == -1) {
                items[i] = null;
                continue;
            }
            meta = itemStack.func_77978_p().func_74762_e("keystonemeta" + i);
            items[i] = new ItemStack((Item)ItemDefs.rune, 1, meta);
        }
        return items;
    }

    public InventoryKeyStone ConvertToInventory(ItemStack keyStoneStack) {
        InventoryKeyStone iks = new InventoryKeyStone();
        iks.SetInventoryContents(this.getMyInventory(keyStoneStack));
        return iks;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        ItemStack[] items = this.getMyInventory(par1ItemStack);
        String s = I18n.func_74838_a((String)"am2.tooltip.open");
        par3List.add("\u00a77" + s);
        if (items.length > 0) {
            s = I18n.func_74838_a((String)"am2.tooltip.runes") + ": ";
            par3List.add("\u00a77" + s);
            s = "";
            for (int i = 0; i < 3; ++i) {
                if (items[i] == null) continue;
                s = s + items[i].func_82833_r().replace("Rune", "").trim() + " ";
            }
            if (s == "") {
                s = I18n.func_74838_a((String)"am2.tooltip.none");
            }
            par3List.add("\u00a77" + s);
        }
    }

    public long getKey(ItemStack keystoneStack) {
        ItemStack[] inventory = this.getMyInventory(keystoneStack);
        if (inventory == null) {
            return 0L;
        }
        return KeystoneUtilities.instance.getKeyFromRunes(inventory);
    }

    public class KeystoneCombination {
        public int[] metas;
        public String name;

        public KeystoneCombination(String name, int[] metas) {
            this.metas = metas;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeystoneCombination) {
                boolean match;
                boolean bl = match = ((KeystoneCombination)obj).metas.length == this.metas.length;
                if (!match) {
                    return false;
                }
                for (int i = 0; i < this.metas.length; ++i) {
                    match &= this.metas[i] == ((KeystoneCombination)obj).metas[i];
                }
                return match;
            }
            return false;
        }

        public int hashCode() {
            int sum = 0;
            for (int i : this.metas) {
                sum += i;
            }
            return sum;
        }
    }
}

