/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.api.power.IPowerNode;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.defs.SkillDefs;
import am2.extensions.SkillData;
import am2.items.ItemArsMagica;
import am2.packet.AMNetHandler;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.spell.SpellCastResult;
import am2.utils.SpellUtils;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellStaff
extends ItemArsMagica {
    private final int castingMode;
    private final int maxCharge;
    private static final String NBT_CHARGE = "current_charge";
    private static final String NBT_SPELL = "spell_to_cast";
    private static final String NBT_SPELL_NAME = "spell_name";

    public ItemSpellStaff(int charge, int castingMode) {
        this.func_77656_e(charge);
        this.maxCharge = charge;
        this.field_77777_bU = 1;
        this.castingMode = castingMode;
    }

    public ItemSpellStaff setStaffHeadIndex(int index) {
        if (index > 3 || index < 0) {
            index = 0;
        }
        return this;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return this.isMagiTechStaff() || this.getSpellStack(par1ItemStack) != null;
    }

    public boolean isMagiTechStaff() {
        return this.castingMode == -1;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        if (this.isMagiTechStaff()) {
            return EnumAction.NONE;
        }
        return EnumAction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void setSpellScroll(ItemStack stack, ItemStack spell) {
        if (this.isMagiTechStaff()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        NBTTagCompound spellCompound = spell.func_77955_b(new NBTTagCompound());
        compound.func_74782_a(NBT_SPELL, (NBTBase)spellCompound);
        compound.func_74778_a(NBT_SPELL_NAME, spell.func_82833_r());
        if (!compound.func_74764_b(NBT_CHARGE)) {
            compound.func_74776_a(NBT_CHARGE, (float)this.maxCharge);
        }
    }

    public void copyChargeFrom(ItemStack my_stack, ItemStack stack) {
        if (this.isMagiTechStaff()) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemSpellStaff && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(NBT_CHARGE)) {
            if (my_stack.func_77978_p() == null) {
                my_stack.func_77982_d(new NBTTagCompound());
            }
            my_stack.func_77978_p().func_74776_a(NBT_CHARGE, stack.func_77978_p().func_74760_g(NBT_CHARGE));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (stack.func_77978_p() == null || this.isMagiTechStaff()) {
            return;
        }
        float chargeCost = 1.0f;
        ItemStack spell = this.getSpellStack(stack);
        if (spell != null) {
            chargeCost = SpellUtils.getManaCost(spell, (Entity)par2EntityPlayer);
        }
        if (chargeCost == 0.0f) {
            chargeCost = 1.0f;
        }
        float chargeRemaining = stack.func_77978_p().func_74760_g(NBT_CHARGE);
        int chargesRemaining = (int)Math.ceil(chargeRemaining / chargeCost);
        par3List.add(I18n.func_74838_a((String)"am2.tooltip.charge") + ": " + (int)chargeRemaining + " / " + this.maxCharge);
        par3List.add("" + chargesRemaining + " " + I18n.func_74838_a((String)"am2.tooltip.uses") + ".");
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        if (this.isMagiTechStaff()) {
            return I18n.func_74838_a((String)"item.arsmagica2:spell_staff_magitech.name");
        }
        String name = super.func_77653_i(par1ItemStack);
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b(NBT_SPELL_NAME)) {
            name = name + " (\u00a79" + par1ItemStack.func_77978_p().func_74779_i(NBT_SPELL_NAME) + "\u00a77)";
        }
        return name;
    }

    public boolean func_77651_p() {
        return true;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isMagiTechStaff()) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        if (this.isMagiTechStaff() && !world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof IPowerNode) {
            if (player.func_70093_af()) {
                AMNetHandler.INSTANCE.syncPowerPaths((IPowerNode)te, (EntityPlayerMP)player);
            } else {
                List<PowerTypes> types = ((IPowerNode)te).getValidPowerTypes();
                for (PowerTypes type : types) {
                    float power = PowerNodeRegistry.For(world).getPower((IPowerNode)te, type);
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format(I18n.func_74838_a((String)"am2.tooltip.det_eth"), type.getChatColor(), type.name(), String.format("%.2f", Float.valueOf(power)))));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        SpellShape shape;
        if (this.isMagiTechStaff()) {
            return;
        }
        ItemStack spell = this.getSpellStack(stack);
        if (spell != null && (shape = SpellUtils.getShapeForStage(spell, 0)) != null) {
            if (!shape.isChanneled() && SpellUtils.applyStackStage(spell, entityLiving, null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, null, worldIn, false, false, timeLeft) == SpellCastResult.SUCCESS) {
                this.consumeStaffCharge(stack, (EntityPlayer)entityLiving);
            }
            if (!worldIn.field_72995_K || shape.isChanneled()) {
                // empty if block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_184607_cu()) != null && usingItem.func_77973_b() == this && SkillData.For((EntityLivingBase)player).hasSkill(SkillDefs.SPELL_MOTION.getID())) {
            player.field_71158_b.field_78900_b *= 2.5f;
            player.field_71158_b.field_78902_a *= 2.5f;
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return 2000;
    }

    private ItemStack getSpellStack(ItemStack staffStack) {
        if (!staffStack.func_77942_o() || !staffStack.func_77978_p().func_74764_b(NBT_SPELL)) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ItemDefs.spell);
        stack.func_77963_c(staffStack.func_77978_p().func_74775_l(NBT_SPELL));
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        if (this.isMagiTechStaff()) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (this.getSpellStack(itemstack) != null) {
            entityplayer.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player instanceof EntityPlayer) {
            if (this.isMagiTechStaff()) {
                return;
            }
            ItemStack spell = this.getSpellStack(stack);
            if (spell != null && SpellUtils.applyStackStageOnUsing(spell, player, player, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p, false, true, count - 1) == SpellCastResult.SUCCESS) {
                this.consumeStaffCharge(stack, (EntityPlayer)player);
            }
        }
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.getDamage(stack);
        }
        float chargeRemaining = stack.func_77978_p().func_74760_g(NBT_CHARGE);
        return this.maxCharge - (int)Math.floor(chargeRemaining);
    }

    private void consumeStaffCharge(ItemStack staffStack, EntityPlayer caster) {
        float chargeCost = 1.0f;
        ItemStack spell = this.getSpellStack(staffStack);
        if (spell != null) {
            chargeCost = SpellUtils.getManaCost(staffStack, (Entity)caster);
        }
        if (chargeCost == 0.0f) {
            chargeCost = 1.0f;
        }
        float chargeRemaining = staffStack.func_77978_p().func_74760_g(NBT_CHARGE);
        staffStack.func_77978_p().func_74776_a(NBT_CHARGE, chargeRemaining -= chargeCost);
        if (chargeRemaining <= 0.0f && !caster.field_70170_p.field_72995_K && caster.func_184607_cu() != null) {
            caster.func_184607_cu().func_77972_a(9001, (EntityLivingBase)caster);
        }
    }
}

