/*
 * Decompiled with CFR 0.152.
 */
package am2.items.rendering;

import am2.items.rendering.SpellBakedModel;
import am2.utils.ModelUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class SpellModel
implements IModel {
    private ImmutableList<ResourceLocation> textures;

    public SpellModel(ImmutableList<ResourceLocation> textures) {
        this.textures = textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        IBakedModel model = new ItemLayerModel(this.textures).bake(state, format, bakedTextureGetter);
        return new SpellBakedModel(model, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map);
    }

    public IModelState getDefaultState() {
        return ModelUtils.DEFAULT_ITEM_STATE;
    }
}

