/*
 * Decompiled with CFR 0.152.
 */
package am2.items.rendering;

import am2.api.affinity.Affinity;
import am2.items.ItemSpellBase;
import am2.items.ItemSpellBook;
import am2.particles.AMParticleIcons;
import am2.utils.AffinityShiftUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SpellParticleRender
extends ItemOverrideList {
    private final Minecraft mc;
    private final Map<Affinity, TextureAtlasSprite> icons;
    private boolean setupIcons = false;
    private static final ResourceLocation rLoc = TextureMap.field_110575_b;

    public SpellParticleRender(List<ItemOverride> overridesIn) {
        super(overridesIn);
        new ModelBiped(0.0f);
        this.mc = Minecraft.func_71410_x();
        this.icons = new HashMap<Affinity, TextureAtlasSprite>();
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        if (world == null || entity == null) {
            return super.handleItemState(originalModel, stack, world, entity);
        }
        if (!Minecraft.func_71410_x().field_71415_G) {
            return super.handleItemState(originalModel, stack, world, entity);
        }
        this.renderItem(stack, entity);
        return new BakedBlank();
    }

    public void renderItem(ItemStack item, EntityLivingBase entity) {
        if (this.mc.field_71439_g.func_70644_a(Potion.func_180142_b((String)"invisibility"))) {
            return;
        }
        ItemStack scrollStack = null;
        if (item.func_77973_b() instanceof ItemSpellBase) {
            scrollStack = item;
        } else if (item.func_77973_b() instanceof ItemSpellBook) {
            scrollStack = ((ItemSpellBook)item.func_77973_b()).getActiveScrollInventory(item)[((ItemSpellBook)item.func_77973_b()).GetActiveSlot(item)];
        }
        if (scrollStack == null) {
            return;
        }
        Affinity affinity = AffinityShiftUtils.getMainShiftForStack(scrollStack);
        this.renderEffect(affinity, true, entity);
    }

    public void renderEffect(Affinity affinity, boolean includeArm, EntityLivingBase entity) {
        if (!this.setupIcons) {
            this.setupAffinityIcons();
            this.setupIcons = true;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float scale = 3.0f;
        if (entity == this.mc.field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            GL11.glPushMatrix();
            RenderHelper.func_74518_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.5f);
            this.RenderByAffinity(affinity);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
            if (includeArm) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.mc.field_71439_g.func_110306_p());
                this.renderFirstPersonArm(this.mc.field_71439_g);
            }
        } else {
            GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
            scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.RenderByAffinity(affinity);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void setupAffinityIcons() {
        this.icons.put(Affinity.AIR, AMParticleIcons.instance.getIconByName("air_hand"));
        this.icons.put(Affinity.ARCANE, AMParticleIcons.instance.getIconByName("arcane_hand"));
        this.icons.put(Affinity.EARTH, AMParticleIcons.instance.getIconByName("earth_hand"));
        this.icons.put(Affinity.ENDER, AMParticleIcons.instance.getIconByName("ender_hand"));
        this.icons.put(Affinity.FIRE, AMParticleIcons.instance.getIconByName("fire_hand"));
        this.icons.put(Affinity.ICE, AMParticleIcons.instance.getIconByName("ice_hand"));
        this.icons.put(Affinity.LIFE, AMParticleIcons.instance.getIconByName("life_hand"));
        this.icons.put(Affinity.LIGHTNING, AMParticleIcons.instance.getIconByName("lightning_hand"));
        this.icons.put(Affinity.NATURE, AMParticleIcons.instance.getIconByName("nature_hand"));
        this.icons.put(Affinity.NONE, AMParticleIcons.instance.getIconByName("none_hand"));
        this.icons.put(Affinity.WATER, AMParticleIcons.instance.getIconByName("water_hand"));
    }

    public void RenderByAffinity(Affinity affinity) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rLoc);
        TextureAtlasSprite icon = this.icons.get(affinity);
        if (icon == null) {
            return;
        }
        float TLX = icon.func_94209_e();
        float BRX = icon.func_94212_f();
        float TLY = icon.func_94206_g();
        float BRY = icon.func_94210_h();
        this.doRender(TLX, TLY, BRX, BRY);
    }

    private void doRender(float TLX, float TLY, float BRX, float BRY) {
        Tessellator t = Tessellator.func_178181_a();
        t.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181710_j);
        t.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)TLX, (double)BRY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        t.func_178180_c().func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)BRX, (double)BRY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        t.func_178180_c().func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)BRX, (double)TLY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        t.func_178180_c().func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)TLX, (double)TLY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        t.func_78381_a();
    }

    private void renderFirstPersonArm(EntityPlayerSP player) {
        EnumHandSide hand = EnumHandSide.LEFT;
        boolean flag = hand != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)0.0f);
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)0.0f);
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        EntityPlayerSP abstractclientplayer = this.mc.field_71439_g;
        this.mc.func_110434_K().func_110577_a(abstractclientplayer.func_110306_p());
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        RenderPlayer renderplayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)abstractclientplayer);
        GlStateManager.func_179129_p();
        if (flag) {
            renderplayer.func_177138_b((AbstractClientPlayer)abstractclientplayer);
        } else {
            renderplayer.func_177139_c((AbstractClientPlayer)abstractclientplayer);
        }
        GlStateManager.func_179089_o();
    }

    private class BakedBlank
    implements IBakedModel {
        private BakedBlank() {
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return Lists.newArrayList();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList(new ArrayList());
        }
    }
}

