/*
 * Decompiled with CFR 0.152.
 */
package am2.items.rendering;

import am2.ArsMagica2;
import am2.LogHelper;
import am2.defs.ItemDefs;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class SpellRenderer
implements ItemMeshDefinition {
    public static List<ResourceLocation> resources;
    private static final String iconsPath = "/assets/arsmagica2/models/item/spells/icons/";
    private static final String iconsPrefix = "spells/icons/";
    private List<ModelResourceLocation> locations = Lists.newArrayList();

    public SpellRenderer() {
        resources = SpellRenderer.getResourceListing();
        for (ResourceLocation resource : resources) {
            this.locations.add(new ModelResourceLocation(resource, "inventory"));
            ModelBakery.registerItemVariants((Item)ItemDefs.spell, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(resource, "inventory")});
        }
        LogHelper.info("Sucessfully Loaded " + this.locations.size() + " Spell Icons", new Object[0]);
    }

    public static List<ResourceLocation> getResourceListing() {
        ArrayList<ResourceLocation> toReturn = new ArrayList();
        try {
            URI uri = ArsMagica2.class.getResource(iconsPath).toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                Path myPath = fs.getPath(iconsPath, new String[0]);
                toReturn = SpellRenderer.processDirectory(myPath, fs);
                fs.close();
                return toReturn;
            }
            Path myPath = Paths.get(uri);
            toReturn = SpellRenderer.processDirectory(myPath, FileSystems.getDefault());
            return toReturn;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Lists.newArrayList();
    }

    private static ArrayList<ResourceLocation> processDirectory(Path dir, FileSystem fs) {
        ArrayList<ResourceLocation> toReturn = new ArrayList<ResourceLocation>();
        try {
            Stream<Path> walk = Files.walk(dir, 1, new FileVisitOption[0]);
            Iterator file = walk.iterator();
            while (file.hasNext()) {
                String name = ((Path)file.next()).toString();
                if (name.lastIndexOf(fs.getSeparator()) + 1 > name.length() || (name = name.substring(name.lastIndexOf(fs.getSeparator()) + 1)).equals("")) continue;
                toReturn.add(new ResourceLocation("arsmagica2:spells/icons/" + name.replace(".json", "")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(toReturn, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return toReturn;
    }

    public ModelResourceLocation func_178113_a(ItemStack stack) {
        return this.locations.get(MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.locations.size() - 1)));
    }
}

