/*
 * Decompiled with CFR 0.152.
 */
package am2.navigation;

import am2.navigation.BreadCrumb;
import am2.navigation.MinHeap;
import am2.navigation.Point3D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class PathFinder {
    public static boolean showPaths = true;
    private static Block[] validBlockIDs = new Block[]{Blocks.field_150350_a, Blocks.field_150468_ap, Blocks.field_150330_I, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150448_aq, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150442_at, Blocks.field_150319_E, Blocks.field_150478_aa, Blocks.field_150395_bd};
    private static Point3D[] surrounding = new Point3D[]{new Point3D(-1, 1, 1), new Point3D(0, 1, 1), new Point3D(1, 1, 1), new Point3D(-1, 1, 0), new Point3D(0, 1, 0), new Point3D(1, 1, 0), new Point3D(-1, 1, -1), new Point3D(0, 1, -1), new Point3D(1, 1, -1), new Point3D(-1, 0, 1), new Point3D(0, 0, 1), new Point3D(1, 0, 1), new Point3D(-1, 0, 0), new Point3D(1, 0, 0), new Point3D(-1, 0, -1), new Point3D(0, 0, -1), new Point3D(1, 0, -1), new Point3D(-1, -1, 1), new Point3D(0, -1, 1), new Point3D(1, -1, 1), new Point3D(-1, -1, 0), new Point3D(0, -1, 0), new Point3D(1, -1, 0), new Point3D(-1, -1, -1), new Point3D(0, -1, -1), new Point3D(1, -1, -1)};

    public static BreadCrumb FindPath(World world, Point3D start, Point3D end, Entity entity) throws Exception {
        BreadCrumb bc = PathFinder.FindPathReversed(world, end, start, entity);
        return bc;
    }

    public static BreadCrumb FindPath(World world, Point3D start, Point3D end) throws Exception {
        return PathFinder.FindPath(world, start, end, null);
    }

    private static BreadCrumb FindPathReversed(World world, Point3D start, Point3D end, Entity entity) throws Exception {
        MinHeap openList = new MinHeap(256);
        if (Math.abs(end.x) - Math.abs(start.x) > 19 || Math.abs(end.y) - Math.abs(start.y) > 19 || Math.abs(end.z) - Math.abs(start.z) > 19) {
            return null;
        }
        BreadCrumb[][][] brWorld = new BreadCrumb[25][25][25];
        if (start.x < end.x) {
            end.shiftX(start.shiftX());
        } else {
            start.shiftX(end.shiftX());
        }
        if (start.y < end.y) {
            end.shiftY(start.shiftY());
        } else {
            start.shiftY(end.shiftY());
        }
        if (start.z < end.z) {
            end.shiftZ(start.shiftZ());
        } else {
            start.shiftZ(end.shiftZ());
        }
        BreadCrumb current = new BreadCrumb(start);
        current.cost = 0;
        BreadCrumb finish = new BreadCrumb(end);
        brWorld[current.position.x][current.position.y][current.position.z] = current;
        openList.Add(current);
        while (openList.Count() > 0) {
            current = openList.ExtractFirst();
            current.onClosedList = true;
            for (int i = 0; i < surrounding.length; ++i) {
                int cost;
                BreadCrumb node;
                Point3D tmp = current.position.add(surrounding[i]);
                if (tmp.x < 0 || tmp.y < 0 || tmp.z < 0 || tmp.x > 20 || tmp.y > 20 || tmp.z > 20 || !PathFinder.BlockIsNavigateable(world, tmp, current.position, entity)) continue;
                if (brWorld[tmp.x][tmp.y][tmp.z] == null) {
                    brWorld[tmp.x][tmp.y][tmp.z] = node = new BreadCrumb(tmp);
                } else {
                    node = brWorld[tmp.x][tmp.y][tmp.z];
                }
                if (node.onClosedList) continue;
                int diff = 0;
                if (current.position.x != node.position.x) {
                    ++diff;
                }
                if (current.position.y != node.position.y) {
                    ++diff;
                }
                if (current.position.z != node.position.z) {
                    ++diff;
                }
                if ((cost = (int)((double)(current.cost + diff) + node.position.GetDistanceSq(end))) < node.cost) {
                    node.cost = cost;
                    node.next = current;
                }
                if (node.onOpenList) continue;
                if (node.equals(finish)) {
                    node.next = current;
                    return node;
                }
                node.onOpenList = true;
                openList.Add(node);
            }
        }
        return null;
    }

    private static boolean BlockIsNavigateable(World world, Point3D point, Point3D Current, Entity entity) {
        int height = (int)Math.ceil(entity == null ? 1.0 : (double)entity.field_70131_O);
        Point3D unshifted = point.Unshift();
        Point3D currentUnshifted = Current.Unshift();
        boolean allBlocksAreValid = true;
        if (!PathFinder.isDiagonalMovement(point, Current)) {
            Block[] blocks = new Block[height];
            for (int i = 0; i < height; ++i) {
                Block block;
                blocks[i] = block = world.func_180495_p(new BlockPos(unshifted.x, unshifted.y + i, unshifted.z)).func_177230_c();
            }
            for (Block b : blocks) {
                boolean currentBlockValid = false;
                for (Block i : validBlockIDs) {
                    if (b != i) continue;
                    currentBlockValid = true;
                }
                allBlocksAreValid &= currentBlockValid;
            }
        } else {
            Block[] blocks = new Block[height * 4];
            for (int i = 0; i < height; i += 4) {
                Block block;
                int deltaX = unshifted.x - currentUnshifted.x;
                int deltaY = unshifted.y - currentUnshifted.y;
                int deltaZ = unshifted.z - currentUnshifted.z;
                blocks[i] = block = world.func_180495_p(new BlockPos(unshifted.x, unshifted.y + i, unshifted.z)).func_177230_c();
                blocks[i + 1] = block = world.func_180495_p(new BlockPos(unshifted.x + deltaX, unshifted.y + i, unshifted.z)).func_177230_c();
                blocks[i + 2] = block = world.func_180495_p(new BlockPos(unshifted.x, unshifted.y + i, unshifted.z + deltaZ)).func_177230_c();
                blocks[i + 3] = block = world.func_180495_p(new BlockPos(unshifted.x, unshifted.y + i + deltaY, unshifted.z)).func_177230_c();
            }
            for (Block b : blocks) {
                boolean currentBlockValid = false;
                for (Block i : validBlockIDs) {
                    if (b != i) continue;
                    currentBlockValid = true;
                }
                allBlocksAreValid &= currentBlockValid;
            }
        }
        return allBlocksAreValid;
    }

    private static boolean isDiagonalMovement(Point3D start, Point3D end) {
        boolean hasDeltaX = end.x - start.x != 0;
        boolean hasDeltaY = end.y - start.y != 0;
        boolean hasDeltaZ = end.z - start.z != 0;
        return hasDeltaX && hasDeltaY || hasDeltaX && hasDeltaZ || hasDeltaZ && hasDeltaY || hasDeltaX && hasDeltaY && hasDeltaZ;
    }
}

