/*
 * Decompiled with CFR 0.152.
 */
package am2.navigation;

import net.minecraft.util.math.BlockPos;

public class Point3D {
    public int x;
    public int y;
    public int z;
    private int offsetX;
    private int offsetY;
    private int offsetZ;

    public Point3D Unshift() {
        return new Point3D(this.x + this.offsetX, this.y + this.offsetY, this.z + this.offsetZ);
    }

    public int shiftX() {
        this.offsetX = this.x;
        this.x = 0;
        return this.offsetX;
    }

    public void shiftX(int offset) {
        this.offsetX = offset;
        this.x -= offset;
    }

    public int shiftY() {
        this.offsetY = this.y;
        this.y = 0;
        return this.offsetY;
    }

    public void shiftY(int offset) {
        this.offsetY = offset;
        this.y -= offset;
    }

    public int shiftZ() {
        this.offsetZ = this.z;
        this.z = 0;
        return this.offsetZ;
    }

    public void shiftZ(int offset) {
        this.offsetZ = offset;
        this.z -= offset;
    }

    public Point3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.offsetZ = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public Point3D(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Point3D setOffsets(int offsetX, int offsetY, int offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        return this;
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public double GetDistanceSq(Point3D point) {
        int dx = this.x - point.x;
        int dy = this.y - point.y;
        int dz = this.z - point.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Point3D add(Point3D point) {
        return new Point3D(this.x + point.x, this.y + point.y, this.z + point.z).setOffsets(this.offsetX, this.offsetY, this.offsetZ);
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Point3D) {
            Point3D p = (Point3D)o;
            if (this.x == p.x && this.y == p.y && this.z == p.z) {
                return true;
            }
        }
        return false;
    }

    public static Point3D fromDoubleCoordinates(double x, double y, double z) {
        return new Point3D((int)x, (int)y, (int)z);
    }
}

