/*
 * Decompiled with CFR 0.152.
 */
package am2.packet;

import am2.LogHelper;
import am2.api.power.IPowerNode;
import am2.blocks.tileentity.TileEntityArmorImbuer;
import am2.blocks.tileentity.TileEntityCalefactor;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.bosses.IArsMagicaBoss;
import am2.entity.EntityHecate;
import am2.packet.AMDataWriter;
import am2.packet.AMPacketProcessorServer;
import am2.power.PowerNodeRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AMNetHandler {
    private static final String ChannelLabel = "AM2DataTunnel";
    private static FMLEventChannel Channel;
    private boolean registeredChannels = false;
    public static final AMNetHandler INSTANCE;

    private AMNetHandler() {
    }

    public void init() {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelLabel);
    }

    public void registerChannels(AMPacketProcessorServer proc) {
        if (!this.registeredChannels) {
            this.registeredChannels = true;
            Channel.register((Object)proc);
            MinecraftForge.EVENT_BUS.register((Object)proc);
        } else {
            LogHelper.info("Redundant call to register channels.", new Object[0]);
        }
    }

    public void sendPacketToClientPlayer(EntityPlayerMP player, byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(Unpooled.copiedBuffer((byte[])pkt_data)), ChannelLabel);
        packet.setTarget(Side.CLIENT);
        Channel.sendTo(packet, player);
    }

    public void sendPacketToServer(byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(Unpooled.copiedBuffer((byte[])pkt_data)), ChannelLabel);
        packet.setTarget(Side.SERVER);
        Channel.sendToServer(packet);
    }

    public void sendPacketToAllClientsNear(int dimension, double ox, double oy, double oz, double radius, byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(Unpooled.copiedBuffer((byte[])pkt_data)), ChannelLabel);
        packet.setTarget(Side.CLIENT);
        Channel.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, ox, oy, oz, radius));
    }

    public void sendVelocityAddPacket(World world, EntityLivingBase target, double velX, double velY, double velZ) {
        if (world.field_72995_K) {
            return;
        }
        byte[] data = new AMDataWriter().add(target.func_145782_y()).add(velX).add(velY).add(velZ).generate();
        this.sendPacketToAllClientsNear(world.field_73011_w.getDimension(), target.field_70165_t, target.field_70163_u, target.field_70161_v, 50.0, (byte)7, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void requestAuras(EntityPlayer player) {
        AMDataWriter writer = new AMDataWriter();
        EntityPlayerSP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (localPlayer == null) {
            return;
        }
        writer.add(localPlayer.func_145782_y());
        writer.add(player.func_145782_y());
        this.sendPacketToServer((byte)31, writer.generate());
    }

    public void requestClientAuras(EntityPlayerMP player) {
        this.sendPacketToClientPlayer(player, (byte)17, new byte[0]);
    }

    public void syncWorldName(EntityPlayerMP player, String name) {
        this.sendPacketToClientPlayer(player, (byte)47, new AMDataWriter().add(name).generate());
    }

    public void syncLoginData(EntityPlayerMP player, byte[] data) {
        this.sendPacketToClientPlayer(player, (byte)42, data);
    }

    public void sendShapeGroupChangePacket(int newCastingMode, int entityid) {
        byte[] packetData = new AMDataWriter().add(newCastingMode).add(entityid).generate();
        this.sendPacketToServer((byte)1, packetData);
    }

    public <T extends EntityLivingBase> void sendActionUpdateToAllAround(T boss) {
        if (boss.field_70170_p != null && !boss.field_70170_p.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(boss.func_145782_y());
            writer.add(((IArsMagicaBoss)boss).getCurrentAction().ordinal());
            this.sendPacketToAllClientsNear(boss.field_70170_p.field_73011_w.getDimension(), boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 64.0, (byte)38, writer.generate());
        }
    }

    public void sendStarImpactToClients(double x, double y, double z, World world, ItemStack spellStack) {
        AMDataWriter writer = new AMDataWriter().add(x).add(y).add(z);
        if (spellStack != null) {
            writer.add(true).add(spellStack);
        } else {
            writer.add(false);
        }
        this.sendPacketToAllClientsNear(world.field_73011_w.getDimension(), x, y, z, 64.0, (byte)48, writer.generate());
    }

    public void sendSilverSkillPointPacket(EntityPlayerMP player) {
        this.sendPacketToClientPlayer(player, (byte)49, new byte[0]);
    }

    public void sendSpellApplyEffectToAllAround(EntityLivingBase caster, Entity target, double x, double y, double z, World world, ItemStack spellStack) {
        AMDataWriter writer = new AMDataWriter().add(x).add(y).add(z);
        if (spellStack != null) {
            writer.add(true).add(spellStack);
        } else {
            writer.add(false);
        }
        writer.add(caster.func_145782_y());
        writer.add(target.func_145782_y());
        this.sendPacketToAllClientsNear(world.field_73011_w.getDimension(), x, y, z, 64.0, (byte)44, writer.generate());
    }

    public void sendHecateDeathToAllAround(EntityHecate hecate) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(hecate.field_70165_t).add(hecate.field_70163_u).add(hecate.field_70161_v);
        this.sendPacketToAllClientsNear(hecate.field_70170_p.field_73011_w.getDimension(), hecate.field_70165_t, hecate.field_70163_u, hecate.field_70161_v, 32.0, (byte)50, writer.generate());
    }

    public void syncPowerPaths(IPowerNode<?> node, EntityPlayerMP player) {
        AMDataWriter writer = new AMDataWriter();
        if (((TileEntity)node).func_145831_w().field_72995_K) {
            writer.add((byte)0);
            writer.add(((TileEntity)node).func_145831_w().field_73011_w.getDimension());
            writer.add(((TileEntity)node).func_174877_v().func_177958_n());
            writer.add(((TileEntity)node).func_174877_v().func_177956_o());
            writer.add(((TileEntity)node).func_174877_v().func_177952_p());
            this.sendPacketToServer((byte)53, writer.generate());
        } else {
            NBTTagCompound compound = PowerNodeRegistry.For(((TileEntity)node).func_145831_w()).getDataCompoundForNode(node);
            if (compound != null) {
                writer.add((byte)0);
                writer.add(compound);
                this.sendPacketToClientPlayer(player, (byte)53, writer.generate());
            }
        }
    }

    public void sendImbueToServer(TileEntityArmorImbuer tileEntity, String hoveredID) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(tileEntity.func_174877_v().func_177958_n());
        writer.add(tileEntity.func_174877_v().func_177956_o());
        writer.add(tileEntity.func_174877_v().func_177952_p());
        writer.add(hoveredID);
        this.sendPacketToServer((byte)54, writer.generate());
    }

    public void sendPowerRequestToServer(Vec3d location) {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add((float)location.field_72450_a);
        writer.add((float)location.field_72448_b);
        writer.add((float)location.field_72449_c);
        this.sendPacketToServer((byte)53, writer.generate());
    }

    public void sendPowerResponseToClient(NBTTagCompound powerData, EntityPlayerMP player, TileEntity te) {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(powerData);
        writer.add(te.func_174877_v().func_177958_n());
        writer.add(te.func_174877_v().func_177956_o());
        writer.add(te.func_174877_v().func_177952_p());
        this.sendPacketToClientPlayer(player, (byte)53, writer.generate());
    }

    public void sendCapabilityChangePacket(EntityPlayerMP player, int capability, boolean state) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(capability);
        writer.add(state);
        this.sendPacketToClientPlayer(player, (byte)55, writer.generate());
    }

    public void sendExPropCommandToServer(int flag) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(flag);
        this.sendPacketToServer((byte)16, writer.generate());
    }

    public void sendCompendiumUnlockPacket(EntityPlayerMP player, String id, boolean isCategory) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(id);
        writer.add(isCategory);
        this.sendPacketToClientPlayer(player, (byte)46, writer.generate());
    }

    public void sendCalefactorCookUpdate(TileEntityCalefactor calefactor, byte[] data) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(calefactor.func_174877_v().func_177958_n());
        writer.add(calefactor.func_174877_v().func_177956_o());
        writer.add(calefactor.func_174877_v().func_177952_p());
        writer.add(data);
        this.sendPacketToAllClientsNear(calefactor.func_145831_w().field_73011_w.getDimension(), calefactor.func_174877_v().func_177958_n(), calefactor.func_174877_v().func_177956_o(), calefactor.func_174877_v().func_177952_p(), 32.0, (byte)57, writer.generate());
    }

    public void sendObeliskUpdate(TileEntityObelisk obelisk, byte[] data) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(obelisk.func_174877_v().func_177958_n());
        writer.add(obelisk.func_174877_v().func_177956_o());
        writer.add(obelisk.func_174877_v().func_177952_p());
        writer.add(data);
        this.sendPacketToAllClientsNear(obelisk.func_145831_w().field_73011_w.getDimension(), obelisk.func_174877_v().func_177958_n(), obelisk.func_174877_v().func_177956_o(), obelisk.func_174877_v().func_177952_p(), 32.0, (byte)58, writer.generate());
    }

    public void sendAffinityActivate() {
        this.sendPacketToServer((byte)59, new byte[0]);
    }

    public void sendAbilityToggle(String str) {
        this.sendPacketToServer((byte)64, new AMDataWriter().add(str).generate());
    }

    static {
        INSTANCE = new AMNetHandler();
    }
}

