/*
 * Decompiled with CFR 0.152.
 */
package am2.packet;

import am2.LogHelper;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.blocks.tileentity.TileEntityArmorImbuer;
import am2.blocks.tileentity.TileEntityInscriptionTable;
import am2.blocks.tileentity.TileEntityParticleEmitter;
import am2.container.ContainerSpellCustomization;
import am2.defs.ItemDefs;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import am2.extensions.SkillData;
import am2.items.ItemSpellBook;
import am2.lore.ArcaneCompendium;
import am2.packet.AMDataReader;
import am2.packet.AMNetHandler;
import am2.power.PowerNodeRegistry;
import am2.utils.SpellUtils;
import io.netty.buffer.ByteBufInputStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AMPacketProcessorServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void onServerPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBufInputStream bbis = new ByteBufInputStream(event.getPacket().payload());
        int packetID = -1;
        try {
            if (event.getPacket().getTarget() != Side.SERVER) {
                return;
            }
            packetID = bbis.readByte();
            NetHandlerPlayServer srv = (NetHandlerPlayServer)event.getPacket().handler();
            EntityPlayerMP player = srv.field_147369_b;
            byte[] remaining = new byte[bbis.available()];
            bbis.readFully(remaining);
            switch (packetID) {
                case 1: {
                    this.handleCastingModeChange(remaining, player);
                    return;
                }
                case 32: {
                    this.handleSpellCustomize(remaining, player);
                    return;
                }
                case 14: {
                    this.handleSpellBookChangeActiveSlot(remaining, player);
                    return;
                }
                case 35: {
                    this.handleDecoBlockUpdate(remaining, player);
                    return;
                }
                case 36: {
                    this.handleInscriptionTableUpdate(remaining, player);
                    return;
                }
                case 39: {
                    float TK_Distance = new AMDataReader(remaining, false).getFloat();
                    EntityExtension.For((EntityLivingBase)player).setTKDistance(TK_Distance);
                    return;
                }
                case 54: {
                    this.handleImbueArmor(remaining, player);
                    return;
                }
                case 53: {
                    this.handlePowerPathSync(remaining, player);
                    return;
                }
                case 61: {
                    this.handlePlayerFlip(remaining, player);
                    return;
                }
                case 63: {
                    this.handleOcculusUnlock(remaining, player);
                    return;
                }
                case 64: {
                    this.handleAbilityToggle(remaining, player);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            LogHelper.error("Server Packet Failed to Handle!", new Object[0]);
            LogHelper.error("Packet Type: " + packetID, new Object[0]);
            t.printStackTrace();
            return;
        }
        finally {
            try {
                if (bbis != null) {
                    bbis.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void handleAbilityToggle(byte[] remaining, EntityPlayerMP player) {
        AMDataReader reader = new AMDataReader(remaining, false);
        String str = reader.getString();
        boolean newState = !AffinityData.For((EntityLivingBase)player).getAbilityBoolean(str);
        String text = String.format(I18n.func_74838_a((String)"am2.chat.activation"), I18n.func_74838_a((String)("am2.chat.ability_" + str)), I18n.func_74838_a((String)(newState ? "am2.chat.enabled" : "am2.chat.disabled")));
        player.func_146105_b((ITextComponent)new TextComponentString(text));
        AffinityData.For((EntityLivingBase)player).addAbilityBoolean(str, newState);
    }

    private void handleOcculusUnlock(byte[] remaining, EntityPlayerMP player) {
        String str = new AMDataReader(remaining, false).getString();
        SkillData.For((EntityLivingBase)player).unlockSkill(str);
        ArcaneCompendium.For((EntityPlayer)player).unlockEntry(str);
    }

    private void handlePlayerFlip(byte[] remaining, EntityPlayerMP player) {
        EntityExtension.For((EntityLivingBase)player).setInverted(new AMDataReader(remaining, false).getBoolean());
    }

    private void handlePowerPathSync(byte[] data, EntityPlayerMP player) {
        AMVector3 loc;
        TileEntity te;
        AMDataReader rdr = new AMDataReader(data, false);
        byte nom = rdr.getByte();
        if (nom == 1 && (te = player.field_70170_p.func_175625_s((loc = new AMVector3(rdr.getFloat(), rdr.getFloat(), rdr.getFloat())).toBlockPos())) != null && te instanceof IPowerNode) {
            AMNetHandler.INSTANCE.sendPowerResponseToClient(PowerNodeRegistry.For(player.field_70170_p).getDataCompoundForNode((IPowerNode)te), player, te);
        }
    }

    private void handleImbueArmor(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te != null && te instanceof TileEntityArmorImbuer) {
            ((TileEntityArmorImbuer)te).imbueCurrentArmor(new ResourceLocation(rdr.getString()));
        }
    }

    private void handleInscriptionTableUpdate(byte[] data, EntityPlayerMP player) {
        World world = player.field_70170_p;
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = world.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te == null || !(te instanceof TileEntityInscriptionTable)) {
            return;
        }
        ((TileEntityInscriptionTable)te).HandleUpdatePacket(rdr.getRemainingBytes());
        world.markAndNotifyBlock(te.func_174877_v(), te.func_145831_w().func_175726_f(te.func_174877_v()), te.func_145831_w().func_180495_p(te.func_174877_v()), te.func_145831_w().func_180495_p(te.func_174877_v()), 3);
    }

    private void handleDecoBlockUpdate(byte[] data, EntityPlayerMP player) {
        World world = player.field_70170_p;
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = world.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te == null || !(te instanceof TileEntityParticleEmitter)) {
            return;
        }
        ((TileEntityParticleEmitter)te).func_145839_a(rdr.getNBTTagCompound());
        world.markAndNotifyBlock(te.func_174877_v(), world.func_175726_f(te.func_174877_v()), world.func_180495_p(te.func_174877_v()), world.func_180495_p(te.func_174877_v()), 2);
    }

    private void handleSpellBookChangeActiveSlot(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte subID = rdr.getByte();
        rdr.getInt();
        int inventorySlot = rdr.getInt();
        ItemStack stack = player.field_71071_by.func_70301_a(inventorySlot);
        if (stack == null || !(stack.func_77973_b() instanceof ItemSpellBook)) {
            return;
        }
        if (subID == 0) {
            ItemDefs.spellBook.SetNextSlot(stack);
        } else if (subID == 1) {
            ItemDefs.spellBook.SetPrevSlot(stack);
        } else {
            return;
        }
    }

    private void handleSpellCustomize(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        if (player == null) {
            return;
        }
        int IIconIndex = rdr.getInt();
        String name = rdr.getString();
        if (player.field_71070_bA instanceof ContainerSpellCustomization) {
            ((ContainerSpellCustomization)player.field_71070_bA).setNameAndIndex(name, IIconIndex);
        }
    }

    private void handleCastingModeChange(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int newShapeGroupOrdinal = rdr.getInt();
        int index = rdr.getInt();
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (stack != null) {
            if (stack.func_77973_b() == ItemDefs.spell) {
                SpellUtils.setShapeGroup(stack, newShapeGroupOrdinal);
            } else if (stack.func_77973_b() == ItemDefs.spellBook || stack.func_77973_b() == ItemDefs.arcaneSpellbook) {
                ItemStack spellStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack);
                SpellUtils.setShapeGroup(spellStack, newShapeGroupOrdinal);
                ((ItemSpellBook)stack.func_77973_b()).replaceAciveItemStack(stack, spellStack);
            }
        }
    }

    public EntityLivingBase getEntityByID(int entityID) {
        for (EntityLivingBase ent : FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_175644_a(EntityLivingBase.class, EntitySelectors.field_180132_d)) {
            if (ent.func_145782_y() != entityID) continue;
            return ent;
        }
        return null;
    }
}

