/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.ArsMagica2;
import am2.api.particles.IBeamParticle;
import am2.particles.AMParticleIcons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AMBeam
extends Particle
implements IBeamParticle {
    int type = 0;
    double dX;
    double dY;
    double dZ;
    double updateX;
    double updateY;
    double updateZ;
    private float yaw;
    private float pitch;
    private float prevYaw;
    private float prevPitch;
    private float rotateSpeed = 5.0f;
    private float length;
    private final float endMod = 1.0f;
    private int maxLengthAge = 10;
    private boolean positionChanged = false;
    private boolean fppc = false;

    public AMBeam(World world, double x, double y, double z, double destX, double destY, double destZ) {
        this(world, x, y, z, destX, destY, destZ, 0);
    }

    public AMBeam(World world, double x, double y, double z, double destX, double destY, double destZ, int color) {
        super(world, x, y, z);
        this.dX = destX;
        this.dY = destY;
        this.dZ = destZ;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.func_187115_a(0.2f, 0.2f);
        this.calculateLengthAndRotation();
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.rotateSpeed = 30.0f;
        this.maxLengthAge = 10;
        this.field_70547_e = 10;
    }

    public AMBeam setInstantSpawn() {
        this.maxLengthAge = 1;
        return this;
    }

    public void func_187114_a(int maxAge) {
        this.field_70547_e = maxAge;
    }

    private void calculateLengthAndRotation() {
        float deltaX = (float)(this.field_187126_f - this.dX);
        float deltaY = (float)(this.field_187127_g - this.dY);
        float deltaZ = (float)(this.field_187128_h - this.dZ);
        this.length = MathHelper.func_76129_c((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        double hDist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        this.yaw = (float)(Math.atan2(deltaX, deltaZ) * 180.0 / Math.PI);
        this.pitch = (float)(Math.atan2(deltaY, hDist) * 180.0 / Math.PI);
    }

    public void setBeamLocationAndTarget(double posX, double posY, double posZ, double targetX, double targetY, double targetZ) {
        this.updateX = posX;
        this.updateY = posY;
        this.updateZ = posZ;
        this.dX = targetX;
        this.dY = targetY;
        this.dZ = targetZ;
        if (this.field_70546_d > this.field_70547_e - 5) {
            this.field_70547_e = this.field_70546_d + 5;
        }
        this.positionChanged = true;
    }

    private void storePrevInformation() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.positionChanged) {
            EntityPlayerSP player;
            this.field_187126_f = this.updateX;
            this.field_187127_g = this.updateY;
            this.field_187128_h = this.updateZ;
            if (this.fppc && (player = Minecraft.func_71410_x().field_71439_g) != null) {
                float yaw = player.field_70177_z;
                float rotationYaw = (float)((double)yaw * Math.PI / 180.0);
                float offsetX = (float)Math.cos(rotationYaw) * 0.06f;
                float offsetZ = (float)Math.sin(rotationYaw) * 0.06f;
                this.field_187126_f -= (double)offsetX;
                this.field_187128_h -= (double)offsetZ;
                this.field_187127_g += (double)0.06f;
                this.field_187123_c = this.field_187126_f;
                this.field_187124_d = this.field_187127_g;
                this.field_187125_e = this.field_187128_h;
            }
            this.positionChanged = false;
        }
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
    }

    @Override
    public void setFirstPersonPlayerCast() {
        this.fppc = true;
    }

    private void handleAging() {
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public void func_189213_a() {
        this.storePrevInformation();
        this.calculateLengthAndRotation();
        this.handleAging();
    }

    public int func_70537_b() {
        return 2;
    }

    public void func_180434_a(VertexBuffer tessellator, Entity ent, float par2, float par3, float par4, float par5, float par6, float par7) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float scaleFactor = 1.0f;
        float rot = (float)this.field_187122_b.field_73011_w.getWorldTime() % (360.0f / this.rotateSpeed) * this.rotateSpeed + this.rotateSpeed * par2;
        float size = (float)this.field_70546_d / (float)this.maxLengthAge;
        if (size > 1.0f) {
            size = 1.0f;
        }
        float op = 0.4f;
        float widthMod = 1.0f;
        TextureAtlasSprite beamIcon = null;
        switch (this.type) {
            default: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam");
                break;
            }
            case 1: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam1");
                break;
            }
            case 2: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam2");
            }
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        float xx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)par2 - field_70556_an);
        float yy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)par2 - field_70554_ao);
        float zz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)par2 - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        if (this.fppc) {
            widthMod = 0.3f;
        }
        float deltaYaw = Math.abs(this.yaw) - Math.abs(this.prevYaw);
        float ry = this.prevYaw + deltaYaw * par2;
        float rp = this.prevPitch + (this.pitch - this.prevPitch) * par2;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double offset1 = -0.15 * (double)widthMod * (double)size;
        double offset2 = 0.15 * (double)widthMod * (double)size;
        double d = -0.15 * (double)widthMod * (double)size;
        this.getClass();
        double offset3 = d * 1.0;
        double d2 = 0.15 * (double)widthMod * (double)size;
        this.getClass();
        double offset4 = d2 * 1.0;
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = 5;
        float inc = 36.0f;
        if (ArsMagica2.config.LowGFX()) {
            i = 3;
            inc = 90.0f;
        } else if (ArsMagica2.config.NoGFX()) {
            i = 1;
            inc = 180.0f;
        }
        for (int t = 0; t < i; ++t) {
            Tessellator.func_178181_a().func_78381_a();
            tessellator.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            double l = this.length * size * scaleFactor;
            double tl = beamIcon.func_94209_e();
            double br = beamIcon.func_94212_f();
            double mU = beamIcon.func_94210_h();
            double mV = beamIcon.func_94206_g();
            GL11.glRotatef((float)inc, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179117_G();
            int b = this.func_189214_a(par7);
            int j = b >> 16 & 0xFFFF;
            int k = b & 0xFFFF;
            tessellator.func_181662_b(offset3, l, 0.0).func_187315_a(br, mV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_187314_a(j, k).func_181675_d();
            tessellator.func_181662_b(offset1, 0.0, 0.0).func_187315_a(br, mU).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_187314_a(j, k).func_181675_d();
            tessellator.func_181662_b(offset2, 0.0, 0.0).func_187315_a(tl, mU).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_187314_a(j, k).func_181675_d();
            tessellator.func_181662_b(offset4, l, 0.0).func_187315_a(tl, mV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op).func_187314_a(j, k).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            tessellator.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void setRGBColorF(float r, float g, float b) {
        this.field_70553_i = g;
        this.field_70552_h = r;
        this.field_70551_j = b;
    }

    @Override
    public void setRGBColor(int color) {
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
    }

    @Override
    public void setRGBColorI(int r, int g, int b) {
        this.field_70552_h = (float)r / 255.0f;
        this.field_70553_i = (float)g / 255.0f;
        this.field_70551_j = (float)b / 255.0f;
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public double getPosZ() {
        return this.field_187128_h;
    }
}

