/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AMParticleIcons {
    public static final AMParticleIcons instance = new AMParticleIcons();
    private final HashMap<String, TextureAtlasSprite> icons;
    private final HashMap<String, TextureAtlasSprite> hiddenIcons;
    private static final Random rand = new Random();

    private AMParticleIcons() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.icons = new HashMap();
        this.hiddenIcons = new HashMap();
    }

    public int numParticles() {
        return this.icons.size();
    }

    @SubscribeEvent
    public void init(TextureStitchEvent.Pre e) {
        int i;
        this.icons.clear();
        TextureMap textureMap = e.getMap();
        this.loadAndInitIcon("arcane", "arcane", textureMap);
        this.loadAndInitIcon("clock", "clock", textureMap);
        this.loadAndInitIcon("ember", "ember", textureMap);
        this.loadAndInitIcon("explosion_2", "explosion_2", textureMap);
        this.loadAndInitIcon("ghost", "ghost", textureMap);
        this.loadAndInitIcon("heart", "heart", textureMap);
        this.loadAndInitIcon("leaf", "leaf", textureMap);
        this.loadAndInitIcon("lens_flare", "lens_flare", textureMap);
        this.loadAndInitIcon("lights", "lights", textureMap);
        this.loadAndInitIcon("plant", "plant", textureMap);
        this.loadAndInitIcon("pulse", "pulse", textureMap);
        this.loadAndInitIcon("rock", "rock", textureMap);
        this.loadAndInitIcon("rotating_rings", "rotating_rings", textureMap);
        this.loadAndInitIcon("smoke", "smoke", textureMap);
        this.loadAndInitIcon("sparkle", "sparkle", textureMap);
        this.loadAndInitIcon("sparkle2", "sparkle2", textureMap);
        this.loadAndInitIcon("water_ball", "water_ball", textureMap);
        this.loadAndInitIcon("wind", "wind", textureMap);
        this.loadAndInitIcon("air_hand", "air_hand", textureMap);
        this.loadAndInitIcon("arcane_hand", "arcane_hand", textureMap);
        this.loadAndInitIcon("earth_hand", "earth_hand", textureMap);
        this.loadAndInitIcon("ender_hand", "ender_hand", textureMap);
        this.loadAndInitIcon("fire_hand", "fire_hand", textureMap);
        this.loadAndInitIcon("ice_hand", "ice_hand", textureMap);
        this.loadAndInitIcon("life_hand", "life_hand", textureMap);
        this.loadAndInitIcon("lightning_hand", "lightning_hand", textureMap);
        this.loadAndInitIcon("nature_hand", "nature_hand", textureMap);
        this.loadAndInitIcon("none_hand", "none_hand", textureMap);
        this.loadAndInitIcon("water_hand", "water_hand", textureMap);
        this.loadAndInitIcon("beam", "beam", textureMap, false);
        this.loadAndInitIcon("beam1", "beam1", textureMap, false);
        this.loadAndInitIcon("beam2", "beam2", textureMap, false);
        for (i = 1; i <= 28; ++i) {
            this.loadAndInitIcon("Symbols" + i, "symbols/Symbols" + i, textureMap, false);
        }
        for (i = 1; i <= 9; ++i) {
            this.loadAndInitIcon("snowflake" + i, "snowflakes/snowflake" + i, textureMap, false);
        }
        this.icons.put("symbols", null);
        this.icons.put("snowflakes", null);
        AMParticle.particleTypes = this.icons.keySet().toArray(new String[this.icons.size() + 1]);
        AMParticle.particleTypes[AMParticle.particleTypes.length - 1] = "radiant";
    }

    private void loadAndInitIcon(String name, String TextureAtlasSpritePath, TextureMap register) {
        this.loadAndInitIcon(name, TextureAtlasSpritePath, register, true);
    }

    private void loadAndInitIcon(String name, String TextureAtlasSpritePath, TextureMap register, boolean registerName) {
        register.func_174942_a(new ResourceLocation("arsmagica2:items/particles/" + TextureAtlasSpritePath));
        TextureAtlasSprite icon = register.getTextureExtry(new ResourceLocation("arsmagica2:items/particles/" + TextureAtlasSpritePath).toString());
        if (registerName) {
            if (icon != null) {
                this.icons.put(name, icon);
            }
        } else if (icon != null) {
            this.hiddenIcons.put(name, icon);
        }
    }

    public void RegisterIcon(String name, TextureAtlasSprite TextureAtlasSprite2) {
        this.icons.put(name, TextureAtlasSprite2);
    }

    public TextureAtlasSprite getIconByName(String name) {
        TextureAtlasSprite icon = null;
        icon = name.equals("symbols") ? this.hiddenIcons.get("Symbols" + (rand.nextInt(28) + 1)) : (name.equals("snowflakes") ? this.hiddenIcons.get("snowflake" + (rand.nextInt(9) + 1)) : this.icons.get(name));
        if (icon == null) {
            return this.icons.get("lights");
        }
        return icon;
    }

    public TextureAtlasSprite getHiddenIconByName(String name) {
        TextureAtlasSprite icon = this.hiddenIcons.get(name);
        if (icon == null) {
            return this.icons.get("lights");
        }
        return icon;
    }
}

