/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;

public class ParticleConverge
extends ParticleController {
    private final double originX;
    private final double originY;
    private final double originZ;
    private final double motionX;
    private final double motionY;
    private final double motionZ;

    public ParticleConverge(AMParticle particleEffect, double motionX, double motionY, double motionZ, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        particleEffect.setNoVelocityUpdates();
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        this.originX = particleEffect.getPosX();
        this.originY = particleEffect.getPosY();
        this.originZ = particleEffect.getPosZ();
    }

    @Override
    public void doUpdate() {
        this.particle.pushPos();
        int maxAge = this.particle.GetParticleMaxAge();
        if (maxAge == 0) {
            maxAge = 1;
        }
        float ageFactor = (float)this.particle.GetParticleAge() / (float)maxAge;
        ageFactor = 1.0f - ageFactor;
        float verticalAgeFactor = 1.0f - ageFactor;
        verticalAgeFactor *= verticalAgeFactor;
        verticalAgeFactor *= verticalAgeFactor;
        this.particle.func_187109_b(this.originX + this.motionX * (double)ageFactor, this.originY + this.motionY * (double)ageFactor - (double)(verticalAgeFactor * 1.2f), this.originZ + this.motionZ * (double)ageFactor);
    }

    @Override
    public ParticleController clone() {
        return new ParticleConverge(this.particle, this.motionX, this.motionY, this.motionZ, this.priority, this.exclusive);
    }
}

