/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;

public class ParticleFleeEntity
extends ParticleController {
    private Entity target;
    private double fleeSpeed;
    private double targetDistance;

    public ParticleFleeEntity(AMParticle particleEffect, Entity fleeEntity, double fleeSpeed, double targetDistance, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.target = fleeEntity;
        this.fleeSpeed = fleeSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        double posY = this.particle.getPosY();
        double distanceToTarget = this.target.func_70011_f(this.particle.getPosX(), this.particle.getPosY(), this.particle.getPosZ());
        double deltaZ = this.particle.getPosZ() - this.target.field_70161_v;
        double deltaX = this.particle.getPosX() - this.target.field_70165_t;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.getPosX() + this.fleeSpeed * Math.cos(radians);
        double posZ = this.particle.getPosZ() + this.fleeSpeed * Math.sin(radians);
        if (this.target instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.target;
            deltaY = posY - (entityliving.field_70163_u + (double)entityliving.func_70047_e());
        } else {
            deltaY = (this.target.func_174813_aQ().field_72338_b + this.target.func_174813_aQ().field_72337_e) / 2.0 - posY;
        }
        double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.getPosY() + this.fleeSpeed * Math.sin(pitchRadians);
        if (distanceToTarget > this.targetDistance) {
            this.finish();
        } else {
            this.particle.func_187109_b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleController clone() {
        return new ParticleFleeEntity(this.particle, this.target, this.fleeSpeed, this.targetDistance, this.priority, this.exclusive);
    }
}

