/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.ArsMagica2;
import am2.codechicken.LightningBolt;
import am2.defs.PotionEffectsDefs;
import am2.packet.AMDataReader;
import am2.particles.AMBeam;
import am2.particles.AMLineArc;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToEntity;
import am2.particles.ParticleArcToPoint;
import am2.particles.ParticleController;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFleeEntity;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleManagerServer;
import am2.particles.ParticleMoveOnHeading;
import am2.particles.ParticleOrbitEntity;
import am2.particles.ParticleOrbitPoint;
import am2.particles.ParticleRenderer;
import am2.particles.ribbon.AMRibbon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ParticleManagerClient
extends ParticleManagerServer {
    public static final byte PKT_BOLT_ENT_ENT = 64;
    public static final byte PKT_BOLT_PT_PT = 63;
    public static final byte PKT_BEAM_ENT_ENT = 62;
    public static final byte PKT_BEAM_PT_PT = 61;
    private final ParticleRenderer particleRenderer = new ParticleRenderer();

    public AMParticle spawn(World world, String name, double x, double y, double z) {
        AMParticle particle = new AMParticle(world, x, y, z);
        particle.SetParticleTextureByName(name);
        this.particleRenderer.addAMParticle(particle);
        return particle;
    }

    public AMLineArc spawn(World world, String name, double x, double y, double z, double targetX, double targetY, double targetZ) {
        AMLineArc arc = new AMLineArc(world, x, y, z, targetX, targetY, targetZ, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public AMLineArc spawn(World world, String name, double x, double y, double z, Entity target) {
        AMLineArc arc = new AMLineArc(world, x, y, z, target, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public AMLineArc spawn(World world, String name, Entity source, Entity target) {
        AMLineArc arc = new AMLineArc(world, source, target, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this.particleRenderer);
    }

    @Override
    public void BoltFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int type, int color) {
        double xx = target.field_70165_t;
        double zz = target.field_70161_v;
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        Vec3d vec3d = source.func_70040_Z().func_72432_b();
        LightningBolt bolt = new LightningBolt(world, px += vec3d.field_72450_a * 0.25, py += vec3d.field_72448_b * 0.25, pz += vec3d.field_72449_c * 0.25, xx, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f), zz, world.field_73012_v.nextLong(), 6, 0.3f, 6);
        bolt.defaultFractal();
        bolt.setSourceEntity(caster);
        bolt.setType(type);
        bolt.setDamage(0);
        bolt.setOverrideColor(color);
        bolt.finalizeBolt();
    }

    @Override
    public void BoltFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1, -1);
    }

    @Override
    public void BoltFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        this.BoltFromEntityToPoint(world, source, endX, endY, endZ, 0, -1);
    }

    @Override
    public void BoltFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int type, int color) {
        this.BoltFromPointToPoint(world, source.field_70165_t, source.field_70163_u + (double)source.func_70047_e(), source.field_70161_v, endX, endY, endZ, type, color);
    }

    @Override
    public void BoltFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        this.BoltFromEntityToEntity(world, caster, source, target, damage, 1, -1);
    }

    @Override
    public void BoltFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int type, int color) {
        if (ArsMagica2.config.NoGFX()) {
            return;
        }
        LightningBolt bolt = new LightningBolt(world, startX, startY, startZ, endX, endY, endZ, world.field_73012_v.nextLong(), 6, 0.3f, 6);
        bolt.defaultFractal();
        bolt.setSourceEntity(null);
        bolt.setType(type);
        bolt.setDamage(0);
        bolt.finalizeBolt();
    }

    @Override
    public Object BeamFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int color) {
        double xx = target.field_70165_t;
        double zz = target.field_70161_v;
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        Vec3d vec3d = source.func_70040_Z().func_72432_b();
        AMBeam fx = new AMBeam(world, px += vec3d.field_72450_a * 0.25, py += vec3d.field_72448_b * 0.25, pz += vec3d.field_72449_c * 0.25, xx, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f), zz);
        fx.setRGBColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        return fx;
    }

    @Override
    public Object BeamFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int color) {
        if (ArsMagica2.config.NoGFX()) {
            return null;
        }
        AMBeam fx = new AMBeam(world, startX, startY, startZ, endX, endY, endZ);
        fx.setRGBColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        return fx;
    }

    @Override
    public Object BeamFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return this.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 0xFFFFFF);
    }

    @Override
    public Object BeamFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        return this.BeamFromEntityToPoint(world, source, endX, endY, endZ, 0xFFFFFF);
    }

    @Override
    public Object BeamFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int color) {
        if (!(source instanceof EntityPlayer) || source == Minecraft.func_71410_x().field_71439_g) {
            return this.BeamFromPointToPoint(world, source.field_70165_t, source.field_70163_u, source.field_70161_v, endX, endY, endZ, color);
        }
        return this.BeamFromPointToPoint(world, source.field_70165_t, source.field_70163_u + (double)source.func_70047_e() - (double)0.2f, source.field_70161_v, endX, endY, endZ, color);
    }

    @Override
    public Object BeamFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        return this.BeamFromEntityToEntity(world, caster, source, target, damage, 0xFFFFFF);
    }

    @Override
    public void RibbonFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int type) {
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        Vec3d vec3d = source.func_70040_Z().func_72432_b();
        AMRibbon ribbon = new AMRibbon(world, 0.5f, 0.05f, px += vec3d.field_72450_a * 0.25, py += vec3d.field_72448_b * 0.25, pz += vec3d.field_72449_c * 0.25);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ribbon);
    }

    @Override
    public void RibbonFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.RibbonFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1);
    }

    @Override
    public void RibbonFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        this.RibbonFromEntityToPoint(world, source, endX, endY, endZ, 0);
    }

    @Override
    public void RibbonFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int type) {
        this.RibbonFromPointToPoint(world, source.field_70165_t, source.field_70163_u, source.field_70161_v, endX, endY, endZ, 0);
    }

    @Override
    public void RibbonFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        this.RibbonFromEntityToEntity(world, caster, source, target, damage, 1);
    }

    @Override
    public void RibbonFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int type) {
        if (ArsMagica2.config.NoGFX()) {
            return;
        }
        AMRibbon ribbon = new AMRibbon(world, 0.5f, 0.05f, startX, startY, startZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ribbon);
    }

    @Override
    public void handleClientPacketData(World world, byte[] data) {
        AMDataReader rdr = new AMDataReader(data);
        byte sub_id = rdr.getByte();
        int type = 1;
        switch (sub_id) {
            case 64: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                int color = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.BoltFromEntityToEntity(world, caster, source, target, damage, type, color);
                break;
            }
            case 63: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                int color = rdr.getInt();
                this.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type, color);
                break;
            }
            case 62: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.BeamFromEntityToEntity(world, caster, source, target, damage, type);
                break;
            }
            case 61: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                this.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type);
                break;
            }
            case 59: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                this.RibbonFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type);
                break;
            }
            case 60: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.RibbonFromEntityToEntity(world, caster, source, target, damage, type);
                break;
            }
            case 58: {
                String name = rdr.getString();
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                this.spawn(world, name, startX, startY, startZ, endX, endY, endZ);
                break;
            }
            case 57: {
                String name = rdr.getString();
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                int targetID = rdr.getInt();
                Entity target = world.func_73045_a(targetID);
                if (target == null) {
                    return;
                }
                this.spawn(world, name, startX, startY, startZ, target);
                break;
            }
            case 56: {
                String name = rdr.getString();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (source == null || target == null) {
                    return;
                }
                this.spawn(world, name, source, target);
            }
        }
    }

    @Override
    public void spawnBuffParticles(EntityLivingBase entityliving) {
        World world = entityliving.field_70170_p;
        if (!world.field_72995_K) {
            return;
        }
        if (entityliving == Minecraft.func_71410_x().field_71439_g) {
            if (entityliving.func_70644_a(PotionEffectsDefs.trueSight) && entityliving.field_70173_aa % 20 == 0) {
                int radius = 5;
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            AMParticle effect;
                            if (!entityliving.field_70170_p.func_175623_d(entityliving.func_180425_c().func_177982_a(i, j, k)) || entityliving.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, entityliving.func_180425_c().func_177982_a(i, j, k)) > 7 || (effect = this.spawn(world, "hr_sparkles_1", (double)((int)entityliving.field_70165_t - 1 + i) + world.field_73012_v.nextDouble() * 3.0, (double)((int)entityliving.field_70163_u - 1 + j) + world.field_73012_v.nextDouble() * 3.0, (double)((int)entityliving.field_70161_v - 1 + k) + world.field_73012_v.nextDouble() * 3.0)) == null) continue;
                            effect.setRGBColorF(world.field_73012_v.nextFloat() * 0.4f + 0.3f, 0.6f, world.field_73012_v.nextFloat() * 0.4f + 0.6f);
                            effect.setIgnoreMaxAge(false);
                            effect.func_187114_a(40);
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.01f, 0.01f, 1, false));
                            effect.AddParticleController(new ParticleFadeOut(effect, 2, false).setFadeSpeed(0.01f));
                        }
                    }
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                return;
            }
        }
    }

    @Override
    public ParticleController createDefaultParticleController(int type, Object eff, Vec3d location, float modifier, int meta) {
        AMParticle effect = (AMParticle)((Object)eff);
        switch (type) {
            default: {
                return new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.02f * modifier);
            }
            case 1: {
                return new ParticleFloatUpward(effect, 0.01f, 0.03f * modifier, 1, false);
            }
            case 2: {
                return new ParticleFloatUpward(effect, 0.01f, -0.03f * modifier, 1, false);
            }
            case 3: {
                return new ParticleOrbitPoint(effect, location.field_72450_a, location.field_72448_b, location.field_72449_c, 1, false).SetOrbitSpeed(0.05f * modifier);
            }
            case 4: {
                return new ParticleArcToPoint(effect, 1, location.field_72450_a, location.field_72448_b, location.field_72449_c, false).generateControlPoints().SetSpeed(0.02f * modifier);
            }
            case 5: {
                return new ParticleMoveOnHeading(effect, effect.getWorldObj().field_73012_v.nextInt(360), 0.0, 0.02f * modifier, 1, false);
            }
            case 6: 
        }
        if ((meta & 0xFFFFFFF7) == 3) {
            meta &= 0xFFFFFFFD;
        } else if ((meta & 0xFFFFFFF7) == 1) {
            meta |= 2;
        }
        return new ParticleMoveOnHeading(effect, (meta & 0xFFFFFFF7) * 90, 0.0, 0.02f * modifier, 1, false);
    }

    @Override
    public ParticleController createDefaultParticleController(int type, Object eff, EntityLivingBase ent) {
        AMParticle effect = (AMParticle)((Object)eff);
        switch (type) {
            default: {
                return new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.02f);
            }
            case 1: {
                return new ParticleFloatUpward(effect, 0.2f, 0.03f, 1, false);
            }
            case 2: {
                return new ParticleFloatUpward(effect, 0.2f, -0.03f, 1, false);
            }
            case 3: {
                return new ParticleOrbitEntity(effect, (Entity)ent, 0.05f, 1, false);
            }
            case 4: {
                return new ParticleArcToEntity(effect, 1, (Entity)ent, false).generateControlPoints();
            }
            case 5: {
                return new ParticleFleeEntity(effect, (Entity)ent, 0.05f, 2.0, 1, false);
            }
            case 6: 
        }
        return new ParticleMoveOnHeading(effect, ent.field_70177_z + 90.0f, ent.field_70125_A, 0.05f, 1, false);
    }
}

