/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.ArsMagica2;
import am2.LogHelper;
import am2.power.PowerNodeRegistry;
import am2.power.RegionCoordinates;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PowerNodeCache {
    public static String extension = ".amc";
    public static String folder = "AM2PowerData";
    private static final String pndID = "pnd_%d_%d";
    private static HashMap<Integer, File> saveDirs = new HashMap();
    private static HashMap<String, File> saveFilesCached = new HashMap();
    private static HashMap<RegionCoordinates, NBTTagCompound> dataCache = new HashMap();
    public static final PowerNodeCache instance = new PowerNodeCache();

    private File getFileFromChunk(World world, ChunkPos chunk, boolean createNew) {
        File saveFolder = saveDirs.get(world.field_73011_w.getDimension());
        if (saveFolder == null) {
            ISaveHandler handler = world.func_72860_G();
            if (handler instanceof SaveHandler) {
                saveFolder = new File(((SaveHandler)handler).func_75765_b(), folder);
                saveFolder.mkdirs();
                saveFolder = new File(saveFolder, String.format("DIM%d", world.field_73011_w.getDimension()));
                saveFolder.mkdirs();
                saveDirs.put(world.field_73011_w.getDimension(), saveFolder);
            } else {
                return null;
            }
        }
        int rX = (int)Math.floor(chunk.field_77276_a / 32);
        int rZ = (int)Math.floor(chunk.field_77275_b / 32);
        String fileName = String.format("%d_%d%s", rX, rZ, extension);
        File file = saveFilesCached.get(fileName);
        if (file != null) {
            return file;
        }
        file = new File(saveFolder, fileName);
        if (!file.exists()) {
            if (createNew) {
                try {
                    file.createNewFile();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                return null;
            }
        }
        saveFilesCached.put(fileName, file);
        return file;
    }

    public NBTTagCompound getNBTForChunk(World world, ChunkPos chunk) {
        RegionCoordinates rc = new RegionCoordinates(chunk, world.field_73011_w.getDimension());
        if (dataCache.containsKey(rc)) {
            NBTTagCompound compound = dataCache.get(rc);
            if (compound.func_74764_b("AM2PowerData")) {
                return compound;
            }
            dataCache.remove(rc);
        }
        return this.LoadNBTFromFile(world, chunk);
    }

    private void SaveNBTToFile(World world, ChunkPos chunk, NBTTagCompound compound, boolean flushImmediate) {
        File file;
        RegionCoordinates rc = new RegionCoordinates(chunk, world.field_73011_w.getDimension());
        NBTTagCompound dataCompound = dataCache.get(rc);
        if (dataCompound == null) {
            file = this.getFileFromChunk(world, chunk, true);
            if (file == null || !file.canWrite() && !file.setWritable(true) || !file.canRead() && !file.setReadable(true)) {
                LogHelper.error("Unable to obtain file handle!  The power system data for the chunk at %d, %d will NOT be saved!  To fix this, make sure you have read/write access to the Minecraft instance folder.", chunk.field_77276_a, chunk.field_77275_b);
                return;
            }
            try {
                dataCompound = CompressedStreamTools.func_74797_a((File)file);
            }
            catch (Throwable e) {
                dataCompound = new NBTTagCompound();
            }
        }
        dataCompound.func_74782_a(this.getPNDIdentifier(chunk), (NBTBase)compound);
        if (flushImmediate) {
            file = this.getFileFromChunk(world, chunk, true);
            if (file == null || !file.canWrite() && !file.setWritable(true) || !file.canRead() && !file.setReadable(true)) {
                LogHelper.error("Unable to obtain file handle!  The power system data for the chunk at %d, %d will NOT be saved!  To fix this, make sure you have read/write access to the Minecraft instance folder.", chunk.field_77276_a, chunk.field_77275_b);
                return;
            }
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)dataCompound, (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private NBTTagCompound LoadNBTFromFile(World world, ChunkPos chunk) {
        RegionCoordinates rc = new RegionCoordinates(chunk, world.field_73011_w.getDimension());
        NBTTagCompound dataCompound = dataCache.get(rc);
        if (dataCompound == null) {
            File file = this.getFileFromChunk(world, chunk, false);
            if (file == null) {
                return null;
            }
            if (!file.canRead() && !file.setReadable(true)) {
                LogHelper.error("Unable to obtain readable file handle!  The power system data for the chunk at %d, %d will NOT be saved!  To fix this, make sure you have read access to the Minecraft instance folder.", chunk.field_77276_a, chunk.field_77275_b);
                return null;
            }
            try {
                dataCompound = CompressedStreamTools.func_74797_a((File)file);
            }
            catch (Throwable e) {
                dataCompound = new NBTTagCompound();
            }
            dataCache.put(rc, dataCompound);
        }
        if (dataCompound == null) {
            dataCompound = new NBTTagCompound();
            dataCache.put(rc, dataCompound);
        }
        NBTTagCompound innerCompound = dataCompound.func_74775_l(this.getPNDIdentifier(chunk));
        return innerCompound;
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K && PowerNodeRegistry.For(event.getWorld()).hasDataForChunk(event.getChunk())) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            PowerNodeRegistry.For(event.getWorld()).SaveChunkToNBT(event.getChunk().func_76632_l(), dataCompound);
            PowerNodeRegistry.For(event.getWorld()).unloadChunk(event.getChunk());
            this.SaveNBTToFile(event.getWorld(), event.getChunk().func_76632_l(), dataCompound, false);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        NBTTagCompound dataCompound = this.LoadNBTFromFile(event.getWorld(), event.getChunk().func_76632_l());
        if (dataCompound != null) {
            PowerNodeRegistry.For(event.getWorld()).LoadChunkFromNBT(event.getChunk().func_76632_l(), dataCompound);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        HashMap<ChunkPos, NBTTagCompound> saveData = PowerNodeRegistry.For(world).saveAll();
        for (ChunkPos pair : saveData.keySet()) {
            this.SaveNBTToFile(world, pair, saveData.get(pair), ArsMagica2.config.savePowerDataOnWorldSave());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        this.saveWorldToFile(world);
    }

    public void saveWorldToFile(World world) {
        if (world.field_72995_K) {
            return;
        }
        LogHelper.trace("Saving all cached power data for DIM %d to disk", world.field_73011_w.getDimension());
        Iterator<RegionCoordinates> it = dataCache.keySet().iterator();
        while (it.hasNext()) {
            RegionCoordinates rc = it.next();
            if (rc.dimension != world.field_73011_w.getDimension()) continue;
            it.remove();
        }
        HashMap<ChunkPos, NBTTagCompound> saveData = PowerNodeRegistry.For(world).saveAll();
        for (ChunkPos pair : saveData.keySet()) {
            this.SaveNBTToFile(world, pair, saveData.get(pair), true);
        }
        PowerNodeRegistry.For(world).unloadAll();
        saveDirs.remove(world.field_73011_w.getDimension());
    }

    private String getPNDIdentifier(ChunkPos chunk) {
        return String.format(pndID, chunk.field_77276_a, chunk.field_77275_b);
    }
}

